/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.dialog;

import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.amalgam.explorer.activity.ui.api.dialog.Messages;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.FormHelper;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.statushandlers.StatusManager;

public class DescriptionDialog
extends PopupDialog {
    private Point _anchor;
    private Composite _composite;
    private FormToolkit _toolkit;
    private String _content;

    public DescriptionDialog(Shell parent, String content_p) {
        super(parent, 0, true, false, false, false, false, null, null);
        this._anchor = parent.getDisplay().getCursorLocation();
        this._toolkit = new FormToolkit(parent.getDisplay());
        this._content = content_p;
    }

    public boolean close() {
        if (this._toolkit != null) {
            this._toolkit.dispose();
            this._toolkit = null;
        }
        return super.close();
    }

    protected Control createContents(Composite parent) {
        this.getShell().setBackground(this.getShell().getDisplay().getSystemColor(16));
        this.initializeBounds();
        return this.createDialogArea(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this._composite = (Composite)super.createDialogArea(parent);
        ScrolledForm form = this._toolkit.createScrolledForm(this._composite);
        this._toolkit.decorateFormHeading(form.getForm());
        form.getToolBarManager().add((IAction)new CloseAction());
        form.getToolBarManager().update(true);
        TableWrapLayout layout = new TableWrapLayout();
        layout.leftMargin = 10;
        layout.rightMargin = 10;
        layout.topMargin = 10;
        layout.verticalSpacing = 10;
        form.getBody().setLayout((Layout)layout);
        FormText richText = FormHelper.createRichText(this._toolkit, form.getBody(), this._content, null);
        this.configureHyperLinkSupport(richText, form);
        TableWrapData layoutData = new TableWrapData();
        layoutData.maxWidth = 400;
        richText.setLayoutData((Object)layoutData);
        return this._composite;
    }

    private void configureHyperLinkSupport(FormText richText, ScrolledForm form) {
        Display disaply = form.getDisplay();
        HyperlinkGroup group = new HyperlinkGroup(disaply);
        group.setForeground(disaply.getSystemColor(9));
        group.setActiveForeground(disaply.getSystemColor(9));
        richText.setHyperlinkSettings((HyperlinkSettings)group);
        richText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String href = (String)e.getHref();
                if (href.startsWith("http")) {
                    int browserStyle = 142;
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    try {
                        browserSupport.createBrowser(browserStyle, null, null, null).openURL(new URL(href));
                    }
                    catch (Exception ex) {
                        Status status = new Status(4, null, MessageFormat.format(Messages.DescriptionDialog_exernal_browser_error, ex.getMessage()), (Throwable)ex);
                        StatusManager.getManager().handle((IStatus)status, 2);
                    }
                }
            }
        });
    }

    protected Control getFocusControl() {
        return this._composite;
    }

    protected Point getInitialLocation(Point size) {
        if (this._anchor == null) {
            return super.getInitialLocation(size);
        }
        Point point = this._anchor;
        Rectangle monitor = this.getShell().getMonitor().getClientArea();
        if (monitor.width < point.x + size.x) {
            point.x = Math.max(0, point.x - size.x);
        }
        if (monitor.height < point.y + size.y) {
            point.y = Math.max(0, point.y - size.y);
        }
        return point;
    }

    private class CloseAction
    extends Action {
        private CloseAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE");
        }

        public String getToolTipText() {
            return Messages.DescriptionDialog_CloseAction_Title;
        }

        public void run() {
            DescriptionDialog.this.close();
        }
    }
}

