/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.hyperlinkadapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.amalgam.explorer.activity.ui.api.hyperlinkadapter.AbstractHyperlinkAdapter;
import org.eclipse.amalgam.explorer.activity.ui.api.hyperlinkadapter.IRepresentationProvider;
import org.eclipse.amalgam.explorer.activity.ui.api.hyperlinkadapter.Messages;
import org.eclipse.amalgam.explorer.activity.ui.internal.util.ActivityExplorerLoggerService;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions.NewRepresentationAction;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;

public abstract class AbstractNewDiagramHyperlinkAdapter
extends AbstractHyperlinkAdapter
implements IRepresentationProvider {
    public AbstractNewDiagramHyperlinkAdapter(EObject project) {
        super(project);
    }

    protected boolean createDiagram(final EObject project, final Session session) {
        final boolean[] flag = new boolean[]{true};
        if (project != null && session != null) {
            RecordingCommand cmd = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)project)){

                protected void doExecute() {
                    EObject modelElement = project;
                    RepresentationDescription diagramRepresentation = AbstractNewDiagramHyperlinkAdapter.this.getDiagramRepresentation(session, modelElement);
                    if (diagramRepresentation == null || !DialectManager.INSTANCE.canCreate(modelElement, diagramRepresentation)) {
                        flag[0] = false;
                    } else {
                        Collection<Layer> layers = AbstractNewDiagramHyperlinkAdapter.this.getExtraLayers(session, diagramRepresentation);
                        Collection<FilterDescription> filters = AbstractNewDiagramHyperlinkAdapter.this.getExtraFilters(session, diagramRepresentation);
                        NewRepresentationAction newDiagramAction = new NewRepresentationAction(diagramRepresentation, modelElement, session, false, true, layers, filters);
                        newDiagramAction.run();
                    }
                }
            };
            TransactionUtil.getEditingDomain((EObject)project).getCommandStack().execute((Command)cmd);
        } else {
            flag[0] = false;
        }
        return flag[0];
    }

    @Override
    protected void linkPressed(HyperlinkEvent event, EObject root, Session session) {
        if (root != null && !this.createDiagram(root, session)) {
            this.handleDiagramCreationError(event, root);
        }
    }

    protected void handleDiagramCreationError(HyperlinkEvent event, EObject project) {
        String msg = String.valueOf(Messages.AbstractNewDiagramHyperlinkAdapter_DiagramCreation_Error_Msg_Part1) + this.getRepresentationName() + Messages.AbstractNewDiagramHyperlinkAdapter_DiagramCreation_Error_Msg_Part2;
        AbstractHyperlink widget = (AbstractHyperlink)event.widget;
        MessageDialog.openError((Shell)widget.getDisplay().getActiveShell(), (String)widget.getText(), (String)msg);
    }

    protected RepresentationDescription getDiagramRepresentation(Session session, EObject modelElement) {
        try {
            Collection activeViewpoints = session.getSelectedViewpoints(false);
            Collection diagramDescriptions = DialectManager.INSTANCE.getAvailableRepresentationDescriptions(activeViewpoints, modelElement);
            String diagramName = this.getRepresentationName();
            for (RepresentationDescription diagramDescription : diagramDescriptions) {
                if (!diagramName.equals(diagramDescription.getName())) continue;
                return diagramDescription;
            }
        }
        catch (Throwable e) {
            StringBuilder message = new StringBuilder();
            message.append("AvstractNewDiagramHyperlinkAdapter.getDiagramRepresentation(..) _ ");
            message.append("Could not retrieve a representation name from contribution. See the error stack for more details.");
            ActivityExplorerLoggerService.getInstance().log(4, message.toString(), e);
        }
        return null;
    }

    public abstract String getRepresentationName();

    private Collection<Layer> getExtraLayers(Session session, RepresentationDescription desc) {
        ArrayList<Layer> extra = new ArrayList<Layer>();
        if (desc instanceof DiagramDescription) {
            for (Layer l : new DiagramComponentizationManager().getAllLayers(session.getSelectedViewpoints(false), (DiagramDescription)desc)) {
                if (!this.getExtraLayerNames().contains(l.getName())) continue;
                extra.add(l);
            }
        }
        return extra;
    }

    private Collection<FilterDescription> getExtraFilters(Session session, RepresentationDescription desc) {
        ArrayList<FilterDescription> extra = new ArrayList<FilterDescription>();
        if (desc instanceof DiagramDescription) {
            for (FilterDescription d : ((DiagramDescription)desc).getFilters()) {
                if (!this.getExtraFilterNames().contains(d.getName())) continue;
                extra.add(d);
            }
        }
        return extra;
    }

    protected Collection<String> getExtraLayerNames() {
        return Collections.emptyList();
    }

    protected Collection<String> getExtraFilterNames() {
        return Collections.emptyList();
    }

    @Override
    public Set<String> getRepresentationNames() {
        return Collections.singleton(this.getRepresentationName());
    }
}

