/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.logical.IModelResolverRegistry;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;

public class ModelResolverRegistryListener
extends AbstractRegistryEventListener {
    private static final String TAG_RESOLVER = "resolver";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_RANKING = "ranking";
    private final IModelResolverRegistry registry;

    public ModelResolverRegistryListener(String pluginID, String extensionPointID, ILog log, IModelResolverRegistry registry) {
        super(pluginID, extensionPointID, log);
        this.registry = registry;
    }

    protected boolean addedValid(IConfigurationElement element) {
        if (element.getName().equals(TAG_RESOLVER)) {
            IModelResolver resolver;
            String className = element.getAttribute(ATTRIBUTE_CLASS);
            try {
                resolver = (IModelResolver)element.createExecutableExtension(ATTRIBUTE_CLASS);
            }
            catch (CoreException e) {
                String message = EMFCompareIDEUIMessages.getString("ModelResolverRegistry.invalidResolver", className);
                this.log(element, message, e);
                return false;
            }
            assert (resolver != null);
            String rankingStr = element.getAttribute(ATTRIBUTE_RANKING);
            int ranking = -1;
            try {
                ranking = Integer.parseInt(rankingStr);
            }
            catch (NumberFormatException numberFormatException) {
                this.log(4, element, EMFCompareIDEUIMessages.getString("ModelResolverRegistry.invalidRanking", className, rankingStr));
            }
            resolver.setRanking(ranking);
            resolver.initialize();
            this.registry.addResolver(className, resolver);
            return true;
        }
        return false;
    }

    protected boolean removedValid(IConfigurationElement element) {
        String className = element.getAttribute(ATTRIBUTE_CLASS);
        IModelResolver resolver = this.registry.removeResolver(className);
        if (resolver != null) {
            resolver.dispose();
        }
        return true;
    }

    protected boolean validateExtensionElement(IConfigurationElement element) {
        return true;
    }
}

