/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.progress;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.emf.compare.ide.ui.internal.progress.JobProgressInfoComposite;

public final class JobProgressMonitorWrapper
extends ProgressMonitorWrapper {
    private final JobProgressInfoComposite progressInfoItem;
    private int totalWork;
    private double worked;

    public JobProgressMonitorWrapper(IProgressMonitor monitor, JobProgressInfoComposite progressInfoItem) {
        super(monitor);
        this.progressInfoItem = progressInfoItem;
    }

    public void beginTask(String name, int totalWork) {
        this.totalWork = totalWork;
        this.worked = 0.0;
        this.progressInfoItem.init();
        this.progressInfoItem.setTaskName(name);
        super.beginTask(name, totalWork);
    }

    public void setTaskName(String name) {
        this.progressInfoItem.setPercentDone(this.getPercentDone());
        super.setTaskName(name);
    }

    public void subTask(String name) {
        this.progressInfoItem.setTaskName(name);
        super.subTask(name);
    }

    public void worked(int work) {
        this.worked += (double)work;
        int percentDone = this.getPercentDone();
        this.progressInfoItem.setPercentDone(percentDone);
        super.worked(work);
    }

    private int getPercentDone() {
        return Math.min((int)(this.worked * 100.0 / (double)this.totalWork), 100);
    }
}

