/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.compare.INavigatable;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.CollapseAllModelAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.DropDownMergeMenuAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.ExpandAllModelAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeAllNonConflictingAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.SaveComparisonModelAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.SelectNextDiffAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.SelectPreviousDiffAction;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ICompareEditingDomainChange;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IComparisonAndScopeChange;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.actions.FilterActionMenu;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.actions.GroupActionMenu;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.IDifferenceFilterChange;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.CascadingDifferencesFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.StructureMergeViewerGrouper;
import org.eclipse.emf.compare.rcp.ui.internal.util.SWTUtil;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IMenuService;

public class CompareToolBar
implements ISelectionChangedListener {
    private final GroupActionMenu groupActionMenu;
    private final FilterActionMenu filterActionMenu;
    private final List<MergeAction> mergeActions;
    private final List<MergeAllNonConflictingAction> mergeAllNonConflictingActions;
    private final EMFCompareConfiguration compareConfiguration;

    public CompareToolBar(StructureMergeViewerGrouper viewerGrouper, StructureMergeViewerFilter viewerFilter, EMFCompareConfiguration compareConfiguration) {
        this.compareConfiguration = compareConfiguration;
        this.mergeActions = Lists.newArrayListWithCapacity((int)2);
        this.mergeAllNonConflictingActions = Lists.newArrayListWithCapacity((int)2);
        this.groupActionMenu = new GroupActionMenu(viewerGrouper, EMFCompareRCPUIPlugin.getDefault().getDifferenceGroupProviderRegistry());
        this.filterActionMenu = new FilterActionMenu(viewerFilter, EMFCompareRCPUIPlugin.getDefault().getDifferenceFilterRegistry());
    }

    public final void initToolbar(ToolBarManager toolbarManager, AbstractTreeViewer viewer, INavigatable nav) {
        this.compareConfiguration.getEventBus().register((Object)this);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IMenuService menuService = (IMenuService)workbench.getService(IMenuService.class);
        if (menuService != null) {
            menuService.populateContributionManager((ContributionManager)toolbarManager, "toolbar:org.eclipse.emf.compare.structuremergeviewer.toolbar");
        }
        boolean leftEditable = this.compareConfiguration.isLeftEditable();
        boolean rightEditable = this.compareConfiguration.isRightEditable();
        EnumSet<MergeMode> modes = rightEditable && leftEditable ? EnumSet.of(MergeMode.RIGHT_TO_LEFT, MergeMode.LEFT_TO_RIGHT) : EnumSet.of(MergeMode.ACCEPT, MergeMode.REJECT);
        toolbarManager.add((IAction)new DropDownMergeMenuAction(this.compareConfiguration, modes));
        for (MergeMode mode : modes) {
            toolbarManager.add((IAction)this.createMergeAction(mode, this.compareConfiguration, nav));
        }
        for (MergeMode mode : modes) {
            toolbarManager.add((IAction)this.createMergeAllNonConflictingAction(mode, this.compareConfiguration));
        }
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)new SelectNextDiffAction(nav));
        toolbarManager.add((IAction)new SelectPreviousDiffAction(nav));
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)new ExpandAllModelAction(viewer));
        toolbarManager.add((IAction)new CollapseAllModelAction(viewer));
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)this.groupActionMenu);
        this.groupActionMenu.updateMenu(this.compareConfiguration.getComparisonScope(), this.compareConfiguration.getComparison());
        toolbarManager.add((IAction)this.filterActionMenu);
        this.filterActionMenu.updateMenu(this.compareConfiguration.getComparisonScope(), this.compareConfiguration.getComparison());
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)new SaveComparisonModelAction(this.compareConfiguration));
        toolbarManager.update(true);
    }

    private MergeAction createMergeAction(MergeMode mergeMode, EMFCompareConfiguration cc, INavigatable nav) {
        IMerger.Registry mergerRegistry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
        MergeAction mergeAction = new MergeAction(cc.getEditingDomain(), mergerRegistry, mergeMode, cc.isLeftEditable(), cc.isRightEditable(), nav);
        this.mergeActions.add(mergeAction);
        return mergeAction;
    }

    private MergeAction createMergeAllNonConflictingAction(MergeMode mergeMode, IEMFCompareConfiguration cc) {
        IMerger.Registry mergerRegistry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
        MergeAllNonConflictingAction mergeAction = new MergeAllNonConflictingAction(cc.getEditingDomain(), cc.getComparison(), mergerRegistry, mergeMode, cc.isLeftEditable(), cc.isRightEditable());
        this.mergeAllNonConflictingActions.add(mergeAction);
        return mergeAction;
    }

    public void dispose() {
        this.compareConfiguration.getEventBus().unregister((Object)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        for (MergeAction mergeAction : this.mergeActions) {
            mergeAction.selectionChanged(event);
        }
        for (MergeAllNonConflictingAction mergeAllNonConflictingAction : this.mergeAllNonConflictingActions) {
            mergeAllNonConflictingAction.selectionChanged(event);
        }
    }

    @Subscribe
    public void editingDomainChange(ICompareEditingDomainChange event) {
        for (MergeAction mergeAction : this.mergeActions) {
            mergeAction.setEditingDomain(event.getNewValue());
        }
        for (MergeAction mergeAction : this.mergeAllNonConflictingActions) {
            mergeAction.setEditingDomain(event.getNewValue());
        }
    }

    @Subscribe
    public void selectedDifferenceFiltersChange(IDifferenceFilterChange event) {
        boolean enabled = Iterables.any((Iterable)event.getSelectedDifferenceFilters(), (Predicate)Predicates.instanceOf(CascadingDifferencesFilter.class));
        for (MergeAction mergeAction : this.mergeActions) {
            mergeAction.setCascadingDifferencesFilterEnabled(enabled);
        }
    }

    @Subscribe
    public void comparisonAndScopeChange(final IComparisonAndScopeChange event) {
        SWTUtil.safeAsyncExec((Runnable)new Runnable(){

            public void run() {
                CompareToolBar.this.filterActionMenu.updateMenu(event.getNewScope(), event.getNewComparison());
                CompareToolBar.this.groupActionMenu.updateMenu(event.getNewScope(), event.getNewComparison());
            }
        });
        for (MergeAllNonConflictingAction mergeAction : this.mergeAllNonConflictingActions) {
            mergeAction.setComparison(event.getNewComparison());
        }
    }
}

