/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.label.NoDifferencesCompareInput;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.label.NoVisibleItemCompareInput;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.EMFCompareColor;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.RedoAction;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.UndoAction;
import org.eclipse.emf.compare.ide.ui.internal.editor.ComparisonScopeInput;
import org.eclipse.emf.compare.ide.ui.internal.logical.ComparisonScopeBuilder;
import org.eclipse.emf.compare.ide.ui.internal.logical.EmptyComparisonScope;
import org.eclipse.emf.compare.ide.ui.internal.progress.JobProgressInfoComposite;
import org.eclipse.emf.compare.ide.ui.internal.progress.JobProgressMonitorWrapper;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.AbstractStructuredViewerWrapper;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareInputAdapter;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareToolBar;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.DependencyData;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareDiffTreeRuler;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerLabelProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.ForwardingCompareInputAdapter;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.Navigatable;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.ProblemIndicationComposite;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.WrappableTreeViewer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeAction;
import org.eclipse.emf.compare.ide.ui.internal.util.CompareHandlerService;
import org.eclipse.emf.compare.ide.ui.internal.util.JFaceUtil;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ICompareEditingDomainChange;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IMergePreviewModeChange;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.SideLabelProvider;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.IColorChangeEvent;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.PseudoConflictsFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.StructureMergeViewerGrouper;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.TreeItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.rcp.ui.internal.util.SWTUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDifferenceFilterChange;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProviderChange;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.IDiagnosable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.tree.TreeFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFCompareStructureMergeViewer
extends AbstractStructuredViewerWrapper<CTabFolder, WrappableTreeViewer>
implements CommandStackListener {
    private static final Predicate<Diff> UNRESOLVED_AND_WITHOUT_PSEUDO_CONFLICT = Predicates.and((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})));
    private static final int TREE_RULER_WIDTH = 17;
    private static final Predicate<? super Object> IS_DIFF = new Predicate<Object>(){

        public boolean apply(Object object) {
            return EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(object) instanceof Diff;
        }
    };
    private ComposedAdapterFactory fAdapterFactory;
    private EMFCompareDiffTreeRuler treeRuler;
    private final ICompareInputChangeListener fCompareInputChangeListener;
    private ITreeViewerListener fWrappedTreeListener;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private CompareHandlerService fHandlerService;
    private boolean resourcesShouldBeUnload;
    private DependencyData dependencyData;
    private ISelectionChangedListener selectionChangeListener;
    private final Listener fEraseItemListener;
    private JobProgressInfoComposite progressInfoItem;
    private Job inputChangedTask;
    private CompareToolBar toolBar;
    private boolean pseudoConflictsFilterEnabled;
    private Navigatable navigatable;
    private EMFCompareColor fColors;
    private boolean editingDomainNeedsToBeDisposed;
    private EMFCompareStructureMergeViewerContentProvider.FetchListener toolbarUpdaterContentProviderListener;

    public EMFCompareStructureMergeViewer(Composite parent, EMFCompareConfiguration config) {
        super(parent, config);
        this.updateLayout(true, false);
        StructureMergeViewerFilter structureMergeViewerFilter = this.getCompareConfiguration().getStructureMergeViewerFilter();
        ((WrappableTreeViewer)this.getViewer()).addFilter((ViewerFilter)structureMergeViewerFilter);
        StructureMergeViewerGrouper structureMergeViewerGrouper = this.getCompareConfiguration().getStructureMergeViewerGrouper();
        structureMergeViewerGrouper.install((StructuredViewer)this.getViewer());
        this.fCompareInputChangeListener = new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput input) {
                EMFCompareStructureMergeViewer.this.compareInputChanged(input);
            }
        };
        this.setContentProvider((IContentProvider)new EMFCompareStructureMergeViewerContentProvider(this.getCompareConfiguration().getAdapterFactory(), (AbstractTreeViewer)this.getViewer()));
        this.navigatable = new Navigatable((WrappableTreeViewer)this.getViewer(), this.getContentProvider());
        this.toolBar = new CompareToolBar(CompareViewerPane.getToolBarManager((Composite)parent), structureMergeViewerGrouper, structureMergeViewerFilter, this.getCompareConfiguration());
        ((WrappableTreeViewer)this.getViewer()).addSelectionChangedListener(this.toolBar);
        this.createContextMenu();
        this.selectionChangeListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EMFCompareStructureMergeViewer.this.handleSelectionChangedEvent(event);
            }
        };
        this.addSelectionChangedListener(this.selectionChangeListener);
        this.fWrappedTreeListener = new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                EMFCompareStructureMergeViewer.this.treeRuler.redraw();
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                EMFCompareStructureMergeViewer.this.treeRuler.redraw();
            }
        };
        ((WrappableTreeViewer)this.getViewer()).addTreeListener(this.fWrappedTreeListener);
        this.fEraseItemListener = new Listener(){

            public void handleEvent(Event event) {
                EMFCompareStructureMergeViewer.this.handleEraseItemEvent(event);
            }
        };
        ((WrappableTreeViewer)this.getViewer()).getControl().addListener(40, this.fEraseItemListener);
        this.fHandlerService = CompareHandlerService.createFor(this.getCompareConfiguration().getContainer(), ((CTabFolder)this.getControl()).getShell());
        this.toolbarUpdaterContentProviderListener = new EMFCompareStructureMergeViewerContentProvider.FetchListener(){

            public void startFetching() {
                EMFCompareStructureMergeViewer.this.toolBar.setEnabled(false);
            }

            public void doneFetching() {
                EMFCompareStructureMergeViewer.this.toolBar.setEnabled(true);
            }
        };
        this.getContentProvider().addFetchingListener(this.toolbarUpdaterContentProviderListener);
        this.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new EMFCompareStructureMergeViewerLabelProvider(this.getCompareConfiguration().getAdapterFactory(), (Viewer)this)));
        this.undoAction = new UndoAction(this.getCompareConfiguration().getEditingDomain());
        this.redoAction = new RedoAction(this.getCompareConfiguration().getEditingDomain());
        this.editingDomainChange(null, this.getCompareConfiguration().getEditingDomain());
        this.inputChangedTask.setPriority(30);
        config.getEventBus().register((Object)this);
    }

    private void initToolbar() {
        SWTUtil.safeAsyncExec((Runnable)new Runnable(){

            public void run() {
                EMFCompareStructureMergeViewer.this.toolBar.initToolbar((AbstractTreeViewer)EMFCompareStructureMergeViewer.this.getViewer(), EMFCompareStructureMergeViewer.this.navigatable);
            }
        });
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EMFCompareStructureMergeViewer.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(((WrappableTreeViewer)this.getViewer()).getControl());
        ((WrappableTreeViewer)this.getViewer()).getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        if (!this.isDiffSelected()) {
            return;
        }
        boolean leftEditable = this.getCompareConfiguration().isLeftEditable();
        boolean rightEditable = this.getCompareConfiguration().isRightEditable();
        EnumSet<MergeMode> modes = rightEditable && leftEditable ? EnumSet.of(MergeMode.RIGHT_TO_LEFT, MergeMode.LEFT_TO_RIGHT) : EnumSet.of(MergeMode.ACCEPT, MergeMode.REJECT);
        if (rightEditable || leftEditable) {
            for (MergeMode mode : modes) {
                IMerger.Registry mergerRegistry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
                MergeAction mergeAction = new MergeAction(this.getCompareConfiguration().getEditingDomain(), mergerRegistry, mode, leftEditable, rightEditable, this.navigatable, (IStructuredSelection)this.getSelection());
                manager.add((IAction)mergeAction);
            }
        }
    }

    private boolean isDiffSelected() {
        Object element;
        ISelection selection = this.getSelection();
        return selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(element = ((IStructuredSelection)selection).getFirstElement()) instanceof Diff;
    }

    @Override
    protected void preHookCreateControlAndViewer() {
        this.fAdapterFactory = new ComposedAdapterFactory((ComposedAdapterFactory.Descriptor.Registry)EMFCompareRCPPlugin.getDefault().createFilteredAdapterFactoryRegistry());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new TreeItemProviderAdapterFactorySpec());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.getCompareConfiguration().setAdapterFactory((AdapterFactory)this.fAdapterFactory);
        this.inputChangedTask = new CompareInputChangedJob(EMFCompareIDEUIMessages.getString("EMFCompareStructureMergeViewer.computingModelDifferences"));
    }

    @Subscribe
    public void colorChanged(IColorChangeEvent changeColorEvent) {
        this.internalRedraw();
    }

    @Override
    protected AbstractStructuredViewerWrapper.ControlAndViewer<CTabFolder, WrappableTreeViewer> createControlAndViewer(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        CTabFolder tabFolder = new CTabFolder(parent, 0x800400);
        tabFolder.setLayout((Layout)new FillLayout());
        tabFolder.addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    EMFCompareStructureMergeViewer.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.updateProblemIndication(Diagnostic.OK_INSTANCE);
        Composite control = new Composite((Composite)tabFolder, 0);
        this.createItem(0, (Control)control);
        tabFolder.setSelection(0);
        GridData data = new GridData(4, 4, true, true);
        control.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        control.setLayout((Layout)layout);
        this.progressInfoItem = new JobProgressInfoComposite(this.inputChangedTask, control, 65792, 0);
        this.progressInfoItem.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.progressInfoItem.setBackground(Display.getDefault().getSystemColor(25));
        WrappableTreeViewer treeViewer = new WrappableTreeViewer(control, 770){

            public boolean isExpandable(Object element) {
                if (element instanceof PendingUpdateAdapter) {
                    return false;
                }
                if (this.hasFilters()) {
                    return this.getFilteredChildren(element).length > 0;
                }
                return super.isExpandable(element);
            }
        };
        treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        treeViewer.setUseHashlookup(true);
        this.dependencyData = new DependencyData(this.getCompareConfiguration(), treeViewer);
        tabFolder.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)EMFCompareIDEUIMessages.getString("EMFCompareStructureMergeViewer.title"));
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        ITheme currentTheme = themeManager != null ? themeManager.getCurrentTheme() : null;
        boolean leftIsLocal = this.getCompareConfiguration().getBooleanProperty("LEFT_IS_LOCAL", false);
        this.fColors = new EMFCompareColor(control.getDisplay(), leftIsLocal, currentTheme, this.getCompareConfiguration().getEventBus());
        this.treeRuler = new EMFCompareDiffTreeRuler(control, 0, treeViewer, this.dependencyData, (ICompareColor)this.fColors);
        GridData rulerLayoutData = new GridData(4, 4, false, true);
        rulerLayoutData.exclude = true;
        rulerLayoutData.widthHint = 17;
        rulerLayoutData.minimumWidth = 17;
        this.treeRuler.setLayoutData(rulerLayoutData);
        return AbstractStructuredViewerWrapper.ControlAndViewer.create(tabFolder, treeViewer);
    }

    public EMFCompareStructureMergeViewerContentProvider getContentProvider() {
        return (EMFCompareStructureMergeViewerContentProvider)super.getContentProvider();
    }

    private CTabItem createItem(int index, Control control) {
        CTabItem item = new CTabItem((CTabFolder)control.getParent(), 0, index);
        item.setControl(control);
        return item;
    }

    @Subscribe
    public void handleEditingDomainChange(ICompareEditingDomainChange event) {
        this.editingDomainChange(event.getOldValue(), event.getNewValue());
    }

    private void editingDomainChange(ICompareEditingDomain oldValue, ICompareEditingDomain newValue) {
        if (newValue != oldValue) {
            if (oldValue != null) {
                oldValue.getCommandStack().removeCommandStackListener((CommandStackListener)this);
            }
            if (newValue != null) {
                newValue.getCommandStack().addCommandStackListener((CommandStackListener)this);
            }
            this.undoAction.setEditingDomain(newValue);
            this.redoAction.setEditingDomain(newValue);
        }
    }

    private void refreshTitle() {
        Composite parent = ((CTabFolder)this.getControl()).getParent();
        if (parent instanceof CompareViewerSwitchingPane) {
            int displayedDiff = JFaceUtil.filterVisibleElement((TreeViewer)this.getViewer(), IS_DIFF).size();
            Comparison comparison = this.getCompareConfiguration().getComparison();
            if (comparison != null) {
                EList differences = comparison.getDifferences();
                int computedDiff = this.pseudoConflictsFilterEnabled ? Iterables.size((Iterable)Iterables.filter((Iterable)differences, (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})))) : differences.size();
                int filteredDiff = differences.size() - displayedDiff;
                if (filteredDiff < 0) {
                    filteredDiff = 0;
                }
                int differencesToMerge = this.pseudoConflictsFilterEnabled ? Iterables.size((Iterable)Iterables.filter((Iterable)differences, UNRESOLVED_AND_WITHOUT_PSEUDO_CONFLICT)) : Iterables.size((Iterable)Iterables.filter((Iterable)differences, (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})));
                ((CompareViewerSwitchingPane)parent).setTitleArgument(EMFCompareIDEUIMessages.getString("EMFCompareStructureMergeViewer.titleDesc", differencesToMerge, computedDiff, filteredDiff));
            }
        }
    }

    static EObject getDataOfTreeNodeOfAdapter(Object object) {
        Notifier target;
        EObject data = null;
        if (object instanceof Adapter && (target = ((Adapter)object).getTarget()) instanceof TreeNode) {
            data = ((TreeNode)target).getData();
        }
        return data;
    }

    @Subscribe
    public void mergePreviewModeChange(IMergePreviewModeChange event) {
        final IMerger.Registry registry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
        SWTUtil.safeAsyncExec((Runnable)new Runnable(){

            public void run() {
                EMFCompareStructureMergeViewer.this.dependencyData.updateDependencies(EMFCompareStructureMergeViewer.this.getSelection(), registry);
                EMFCompareStructureMergeViewer.this.internalRedraw();
            }
        });
    }

    @Subscribe
    public void handleDifferenceFilterChange(IDifferenceFilterChange event) {
        this.pseudoConflictsFilterEnabled = Iterables.any((Iterable)event.getSelectedDifferenceFilters(), (Predicate)Predicates.instanceOf(PseudoConflictsFilter.class));
        SWTUtil.safeRefresh((Viewer)this, (boolean)false, (boolean)true);
        this.getContentProvider().runWhenReady(EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_UI_ASYNC, new Runnable(){

            public void run() {
                if (EMFCompareStructureMergeViewer.this.navigatable != null && (EMFCompareStructureMergeViewer.this.navigatable.getViewer().getSelection() == null || EMFCompareStructureMergeViewer.this.navigatable.getViewer().getSelection().isEmpty())) {
                    EMFCompareStructureMergeViewer.this.selectFirstDiffOrDisplayLabelViewer(EMFCompareStructureMergeViewer.this.getCompareConfiguration().getComparison());
                }
            }
        });
    }

    @Subscribe
    public void handleDifferenceGroupProviderChange(IDifferenceGroupProviderChange event) {
        SWTUtil.safeRefresh((Viewer)this, (boolean)false, (boolean)true);
        this.getContentProvider().runWhenReady(EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_UI_ASYNC, new Runnable(){

            public void run() {
                EMFCompareStructureMergeViewer.this.selectFirstDiffOrDisplayLabelViewer(EMFCompareStructureMergeViewer.this.getCompareConfiguration().getComparison());
            }
        });
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (oldInput instanceof ICompareInput) {
            ICompareInput old = (ICompareInput)oldInput;
            old.removeCompareInputChangeListener(this.fCompareInputChangeListener);
            this.toolBar.dispose();
        }
        if (input instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)input;
            ci.addCompareInputChangeListener(this.fCompareInputChangeListener);
            this.compareInputChanged(ci);
        }
    }

    @Override
    protected void handleDispose(DisposeEvent event) {
        if (this.fHandlerService != null) {
            this.fHandlerService.dispose();
        }
        this.getCompareConfiguration().getEventBus().unregister((Object)this);
        ((WrappableTreeViewer)this.getViewer()).removeTreeListener(this.fWrappedTreeListener);
        Object input = this.getInput();
        if (input instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)input;
            ci.removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        this.removeSelectionChangedListener(this.selectionChangeListener);
        ((WrappableTreeViewer)this.getViewer()).removeSelectionChangedListener(this.toolBar);
        ((WrappableTreeViewer)this.getViewer()).getTree().removeListener(40, this.fEraseItemListener);
        if (this.editingDomainNeedsToBeDisposed) {
            ((IDisposable)this.getCompareConfiguration().getEditingDomain()).dispose();
        }
        this.compareInputChanged(null);
        this.treeRuler.handleDispose();
        this.fAdapterFactory.dispose();
        this.toolBar.dispose();
        this.fColors.dispose();
        super.handleDispose(event);
    }

    public void commandStackChanged(EventObject event) {
        Collection affectedObjects;
        this.undoAction.update();
        this.redoAction.update();
        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
        if (mostRecentCommand instanceof ICompareCopyCommand && !(affectedObjects = mostRecentCommand.getAffectedObjects()).isEmpty()) {
            Iterator affectedIterator = Iterables.filter((Iterable)affectedObjects, EObject.class).iterator();
            IDifferenceGroupProvider groupProvider = this.getCompareConfiguration().getStructureMergeViewerGrouper().getProvider();
            TreeNode unfilteredNode = null;
            while (affectedIterator.hasNext() && unfilteredNode == null) {
                EObject affected = (EObject)affectedIterator.next();
                List treeNodes = groupProvider.getTreeNodes(affected);
                for (TreeNode node : treeNodes) {
                    if (JFaceUtil.isFiltered((StructuredViewer)this.getViewer(), node, node.getParent())) continue;
                    unfilteredNode = node;
                }
            }
            if (unfilteredNode != null) {
                final Adapter adaptedAffectedObject = this.fAdapterFactory.adapt(unfilteredNode, ICompareInput.class);
                SWTUtil.safeSyncExec((Runnable)new Runnable(){

                    public void run() {
                        EMFCompareStructureMergeViewer.this.refresh();
                        StructuredSelection selection = new StructuredSelection(adaptedAffectedObject);
                        ((WrappableTreeViewer)EMFCompareStructureMergeViewer.this.getViewer()).setSelection((ISelection)selection);
                    }
                });
                SWTUtil.safeAsyncExec((Runnable)new Runnable(){

                    public void run() {
                        EMFCompareStructureMergeViewer.this.navigatable.openSelectedChange();
                    }
                });
            }
        }
    }

    void compareInputChanged(ICompareInput input) {
        if (input == null) {
            this.compareInputChanged((ICompareInput)null, (IProgressMonitor)new NullProgressMonitor());
            return;
        }
        if (this.getCompareConfiguration() != null) {
            this.updateLayout(true, true);
            this.inputChangedTask.schedule();
        }
    }

    void compareInputChanged(CompareInputAdapter input, IProgressMonitor monitor) {
        this.compareInputChanged(null, (Comparison)input.getComparisonObject());
    }

    void compareInputChanged(ComparisonScopeInput input, IProgressMonitor monitor) {
        EMFCompare comparator = this.getCompareConfiguration().getEMFComparator();
        IComparisonScope comparisonScope = input.getComparisonScope();
        Comparison comparison = comparator.compare(comparisonScope, BasicMonitor.toMonitor((IProgressMonitor)monitor));
        this.compareInputChanged(input.getComparisonScope(), comparison);
    }

    void compareInputChanged(IComparisonScope scope, final Comparison comparison) {
        if (!((CTabFolder)this.getControl()).isDisposed()) {
            TreeNode treeNode = TreeFactory.eINSTANCE.createTreeNode();
            treeNode.setData((EObject)comparison);
            final Adapter input = this.fAdapterFactory.adapt((Notifier)treeNode, ICompareInput.class);
            IDifferenceGroupProvider groupProvider = this.getCompareConfiguration().getStructureMergeViewerGrouper().getProvider();
            treeNode.eAdapters().add((Object)groupProvider);
            SWTUtil.safeAsyncExec((Runnable)new Runnable(){

                public void run() {
                    EMFCompareStructureMergeViewer.this.updateProblemIndication(comparison.getDiagnostic());
                }
            });
            SWTUtil.safeSyncExec((Runnable)new Runnable(){

                public void run() {
                    ((WrappableTreeViewer)EMFCompareStructureMergeViewer.this.getViewer()).setInput(input);
                }
            });
            this.getCompareConfiguration().setComparisonAndScope(comparison, scope);
            SWTUtil.safeAsyncExec((Runnable)new Runnable(){

                public void run() {
                    if (!((CTabFolder)EMFCompareStructureMergeViewer.this.getControl()).isDisposed()) {
                        EMFCompareStructureMergeViewer.this.updateLayout(false, true);
                    }
                }
            });
            this.getContentProvider().runWhenReady(EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_UI_ASYNC, new Runnable(){

                public void run() {
                    if (!((CTabFolder)EMFCompareStructureMergeViewer.this.getControl()).isDisposed()) {
                        EMFCompareStructureMergeViewer.this.dependencyData.updateTreeItemMappings();
                        EMFCompareStructureMergeViewer.this.refreshTitle();
                        EMFCompareStructureMergeViewer.this.selectFirstDiffOrDisplayLabelViewer(comparison);
                    }
                }
            });
            SWTUtil.safeAsyncExec((Runnable)new Runnable(){

                public void run() {
                    EMFCompareStructureMergeViewer.this.fHandlerService.updatePaneActionHandlers(new Runnable(){

                        public void run() {
                            EMFCompareStructureMergeViewer.this.fHandlerService.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)EMFCompareStructureMergeViewer.this.undoAction);
                            EMFCompareStructureMergeViewer.this.fHandlerService.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)EMFCompareStructureMergeViewer.this.redoAction);
                        }
                    });
                }
            });
        }
    }

    void compareInputChanged(ICompareInput input, IProgressMonitor monitor) {
        if (input != null) {
            if (input instanceof CompareInputAdapter) {
                this.resourcesShouldBeUnload = false;
                this.compareInputChanged((CompareInputAdapter)input, monitor);
            } else if (input instanceof ComparisonScopeInput) {
                this.resourcesShouldBeUnload = false;
                this.compareInputChanged((ComparisonScopeInput)input, monitor);
            } else {
                IResource resource;
                this.resourcesShouldBeUnload = true;
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                ITypedElement left = input.getLeft();
                ITypedElement right = input.getRight();
                ITypedElement origin = input.getAncestor();
                EMFCompareConfiguration compareConfiguration = this.getCompareConfiguration();
                boolean leftEditable = left instanceof ResourceNode && !(input instanceof DiffNode) ? !(resource = ((ResourceNode)left).getResource()).getResourceAttributes().isReadOnly() : compareConfiguration.isLeftEditable();
                boolean rightEditable = right instanceof ResourceNode ? !(resource = ((ResourceNode)right).getResource()).getResourceAttributes().isReadOnly() : compareConfiguration.isRightEditable();
                compareConfiguration.setLeftEditable(leftEditable);
                compareConfiguration.setRightEditable(rightEditable);
                if (leftEditable && rightEditable) {
                    compareConfiguration.setMergePreviewMode(MergeMode.RIGHT_TO_LEFT);
                } else {
                    compareConfiguration.setMergePreviewMode(MergeMode.ACCEPT);
                }
                BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.emf.compare.ide.ui", 0, null, new Object[0]);
                EmptyComparisonScope scope = null;
                try {
                    scope = ComparisonScopeBuilder.create(compareConfiguration.getContainer(), left, right, origin, (IProgressMonitor)subMonitor.newChild(85));
                }
                catch (OperationCanceledException e) {
                    scope = new EmptyComparisonScope();
                    ((BasicDiagnostic)scope.getDiagnostic()).merge((Diagnostic)new BasicDiagnostic(8, "org.eclipse.emf.compare.ide.ui", 0, EMFCompareIDEUIMessages.getString("EMFCompareStructureMergeViewer.operationCanceled"), new Object[]{e}));
                }
                catch (Exception e) {
                    scope = new EmptyComparisonScope();
                    ((BasicDiagnostic)scope.getDiagnostic()).merge(BasicDiagnostic.toDiagnostic((Throwable)e));
                    EMFCompareIDEUIPlugin.getDefault().log(e);
                }
                if (scope instanceof IDiagnosable && ((IDiagnosable)scope).getDiagnostic() != null) {
                    diagnostic.merge(((IDiagnosable)scope).getDiagnostic());
                }
                EMFCompare.Builder comparisonBuilder = EMFCompare.builder().setPostProcessorRegistry(EMFCompareRCPPlugin.getDefault().getPostProcessorRegistry());
                EMFCompareBuilderConfigurator.createDefault().configure(comparisonBuilder);
                Comparison compareResult = comparisonBuilder.build().compare((IComparisonScope)scope, BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitor.newChild(15)));
                compareResult.eAdapters().add((Object)new ForwardingCompareInputAdapter(input));
                ICompareInputLabelProvider labelProvider = this.getCompareConfiguration().getLabelProvider();
                SideLabelProvider sideLabelProvider = new SideLabelProvider(labelProvider.getAncestorLabel((Object)input), labelProvider.getLeftLabel((Object)input), labelProvider.getRightLabel((Object)input), labelProvider.getAncestorImage((Object)input), labelProvider.getLeftImage((Object)input), labelProvider.getRightImage((Object)input));
                compareResult.eAdapters().add((Object)sideLabelProvider);
                if (compareResult.getDiagnostic() != null) {
                    diagnostic.merge(compareResult.getDiagnostic());
                }
                compareResult.setDiagnostic((Diagnostic)diagnostic);
                ResourceSet leftResourceSet = (ResourceSet)scope.getLeft();
                ResourceSet rightResourceSet = (ResourceSet)scope.getRight();
                ResourceSet originResourceSet = (ResourceSet)scope.getOrigin();
                ICompareEditingDomain editingDomain = EMFCompareEditingDomain.create((Notifier)leftResourceSet, (Notifier)rightResourceSet, (Notifier)originResourceSet);
                this.editingDomainNeedsToBeDisposed = true;
                compareConfiguration.setEditingDomain(editingDomain);
                this.compareInputChanged((IComparisonScope)scope, compareResult);
            }
            this.initToolbar();
        } else {
            this.compareInputChangedToNull();
        }
    }

    private void selectFirstDiffOrDisplayLabelViewer(Comparison comparison) {
        if (comparison != null) {
            ICompareInput compareInput = (ICompareInput)EcoreUtil.getAdapter((List)comparison.eAdapters(), ICompareInput.class);
            EList differences = comparison.getDifferences();
            if (differences.isEmpty()) {
                this.navigatable.fireOpen((Object)new NoDifferencesCompareInput(compareInput));
            } else if (JFaceUtil.filterVisibleElement((TreeViewer)this.getViewer(), IS_DIFF).isEmpty()) {
                this.navigatable.fireOpen((Object)new NoVisibleItemCompareInput(compareInput));
            } else {
                this.navigatable.selectChange(3);
            }
        }
    }

    private void updateLayout(boolean displayProgress, boolean doLayout) {
        ((GridData)this.progressInfoItem.getLayoutData()).exclude = !displayProgress;
        this.progressInfoItem.setVisible(displayProgress);
        ((GridData)((WrappableTreeViewer)this.getViewer()).getControl().getLayoutData()).exclude = displayProgress;
        ((WrappableTreeViewer)this.getViewer()).getControl().setVisible(!displayProgress);
        ((GridData)this.treeRuler.getLayoutData()).exclude = displayProgress;
        this.treeRuler.setVisible(!displayProgress);
        if (doLayout) {
            ((CTabFolder)this.getControl()).layout(true, true);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void compareInputChangedToNull() {
        block10: {
            if (!this.inputChangedTask.cancel()) {
                try {
                    this.inputChangedTask.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    Throwables.propagate((Throwable)e);
                }
            }
            leftResourceSet = null;
            rightResourceSet = null;
            originResourceSet = null;
            if (this.getCompareConfiguration().getComparison() == null) break block10;
            comparison = this.getCompareConfiguration().getComparison();
            matchIt = comparison.getMatches().iterator();
            if (!comparison.isThreeWay()) ** GOTO lbl31
            while (matchIt.hasNext() && (leftResourceSet == null || rightResourceSet == null || originResourceSet == null)) {
                match = (Match)matchIt.next();
                if (leftResourceSet == null) {
                    leftResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getLeft());
                }
                if (rightResourceSet == null) {
                    rightResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getRight());
                }
                if (originResourceSet != null) continue;
                originResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getOrigin());
            }
            break block10;
lbl-1000:
            // 1 sources

            {
                match = (Match)matchIt.next();
                if (leftResourceSet == null) {
                    leftResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getLeft());
                }
                if (rightResourceSet != null) continue;
                rightResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getRight());
lbl31:
                // 3 sources

                ** while (matchIt.hasNext() && (leftResourceSet == null || rightResourceSet == null))
            }
        }
        this.editingDomainChange(this.getCompareConfiguration().getEditingDomain(), null);
        if (this.resourcesShouldBeUnload) {
            EMFCompareStructureMergeViewer.unload(leftResourceSet);
            EMFCompareStructureMergeViewer.unload(rightResourceSet);
            EMFCompareStructureMergeViewer.unload(originResourceSet);
        }
        if (this.getCompareConfiguration() != null) {
            this.getCompareConfiguration().dispose();
        }
        ((WrappableTreeViewer)this.getViewer()).setInput(null);
    }

    private void handleEraseItemEvent(Event event) {
        TreeItem item = (TreeItem)event.item;
        EObject dataItem = EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(item.getData());
        if (dataItem != null) {
            Set<Diff> requires = this.dependencyData.getRequires();
            Set<Diff> unmergeables = this.dependencyData.getUnmergeables();
            GC g = event.gc;
            if (requires.contains(dataItem)) {
                this.paintItemBackground(g, item, this.fColors.getRequiredFillColor());
            } else if (unmergeables.contains(dataItem)) {
                this.paintItemBackground(g, item, this.fColors.getUnmergeableFillColor());
            }
        }
    }

    private void paintItemBackground(GC g, TreeItem item, Color color) {
        Rectangle itemBounds = item.getBounds();
        Tree tree = item.getParent();
        Rectangle areaBounds = tree.getClientArea();
        g.setClipping(areaBounds.x, itemBounds.y, areaBounds.width, itemBounds.height);
        g.setBackground(color);
        g.fillRectangle(areaBounds.x, itemBounds.y, areaBounds.width, itemBounds.height);
    }

    private void updateProblemIndication(Diagnostic diagnostic) {
        int lastEditorPage = this.getPageCount() - 1;
        if (lastEditorPage >= 0 && this.getItemControl(lastEditorPage) instanceof ProblemIndicationComposite) {
            ((ProblemIndicationComposite)this.getItemControl(lastEditorPage)).setDiagnostic(diagnostic);
            if (diagnostic.getSeverity() != 0) {
                this.setActivePage(lastEditorPage);
                this.updateLayout(false, true);
            }
        } else if (diagnostic.getSeverity() != 0) {
            ProblemIndicationComposite problemIndicationComposite = new ProblemIndicationComposite((Composite)this.getControl(), 0);
            problemIndicationComposite.setDiagnostic(diagnostic);
            this.createItem(++lastEditorPage, (Control)problemIndicationComposite);
            ((CTabFolder)this.getControl()).getItem(lastEditorPage).setText(CommonUIPlugin.getPlugin().getString("_UI_Problems_label"));
            this.setActivePage(lastEditorPage);
            this.updateLayout(false, true);
            this.showTabs();
        }
    }

    private void showTabs() {
        if (this.getPageCount() > 1) {
            ((CTabFolder)this.getControl()).getItem(0).setText(EMFCompareIDEUIMessages.getString("EMFCompareStructureMergeViewer.tabItem.0.title"));
            ((CTabFolder)this.getControl()).setTabHeight(-1);
            Point point = ((CTabFolder)this.getControl()).getSize();
            ((CTabFolder)this.getControl()).setSize(point.x, point.y - 6);
        }
    }

    private void hideTabs() {
        if (this.getPageCount() <= 1) {
            ((CTabFolder)this.getControl()).getItem(0).setText("");
            ((CTabFolder)this.getControl()).setTabHeight(1);
            Point point = ((CTabFolder)this.getControl()).getSize();
            ((CTabFolder)this.getControl()).setSize(point.x, point.y + 6);
        }
    }

    private void setActivePage(int pageIndex) {
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        ((CTabFolder)this.getControl()).setSelection(pageIndex);
    }

    private int getPageCount() {
        if (this.getControl() != null && !((CTabFolder)this.getControl()).isDisposed()) {
            return ((CTabFolder)this.getControl()).getItemCount();
        }
        return 0;
    }

    private Control getItemControl(int itemIndex) {
        CTabItem item = ((CTabFolder)this.getControl()).getItem(itemIndex);
        if (item != null) {
            return item.getControl();
        }
        return null;
    }

    private static void unload(ResourceSet resourceSet) {
        if (resourceSet != null) {
            for (Resource resource : resourceSet.getResources()) {
                resource.unload();
            }
            resourceSet.getResources().clear();
        }
    }

    private static ResourceSet getResourceSet(EObject eObject) {
        Resource eResource;
        if (eObject != null && (eResource = eObject.eResource()) != null) {
            return eResource.getResourceSet();
        }
        return null;
    }

    protected void internalRefresh(Object element) {
        this.getContentProvider().runWhenReady(EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_UI_SYNC, new Runnable(){

            public void run() {
                ((WrappableTreeViewer)EMFCompareStructureMergeViewer.this.getViewer()).refresh();
            }
        });
        this.getContentProvider().runWhenReady(EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_UI_SYNC, new Runnable(){

            public void run() {
                EMFCompareStructureMergeViewer.this.dependencyData.updateTreeItemMappings();
                EMFCompareStructureMergeViewer.this.dependencyData.updateDependencies(EMFCompareStructureMergeViewer.this.getSelection(), EMFCompareRCPPlugin.getDefault().getMergerRegistry());
                EMFCompareStructureMergeViewer.this.internalRedraw();
            }
        });
        this.getContentProvider().runWhenReady(EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_UI_ASYNC, new Runnable(){

            public void run() {
                EMFCompareStructureMergeViewer.this.refreshTitle();
            }
        });
    }

    private void handleSelectionChangedEvent(SelectionChangedEvent event) {
        this.dependencyData.updateDependencies(event.getSelection(), EMFCompareRCPPlugin.getDefault().getMergerRegistry());
        this.internalRedraw();
    }

    private void internalRedraw() {
        ((WrappableTreeViewer)this.getViewer()).getTree().redraw();
        this.treeRuler.redraw();
    }

    private final class CompareInputChangedJob
    extends Job {
        private CompareInputChangedJob(String name) {
            super(name);
        }

        public IStatus run(IProgressMonitor monitor) {
            JobProgressMonitorWrapper wrapper = new JobProgressMonitorWrapper(monitor, EMFCompareStructureMergeViewer.this.progressInfoItem);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)wrapper, (String)EMFCompareIDEUIMessages.getString("EMFCompareStructureMergeViewer.computingModelDifferences"), (int)100);
            try {
                try {
                    EMFCompareStructureMergeViewer.this.compareInputChanged((ICompareInput)EMFCompareStructureMergeViewer.this.getInput(), (IProgressMonitor)subMonitor.newChild(100));
                }
                catch (OperationCanceledException operationCanceledException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    subMonitor.setWorkRemaining(0);
                    return iStatus;
                }
                catch (Exception e) {
                    EMFCompareIDEUIPlugin.getDefault().log(e);
                    subMonitor.setWorkRemaining(0);
                }
            }
            finally {
                subMonitor.setWorkRemaining(0);
            }
            return Status.OK_STATUS;
        }
    }
}

