/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.internal.merge.IMergeData;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.internal.merge.MergeOperation;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MergeViewerUtil {
    private static final Predicate<EObject> IS_PRIME_REFINING = new Predicate<EObject>(){

        public boolean apply(EObject eObject) {
            if (eObject instanceof Diff) {
                for (Diff refine : ((Diff)eObject).getRefines()) {
                    if (refine.getPrimeRefining() != eObject) continue;
                    return true;
                }
            }
            return false;
        }
    };

    private MergeViewerUtil() {
    }

    public static List<?> getValues(Diff diff, IMergeViewer.MergeViewerSide side) {
        Match ownerMatch = diff.getMatch();
        EObject eObject = MergeViewerUtil.getEObject(ownerMatch, side);
        EStructuralFeature affectedFeature = MergeViewerUtil.getAffectedFeature(diff);
        return ReferenceUtil.getAsList((EObject)eObject, (EStructuralFeature)affectedFeature);
    }

    public static List<?> getFeatureValues(Match match, EStructuralFeature feature, IMergeViewer.MergeViewerSide side) {
        EObject eObject = MergeViewerUtil.getEObject(match, side);
        return ReferenceUtil.getAsList((EObject)eObject, (EStructuralFeature)feature);
    }

    public static EObject getEObject(Match match, IMergeViewer.MergeViewerSide side) {
        EObject eObject;
        switch (side) {
            case ANCESTOR: {
                eObject = match.getOrigin();
                break;
            }
            case LEFT: {
                eObject = match.getLeft();
                break;
            }
            case RIGHT: {
                eObject = match.getRight();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return eObject;
    }

    public static EObject getBestSideEObject(Match match, IMergeViewer.MergeViewerSide side) {
        IMergeViewer.MergeViewerSide[] sideLookupOrder = side == IMergeViewer.MergeViewerSide.ANCESTOR ? new IMergeViewer.MergeViewerSide[]{IMergeViewer.MergeViewerSide.ANCESTOR, IMergeViewer.MergeViewerSide.LEFT, IMergeViewer.MergeViewerSide.RIGHT} : new IMergeViewer.MergeViewerSide[]{side, side.opposite(), IMergeViewer.MergeViewerSide.ANCESTOR};
        EObject objectOnSide = null;
        int i = 0;
        while (i < sideLookupOrder.length && objectOnSide == null) {
            objectOnSide = MergeViewerUtil.getEObject(match, sideLookupOrder[i]);
            ++i;
        }
        return objectOnSide;
    }

    public static EStructuralFeature getAffectedFeature(Diff diff) {
        Object feature = diff instanceof ReferenceChange ? ((ReferenceChange)diff).getReference() : (diff instanceof AttributeChange ? ((AttributeChange)diff).getAttribute() : (diff instanceof FeatureMapChange ? ((FeatureMapChange)diff).getAttribute() : null));
        return feature;
    }

    public static Object getDiffValue(Diff diff) {
        Object entry;
        Object ret = diff instanceof ReferenceChange ? ((ReferenceChange)diff).getValue() : (diff instanceof AttributeChange ? ((AttributeChange)diff).getValue() : (diff instanceof FeatureMapChange ? ((entry = ((FeatureMapChange)diff).getValue()) instanceof FeatureMap.Entry ? ((FeatureMap.Entry)entry).getValue() : null) : null));
        return ret;
    }

    public static Object getValueFromDiff(Diff diff, IMergeViewer.MergeViewerSide side) {
        Object diffValue = MergeViewerUtil.getDiffValue(diff);
        EStructuralFeature feature = MergeViewerUtil.getAffectedFeature(diff);
        Match ownerMatch = diff.getMatch();
        Object ret = MergeViewerUtil.matchingValue(diffValue, ownerMatch, feature, side, ownerMatch.getComparison());
        return ret;
    }

    private static Object matchingValue(Object object, Match ownerMatch, EStructuralFeature feature, IMergeViewer.MergeViewerSide side, Comparison comparison) {
        Match matchOfValue;
        Object ret = object instanceof EObject ? ((matchOfValue = comparison.getMatch((EObject)object)) != null ? MergeViewerUtil.getEObject(matchOfValue, side) : MergeViewerUtil.matchingValue(object, MergeViewerUtil.getFeatureValues(ownerMatch, feature, side), comparison)) : MergeViewerUtil.matchingValue(object, MergeViewerUtil.getFeatureValues(ownerMatch, feature, side), comparison);
        return ret;
    }

    private static Object matchingValue(Object value, List<?> in, Comparison comparison) {
        Object ret = null;
        IEqualityHelper equalityHelper = comparison.getEqualityHelper();
        Iterator<?> valuesIterator = in.iterator();
        while (valuesIterator.hasNext() && ret == null) {
            Object object = valuesIterator.next();
            if (!equalityHelper.matchingValues(object, value)) continue;
            ret = object;
        }
        return ret;
    }

    public static Resource getResource(Comparison comparison, IMergeViewer.MergeViewerSide side, Diff diff) {
        if (!(diff instanceof ResourceAttachmentChange)) {
            return null;
        }
        Resource resource = MergeViewerUtil.getResourceViaMatch(side, (ResourceAttachmentChange)diff);
        if (resource == null) {
            resource = MergeViewerUtil.getResourceViaMatchResource(comparison, side, (ResourceAttachmentChange)diff);
        }
        return resource;
    }

    private static Resource getResourceViaMatch(IMergeViewer.MergeViewerSide side, ResourceAttachmentChange diff) {
        Resource.Internal resource = null;
        Match match = diff.getMatch();
        switch (side) {
            case ANCESTOR: {
                EObject origin = match.getOrigin();
                if (!(origin instanceof MinimalEObjectImpl)) break;
                resource = ((MinimalEObjectImpl)origin).eDirectResource();
                break;
            }
            case LEFT: {
                EObject left = match.getLeft();
                if (!(left instanceof MinimalEObjectImpl)) break;
                resource = ((MinimalEObjectImpl)left).eDirectResource();
                break;
            }
            case RIGHT: {
                EObject right = match.getRight();
                if (!(right instanceof MinimalEObjectImpl)) break;
                resource = ((MinimalEObjectImpl)right).eDirectResource();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return resource;
    }

    private static Resource getResourceViaMatchResource(Comparison comparison, IMergeViewer.MergeViewerSide side, ResourceAttachmentChange diff) {
        Resource resource = null;
        EList matchResources = comparison.getMatchedResources();
        String diffResourceURI = diff.getResourceURI();
        for (MatchResource matchResource : matchResources) {
            switch (side) {
                case ANCESTOR: {
                    resource = matchResource.getOrigin();
                    break;
                }
                case LEFT: {
                    resource = matchResource.getLeft();
                    break;
                }
                case RIGHT: {
                    resource = matchResource.getRight();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (resource == null || diffResourceURI == null) continue;
            URI resourceURI = resource.getURI();
            if (diffResourceURI.equals(resourceURI.toString())) {
                return resource;
            }
            if (side == IMergeViewer.MergeViewerSide.RIGHT && (diffResourceURI.equals(matchResource.getLeftURI()) || diffResourceURI.equals(matchResource.getOriginURI()))) {
                return resource;
            }
            if (side == IMergeViewer.MergeViewerSide.LEFT && (diffResourceURI.equals(matchResource.getRightURI()) || diffResourceURI.equals(matchResource.getOriginURI()))) {
                return resource;
            }
            if (side != IMergeViewer.MergeViewerSide.ANCESTOR || !diffResourceURI.equals(matchResource.getLeftURI()) && !diffResourceURI.equals(matchResource.getRightURI())) continue;
            return resource;
        }
        return resource;
    }

    public static List<EObject> getResourceContents(Comparison comparison, IMergeViewer.MergeViewerSide side, Diff diff) {
        Resource resource = MergeViewerUtil.getResource(comparison, side, diff);
        if (resource != null) {
            return resource.getContents();
        }
        return Collections.emptyList();
    }

    public static Object getResourceAttachmentChangeValue(ResourceAttachmentChange diff, IMergeViewer.MergeViewerSide side) {
        EObject ret;
        Match match = diff.getMatch();
        switch (side) {
            case ANCESTOR: {
                ret = match.getOrigin();
                break;
            }
            case LEFT: {
                ret = match.getLeft();
                break;
            }
            case RIGHT: {
                ret = match.getRight();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return ret;
    }

    public static Object getValueFromResourceAttachmentChange(ResourceAttachmentChange diff, Comparison comparison, IMergeViewer.MergeViewerSide side) {
        Object diffValue = MergeViewerUtil.getResourceAttachmentChangeValue(diff, side);
        Object ret = MergeViewerUtil.matchingValue(diffValue, comparison, side);
        return ret;
    }

    public static Object matchingValue(Object object, Comparison comparison, IMergeViewer.MergeViewerSide side) {
        Object ret;
        block7: {
            block5: {
                block6: {
                    if (!(object instanceof EObject)) break block5;
                    Match matchOfValue = comparison.getMatch((EObject)object);
                    if (matchOfValue == null) break block6;
                    switch (side) {
                        case ANCESTOR: {
                            ret = matchOfValue.getOrigin();
                            break block7;
                        }
                        case LEFT: {
                            ret = matchOfValue.getLeft();
                            break block7;
                        }
                        case RIGHT: {
                            ret = matchOfValue.getRight();
                            break block7;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                ret = MergeViewerUtil.matchingValue(object, comparison, MergeViewerUtil.getResourceContents(comparison, side, (Diff)((ResourceAttachmentChange)object)));
                break block7;
            }
            ret = MergeViewerUtil.matchingValue(object, comparison, MergeViewerUtil.getResourceContents(comparison, side, null));
        }
        return ret;
    }

    public static Object matchingValue(Object value, Comparison comparison, List<?> in) {
        Object ret = null;
        IEqualityHelper equalityHelper = comparison.getEqualityHelper();
        Iterator<?> valuesIterator = in.iterator();
        while (valuesIterator.hasNext() && ret == null) {
            Object object = valuesIterator.next();
            if (!equalityHelper.matchingValues(object, value)) continue;
            ret = object;
        }
        return ret;
    }

    public static boolean isVisibleInMergeViewer(Diff diff, IDifferenceGroupProvider groupProvider, Predicate<? super EObject> predicate) {
        boolean isPrimeRefining;
        List<TreeNode> nodes = groupProvider.getTreeNodes((EObject)diff);
        boolean isDisplayedInSMV = Iterables.any(nodes, predicate);
        boolean bl = isPrimeRefining = !Iterables.isEmpty((Iterable)Iterables.filter((Iterable)Iterables.transform(nodes, IDifferenceGroup.TREE_NODE_DATA), IS_PRIME_REFINING));
        return isDisplayedInSMV || isPrimeRefining;
    }

    public static boolean isMarkAsMerged(Diff diff, IMergeViewerItem item, IEMFCompareConfiguration compareConfiguration) {
        boolean markAsMerged;
        if (diff.getState() == DifferenceState.MERGED) {
            IMergeData mergeData = (IMergeData)EcoreUtil.getExistingAdapter((Notifier)diff, IMergeData.class);
            if (mergeData != null) {
                boolean leftEditable = compareConfiguration.isLeftEditable();
                boolean rightEditable = compareConfiguration.isRightEditable();
                MergeMode mergeMode = mergeData.getMergeMode();
                MergeOperation mergeAction = mergeMode.getMergeAction(diff, leftEditable, rightEditable);
                markAsMerged = mergeAction == MergeOperation.MARK_AS_MERGE;
            } else {
                markAsMerged = false;
            }
        } else {
            markAsMerged = false;
        }
        return markAsMerged;
    }
}

