/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import com.google.common.base.Strings;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.internal.EMFCompareEditMessages;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.ISemanticObjectLabelProvider;
import org.eclipse.emf.compare.provider.ResourceAttachmentChangeItemProvider;
import org.eclipse.emf.compare.provider.spec.OverlayImageProvider;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;

public class ResourceAttachmentChangeItemProviderSpec
extends ResourceAttachmentChangeItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider,
ISemanticObjectLabelProvider {
    private final OverlayImageProvider overlayProvider;
    private final AdapterFactoryItemDelegator itemDelegator = new AdapterFactoryItemDelegator(this.getRootAdapterFactory());

    public ResourceAttachmentChangeItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.overlayProvider = new OverlayImageProvider(this.getResourceLocator());
    }

    public Object getImage(Object object) {
        Match match = ((ResourceAttachmentChange)object).getMatch();
        Object ret = this.itemDelegator.getImage((Object)match.getLeft());
        if (ret == null) {
            ret = this.itemDelegator.getImage((Object)match.getRight());
        }
        if (ret == null) {
            ret = this.itemDelegator.getImage((Object)match.getOrigin());
        }
        if (ret == null) {
            ret = super.getImage(object);
        }
        Object matchImage = this.overlayProvider.getComposedImage((Diff)((ResourceAttachmentChange)object), ret);
        ret = this.overlayImage(object, matchImage);
        return ret;
    }

    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        ResourceAttachmentChange resourceAttachmentChange = (ResourceAttachmentChange)object;
        String value = this.doGetSemanticObjectLabel(resourceAttachmentChange, object);
        ComposedStyledString ret = new ComposedStyledString(value);
        ret.append(" [", IStyledString.Style.DECORATIONS_STYLER);
        switch (resourceAttachmentChange.getKind()) {
            case ADD: {
                ret.append(String.valueOf(EMFCompareEditMessages.getString("ResourceAttachmentChangeItemProviderSpec.decoration.control")) + ' ', IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case DELETE: {
                ret.append(String.valueOf(EMFCompareEditMessages.getString("ResourceAttachmentChangeItemProviderSpec.decoration.uncontrol")) + ' ', IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case MOVE: {
                ret.append(String.valueOf(EMFCompareEditMessages.getString("ResourceAttachmentChangeItemProviderSpec.decoration.move")) + ' ', IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
        }
        ret.append(resourceAttachmentChange.getResourceURI(), IStyledString.Style.DECORATIONS_STYLER);
        return ret.append("]", IStyledString.Style.DECORATIONS_STYLER);
    }

    public String getSemanticObjectLabel(Object object) {
        ResourceAttachmentChange resourceAttachmentChange = (ResourceAttachmentChange)object;
        return this.doGetSemanticObjectLabel(resourceAttachmentChange, object);
    }

    private String doGetSemanticObjectLabel(ResourceAttachmentChange resourceAttachmentChange, Object object) {
        Match match = resourceAttachmentChange.getMatch();
        String value = this.itemDelegator.getText((Object)match.getLeft());
        if (Strings.isNullOrEmpty((String)value)) {
            value = this.itemDelegator.getText((Object)match.getRight());
        }
        if (Strings.isNullOrEmpty((String)value)) {
            value = this.itemDelegator.getText((Object)match.getOrigin());
        }
        if (Strings.isNullOrEmpty((String)value)) {
            value = super.getText(object);
        }
        return value;
    }

    public String getDescription(Object object) {
        String ret;
        ResourceAttachmentChange rac = (ResourceAttachmentChange)object;
        String valueText = this.doGetSemanticObjectLabel(rac, object);
        String hasBeenAndSide = EMFCompareEditMessages.getString("change.local");
        if (rac.getSource() == DifferenceSource.RIGHT) {
            hasBeenAndSide = EMFCompareEditMessages.getString("change.remote");
        }
        DifferenceKind labelValue = rac.getKind();
        switch (labelValue) {
            case ADD: {
                ret = EMFCompareEditMessages.getString("ResourceAttachmentChangeItemProviderSpec.added", valueText, hasBeenAndSide);
                break;
            }
            case DELETE: {
                ret = EMFCompareEditMessages.getString("ResourceAttachmentChangeItemProviderSpec.deleted", valueText, hasBeenAndSide);
                break;
            }
            case MOVE: {
                ret = EMFCompareEditMessages.getString("ResourceAttachmentChangeItemProviderSpec.moved", valueText, hasBeenAndSide);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + rac.getKind());
            }
        }
        return ret;
    }
}

