/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.internal.factories.extensions;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.diagram.internal.extensions.EdgeChange;
import org.eclipse.emf.compare.diagram.internal.extensions.ExtensionsFactory;
import org.eclipse.emf.compare.diagram.internal.factories.extensions.NodeChangeFactory;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeChangeFactory
extends NodeChangeFactory {
    @Override
    public Class<? extends Diff> getExtensionKind() {
        return EdgeChange.class;
    }

    @Override
    public DiagramDiff createExtension() {
        return ExtensionsFactory.eINSTANCE.createEdgeChange();
    }

    @Override
    public EObject setView(DiagramDiff extension, Diff refiningDiff) {
        EObject view = super.setView(extension, refiningDiff);
        while (view != null && !(view instanceof Edge)) {
            view = view.eContainer();
        }
        extension.setView(view);
        return view;
    }

    @Override
    public void setRefiningChanges(Diff extension, DifferenceKind extensionKind, Diff refiningDiff) {
        super.setRefiningChanges(extension, extensionKind, refiningDiff);
        if (extensionKind == DifferenceKind.CHANGE) {
            extension.getRefinedBy().addAll(Collections2.filter(this.getAllDifferencesForChange(refiningDiff), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)extension.getSource())));
        }
    }

    public static Predicate<? super Diff> isMainDiffForAddOrDeleteEdge() {
        return new Predicate<Diff>(){

            public boolean apply(Diff difference) {
                return difference instanceof ReferenceChange && (EdgeChangeFactory.isRelatedToAnAddEdge((ReferenceChange)difference) || EdgeChangeFactory.isRelatedToADeleteEdge((ReferenceChange)difference));
            }
        };
    }

    @Override
    protected Collection<Diff> getAllDifferencesForChange(Diff input) {
        Match match = input.getMatch();
        Comparison comparison = match.getComparison();
        EObject objectContainingDiff = MatchUtil.getContainer((Comparison)comparison, (Diff)input);
        Match edgeMatch = this.getEdgeMatch(comparison, objectContainingDiff);
        Iterable diffs = Iterables.filter((Iterable)edgeMatch.getAllDifferences(), (Predicate)new Predicate<Diff>(){

            public boolean apply(Diff diff) {
                return EdgeChangeFactory.this.getRelatedExtensionKind(diff) == DifferenceKind.CHANGE;
            }
        });
        ArrayList<Diff> result = new ArrayList<Diff>();
        for (Diff diff : diffs) {
            result.add(diff);
        }
        return result;
    }

    @Override
    protected boolean isRelatedToAnExtensionAdd(ReferenceChange input) {
        return EdgeChangeFactory.isRelatedToAnAddEdge(input);
    }

    protected static boolean isRelatedToAnAddEdge(ReferenceChange input) {
        return EdgeChangeFactory.isContainmentOnSemanticEdge(input) && input.getKind() == DifferenceKind.ADD;
    }

    @Override
    protected boolean isRelatedToAnExtensionDelete(ReferenceChange input) {
        return EdgeChangeFactory.isRelatedToADeleteEdge(input);
    }

    protected static boolean isRelatedToADeleteEdge(ReferenceChange input) {
        return EdgeChangeFactory.isContainmentOnSemanticEdge(input) && input.getKind() == DifferenceKind.DELETE;
    }

    protected boolean isRelatedToAnExtensionChange(AttributeChange input) {
        return (input.getAttribute().eContainer().equals(NotationPackage.eINSTANCE.getRelativeBendpoints()) || input.getAttribute().equals(NotationPackage.eINSTANCE.getIdentityAnchor_Id())) && input.getRefines().isEmpty();
    }

    protected boolean isRelatedToAnExtensionChange(ReferenceChange input) {
        return input.getValue() instanceof IdentityAnchor && input.getReference().isContainment() && input.getRefines().isEmpty() && !this.isLeadedByAddOrDeleteEdge(input);
    }

    private Match getEdgeMatch(Comparison comparison, EObject subObject) {
        EObject object = subObject;
        while (!(object instanceof Edge) && object != null) {
            object = object.eContainer();
        }
        return comparison.getMatch(object);
    }

    private boolean isLeadedByAddOrDeleteEdge(ReferenceChange input) {
        boolean result = false;
        EObject addedOrDeletedObject = input.getValue();
        EObject container = addedOrDeletedObject.eContainer();
        while (!(container instanceof Edge) && container != null) {
            container = container.eContainer();
        }
        if (container instanceof Edge) {
            result = Iterators.any((Iterator)input.getMatch().getComparison().getDifferences(container).iterator(), EdgeChangeFactory.isMainDiffForAddOrDeleteEdge());
        }
        return result;
    }

    private static boolean isContainmentOnSemanticEdge(ReferenceChange input) {
        return input.getReference().isContainment() && input.getValue() instanceof Edge && ReferenceUtil.safeEGet((EObject)input.getValue(), (EStructuralFeature)NotationPackage.Literals.VIEW__ELEMENT) != null;
    }
}

