/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.emf.compare.match.eobject.AbstractWeightProvider;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DefaultWeightProvider
extends AbstractWeightProvider {
    protected Map<EStructuralFeature, Integer> weights = Maps.newHashMap();
    protected int referenceChangeCoef = 10;
    protected int attributeChangeCoef = 20;

    public int getWeight(EStructuralFeature feature) {
        if (this.irrelevant(feature)) {
            return 0;
        }
        Integer found = this.weights.get(feature);
        if (found == null) {
            found = 5;
            if ("name".equals(feature.getName()) || "id".equals(feature.getName())) {
                found = 20;
            }
            found = feature instanceof EReference ? Integer.valueOf(this.referenceChangeCoef * found) : Integer.valueOf(this.attributeChangeCoef * found);
            this.weights.put(feature, found);
        }
        return found;
    }

    public int getParentWeight(EObject a) {
        return 20;
    }

    public int getContainingFeatureWeight(EObject a) {
        return 10;
    }

    protected boolean irrelevant(EStructuralFeature feat) {
        if (feat instanceof EAttribute) {
            return feat.isDerived() || feat.isTransient();
        }
        EReference ref = (EReference)feat;
        return ref.isDerived() || ref.isTransient() || ref.isContainment() || ref.isContainer();
    }
}

