/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.preferences;

import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.CrossReferenceResolutionScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ModelResolutionPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String[][] scopeNamesAndValues = new String[][]{{EMFCompareIDEUIMessages.getString("ModelResolutionPreferencesPage.resolutionScope.workspace.label"), CrossReferenceResolutionScope.WORKSPACE.name()}, {EMFCompareIDEUIMessages.getString("ModelResolutionPreferencesPage.resolutionScope.project.label"), CrossReferenceResolutionScope.PROJECT.name()}, {EMFCompareIDEUIMessages.getString("ModelResolutionPreferencesPage.resolutionScope.container.label"), CrossReferenceResolutionScope.CONTAINER.name()}, {EMFCompareIDEUIMessages.getString("ModelResolutionPreferencesPage.resolutionScope.outgoing.label"), CrossReferenceResolutionScope.OUTGOING.name()}};
    private BooleanFieldEditor disableResolvers;
    private BooleanFieldEditor useThreads;
    private ComboFieldEditor resolutionScope;
    private Label resolutionScopeMainDescription;
    private Label resolutionScopeDescription;
    private Composite resolutionScopeComboComposite;

    public ModelResolutionPreferencePage() {
        super(1);
        this.setPreferenceStore(EMFCompareIDEUIPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        this.disableResolvers = new BooleanFieldEditor("org.eclipse.emf.compare.ide.ui.preference.disableResolving", EMFCompareIDEUIMessages.getString("ModelResolutionPreferencesPage.disableResolvers"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.disableResolvers);
        this.useThreads = new BooleanFieldEditor("org.eclipse.emf.compare.ide.ui.preference.disableThreading", EMFCompareIDEUIMessages.getString("ModelResolutionPreferencesPage.disableThreading"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.useThreads);
        Composite resolutionScopeComposite = new Composite(this.getFieldEditorParent(), 2048);
        resolutionScopeComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        resolutionScopeComposite.setLayout((Layout)new GridLayout(2, false));
        this.resolutionScopeMainDescription = new Label(resolutionScopeComposite, 64);
        this.resolutionScopeMainDescription.setText(EMFCompareIDEUIMessages.getString("ModelResolutionPreferencesPage.resolutionScope.description"));
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 400;
        layoutData.horizontalSpan = 2;
        this.resolutionScopeMainDescription.setLayoutData((Object)layoutData);
        this.resolutionScopeComboComposite = new Composite(resolutionScopeComposite, 0);
        this.resolutionScopeComboComposite.setLayout((Layout)new GridLayout(2, false));
        this.resolutionScope = new ComboFieldEditor("org.eclipse.emf.compare.ide.ui.preference.resolutionScope", EMFCompareIDEUIMessages.getString("ModelResolutionPreferencesPage.resolutionScope"), scopeNamesAndValues, this.resolutionScopeComboComposite);
        this.addField((FieldEditor)this.resolutionScope);
        this.resolutionScopeComboComposite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.resolutionScopeDescription = new Label(resolutionScopeComposite, 2112);
        GridData descriptionData = new GridData(4, 4, true, false);
        descriptionData.widthHint = 200;
        this.resolutionScopeDescription.setLayoutData((Object)descriptionData);
        this.updateFieldEnablement(this.getPreferenceStore().getBoolean("org.eclipse.emf.compare.ide.ui.preference.disableResolving"));
        this.updateScopeDescription(this.getPreferenceStore().getString("org.eclipse.emf.compare.ide.ui.preference.resolutionScope"));
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.disableResolvers) {
            this.updateFieldEnablement(this.disableResolvers.getBooleanValue());
        } else if (event.getSource() == this.resolutionScope) {
            this.updateScopeDescription((String)event.getNewValue());
        }
        super.propertyChange(event);
    }

    private void updateFieldEnablement(boolean disabled) {
        this.useThreads.setEnabled(!disabled, this.getFieldEditorParent());
        this.resolutionScopeMainDescription.setEnabled(!disabled);
        this.resolutionScope.setEnabled(!disabled, this.resolutionScopeComboComposite);
        this.resolutionScopeDescription.setEnabled(!disabled);
    }

    private void updateScopeDescription(String scopeValue) {
        CrossReferenceResolutionScope scope = scopeValue != null && scopeValue.length() > 0 ? CrossReferenceResolutionScope.valueOf(scopeValue) : CrossReferenceResolutionScope.WORKSPACE;
        switch (scope) {
            case WORKSPACE: {
                this.resolutionScopeDescription.setText(EMFCompareIDEUIMessages.getString("ModelResolutionPreferencesPage.resolutionScope.workspace.description"));
                break;
            }
            case PROJECT: {
                this.resolutionScopeDescription.setText(EMFCompareIDEUIMessages.getString("ModelResolutionPreferencesPage.resolutionScope.project.description"));
                break;
            }
            case CONTAINER: {
                this.resolutionScopeDescription.setText(EMFCompareIDEUIMessages.getString("ModelResolutionPreferencesPage.resolutionScope.container.description"));
                break;
            }
            case OUTGOING: {
                this.resolutionScopeDescription.setText(EMFCompareIDEUIMessages.getString("ModelResolutionPreferencesPage.resolutionScope.outgoing.description"));
                break;
            }
            default: {
                this.resolutionScopeDescription.setText(EMFCompareIDEUIMessages.getString("ModelResolutionPreferencesPage.resolutionScope.invalid"));
            }
        }
        this.getFieldEditorParent().layout();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.updateFieldEnablement(this.getPreferenceStore().getBoolean("org.eclipse.emf.compare.ide.ui.preference.disableResolving"));
        this.updateScopeDescription(this.getPreferenceStore().getString("org.eclipse.emf.compare.ide.ui.preference.resolutionScope"));
    }

    public void init(IWorkbench workbench) {
    }
}

