/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.match;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.match.eobject.IdentifierEObjectMatcher;
import org.eclipse.emf.compare.tests.nodes.Node;
import org.eclipse.emf.compare.tests.nodes.NodesFactory;
import org.eclipse.emf.ecore.EObject;
import org.junit.Assert;
import org.junit.Test;

public class IdentifierEObjectMatcherTest {
    @Test
    public void testMatchPerIdFunction() throws IOException {
        Node root = NodesFactory.eINSTANCE.createNode();
        root.setName("root");
        Node nodeLevel1 = NodesFactory.eINSTANCE.createNode();
        nodeLevel1.setName("nodeLevel1");
        Node nodeLevel2 = NodesFactory.eINSTANCE.createNode();
        nodeLevel2.setName("nodeLevel2");
        Node nodeLevel3 = NodesFactory.eINSTANCE.createNode();
        nodeLevel3.setName("nodeLevel3");
        root.getContainmentRef1().add((Object)nodeLevel1);
        nodeLevel1.getContainmentRef1().add((Object)nodeLevel2);
        nodeLevel2.getContainmentRef1().add((Object)nodeLevel3);
        ArrayList nodes = Lists.newArrayList((Object[])new Node[]{nodeLevel3, nodeLevel2, nodeLevel1, root});
        MockIdentifierEObjectMatcher matcher = new MockIdentifierEObjectMatcher();
        Iterator leftEObjects = nodes.iterator();
        Iterator rightEObjects = nodes.iterator();
        Iterator originEObjects = Collections.emptyIterator();
        ArrayList leftEObjectsNoID = Lists.newArrayList();
        ArrayList rightEObjectsNoID = Lists.newArrayList();
        ArrayList originEObjectsNoID = Lists.newArrayList();
        Set<Match> matches = matcher.matchPerId(leftEObjects, rightEObjects, originEObjects, leftEObjectsNoID, rightEObjectsNoID, originEObjectsNoID);
        Assert.assertEquals((long)1L, (long)matches.size());
        Match rootMatch = matches.iterator().next();
        Assert.assertEquals((Object)root, (Object)rootMatch.getLeft());
        EList rootSubMatches = rootMatch.getSubmatches();
        Assert.assertEquals((long)1L, (long)rootSubMatches.size());
        Match nodeLevel1Match = (Match)rootSubMatches.iterator().next();
        Assert.assertEquals((Object)nodeLevel1, (Object)nodeLevel1Match.getLeft());
        EList nodeLevel1SubMatches = nodeLevel1Match.getSubmatches();
        Assert.assertEquals((long)1L, (long)nodeLevel1SubMatches.size());
        Match nodeLevel2Match = (Match)nodeLevel1SubMatches.iterator().next();
        Assert.assertEquals((Object)nodeLevel2, (Object)nodeLevel2Match.getLeft());
        EList nodeLevel2SubMatches = nodeLevel2Match.getSubmatches();
        Assert.assertEquals((long)1L, (long)nodeLevel2SubMatches.size());
        Match nodeLevel3Match = (Match)nodeLevel2SubMatches.iterator().next();
        Assert.assertEquals((Object)nodeLevel3, (Object)nodeLevel3Match.getLeft());
        EList nodeLevel3SubMatches = nodeLevel3Match.getSubmatches();
        Assert.assertTrue((boolean)nodeLevel3SubMatches.isEmpty());
    }

    private class MockIdentifierEObjectMatcher
    extends IdentifierEObjectMatcher {
        private MockIdentifierEObjectMatcher() {
        }

        public Set<Match> matchPerId(Iterator<? extends EObject> leftEObjects, Iterator<? extends EObject> rightEObjects, Iterator<? extends EObject> originEObjects, List<EObject> leftEObjectsNoID, List<EObject> rightEObjectsNoID, List<EObject> originEObjectsNoID) {
            return super.matchPerId(leftEObjects, rightEObjects, originEObjects, leftEObjectsNoID, rightEObjectsNoID, originEObjectsNoID);
        }
    }
}

