/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.merge.data.IndividualDiffInputData;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class IndividualMergeOutOfScopeValuesTest {
    private IndividualDiffInputData input = new IndividualDiffInputData();
    private final IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();

    @Test
    public void testReferenceMonoChange2WayLtR() throws IOException {
        Resource left = this.input.getReferenceMonoChangeLeftOutOfScope();
        Resource right = this.input.getReferenceMonoChangeRightOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"singleValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyLeftToRight((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        EObject leftValue = (EObject)leftDiffContainer.eGet(feature, false);
        EObject rightValue = (EObject)rightDiffContainer.eGet(feature, false);
        Assert.assertTrue((boolean)leftValue.eIsProxy());
        Assert.assertTrue((boolean)rightValue.eIsProxy());
        Assert.assertEquals((Object)((InternalEObject)leftValue).eProxyURI(), (Object)((InternalEObject)rightValue).eProxyURI());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoChange2WayRtL() throws IOException {
        Resource left = this.input.getReferenceMonoChangeLeftOutOfScope();
        Resource right = this.input.getReferenceMonoChangeRightOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"singleValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyRightToLeft((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        EObject leftValue = (EObject)leftDiffContainer.eGet(feature, false);
        EObject rightValue = (EObject)rightDiffContainer.eGet(feature, false);
        Assert.assertTrue((boolean)leftValue.eIsProxy());
        Assert.assertTrue((boolean)rightValue.eIsProxy());
        Assert.assertEquals((Object)((InternalEObject)leftValue).eProxyURI(), (Object)((InternalEObject)rightValue).eProxyURI());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoChange3WayLeftChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMonoChangeLeftOutOfScope();
        Resource right = this.input.getReferenceMonoChangeRightOutOfScope();
        Resource origin = this.input.getReferenceMonoChangeOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"singleValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyLeftToRight((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        EObject leftValue = (EObject)leftDiffContainer.eGet(feature, false);
        EObject rightValue = (EObject)rightDiffContainer.eGet(feature, false);
        EObject originValue = (EObject)originDiffContainer.eGet(feature, false);
        Assert.assertTrue((boolean)leftValue.eIsProxy());
        Assert.assertTrue((boolean)rightValue.eIsProxy());
        Assert.assertTrue((boolean)originValue.eIsProxy());
        Assert.assertEquals((Object)((InternalEObject)leftValue).eProxyURI(), (Object)((InternalEObject)rightValue).eProxyURI());
        Assert.assertFalse((boolean)((InternalEObject)leftValue).eProxyURI().equals(((InternalEObject)originValue).eProxyURI()));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoChange3WayLeftChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMonoChangeLeftOutOfScope();
        Resource right = this.input.getReferenceMonoChangeRightOutOfScope();
        Resource origin = this.input.getReferenceMonoChangeOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"singleValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyRightToLeft((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        EObject leftValue = (EObject)leftDiffContainer.eGet(feature, false);
        EObject rightValue = (EObject)rightDiffContainer.eGet(feature, false);
        EObject originValue = (EObject)originDiffContainer.eGet(feature, false);
        Assert.assertTrue((boolean)leftValue.eIsProxy());
        Assert.assertTrue((boolean)rightValue.eIsProxy());
        Assert.assertTrue((boolean)originValue.eIsProxy());
        Assert.assertEquals((Object)((InternalEObject)leftValue).eProxyURI(), (Object)((InternalEObject)rightValue).eProxyURI());
        Assert.assertEquals((Object)((InternalEObject)leftValue).eProxyURI(), (Object)((InternalEObject)originValue).eProxyURI());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoChange3WayRightChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMonoChangeRightOutOfScope();
        Resource right = this.input.getReferenceMonoChangeLeftOutOfScope();
        Resource origin = this.input.getReferenceMonoChangeOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"singleValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyLeftToRight((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        EObject leftValue = (EObject)leftDiffContainer.eGet(feature, false);
        EObject rightValue = (EObject)rightDiffContainer.eGet(feature, false);
        EObject originValue = (EObject)originDiffContainer.eGet(feature, false);
        Assert.assertTrue((boolean)leftValue.eIsProxy());
        Assert.assertTrue((boolean)rightValue.eIsProxy());
        Assert.assertTrue((boolean)originValue.eIsProxy());
        Assert.assertEquals((Object)((InternalEObject)leftValue).eProxyURI(), (Object)((InternalEObject)rightValue).eProxyURI());
        Assert.assertEquals((Object)((InternalEObject)leftValue).eProxyURI(), (Object)((InternalEObject)originValue).eProxyURI());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoChange3WayRightChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMonoChangeRightOutOfScope();
        Resource right = this.input.getReferenceMonoChangeLeftOutOfScope();
        Resource origin = this.input.getReferenceMonoChangeOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"singleValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyRightToLeft((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        EObject leftValue = (EObject)leftDiffContainer.eGet(feature, false);
        EObject rightValue = (EObject)rightDiffContainer.eGet(feature, false);
        EObject originValue = (EObject)originDiffContainer.eGet(feature, false);
        Assert.assertTrue((boolean)leftValue.eIsProxy());
        Assert.assertTrue((boolean)rightValue.eIsProxy());
        Assert.assertTrue((boolean)originValue.eIsProxy());
        Assert.assertEquals((Object)((InternalEObject)leftValue).eProxyURI(), (Object)((InternalEObject)rightValue).eProxyURI());
        Assert.assertFalse((boolean)((InternalEObject)leftValue).eProxyURI().equals(((InternalEObject)originValue).eProxyURI()));
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoSet2WayLtR() throws IOException {
        Resource left = this.input.getReferenceMonoSetLeftOutOfScope();
        Resource right = this.input.getReferenceMonoSetRightOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"singleValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyLeftToRight((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        EObject leftValue = (EObject)leftDiffContainer.eGet(feature, false);
        EObject rightValue = (EObject)rightDiffContainer.eGet(feature, false);
        Assert.assertTrue((boolean)leftValue.eIsProxy());
        Assert.assertTrue((boolean)rightValue.eIsProxy());
        Assert.assertEquals((Object)((InternalEObject)leftValue).eProxyURI(), (Object)((InternalEObject)rightValue).eProxyURI());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoSet2WayRtL() throws IOException {
        Resource left = this.input.getReferenceMonoSetLeftOutOfScope();
        Resource right = this.input.getReferenceMonoSetRightOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"singleValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyRightToLeft((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        EObject leftValue = (EObject)leftDiffContainer.eGet(feature, false);
        EObject rightValue = (EObject)rightDiffContainer.eGet(feature, false);
        Assert.assertNull((Object)leftValue);
        Assert.assertNull((Object)rightValue);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoSet3WayLeftChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMonoSetLeftOutOfScope();
        Resource right = this.input.getReferenceMonoSetRightOutOfScope();
        Resource origin = this.input.getReferenceMonoSetOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"singleValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyLeftToRight((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        EObject leftValue = (EObject)leftDiffContainer.eGet(feature, false);
        EObject rightValue = (EObject)rightDiffContainer.eGet(feature, false);
        EObject originValue = (EObject)originDiffContainer.eGet(feature, false);
        Assert.assertTrue((boolean)leftValue.eIsProxy());
        Assert.assertTrue((boolean)rightValue.eIsProxy());
        Assert.assertNull((Object)originValue);
        Assert.assertEquals((Object)((InternalEObject)leftValue).eProxyURI(), (Object)((InternalEObject)rightValue).eProxyURI());
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoSet3WayLeftChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMonoSetLeftOutOfScope();
        Resource right = this.input.getReferenceMonoSetRightOutOfScope();
        Resource origin = this.input.getReferenceMonoSetOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"singleValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyRightToLeft((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        EObject leftValue = (EObject)leftDiffContainer.eGet(feature, false);
        EObject rightValue = (EObject)rightDiffContainer.eGet(feature, false);
        EObject originValue = (EObject)originDiffContainer.eGet(feature, false);
        Assert.assertNull((Object)leftValue);
        Assert.assertNull((Object)rightValue);
        Assert.assertNull((Object)originValue);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoSet3WayRightChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMonoSetRightOutOfScope();
        Resource right = this.input.getReferenceMonoSetLeftOutOfScope();
        Resource origin = this.input.getReferenceMonoSetOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"singleValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyLeftToRight((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        EObject leftValue = (EObject)leftDiffContainer.eGet(feature, false);
        EObject rightValue = (EObject)rightDiffContainer.eGet(feature, false);
        EObject originValue = (EObject)originDiffContainer.eGet(feature, false);
        Assert.assertNull((Object)leftValue);
        Assert.assertNull((Object)rightValue);
        Assert.assertNull((Object)originValue);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoSet3WayRightChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMonoSetRightOutOfScope();
        Resource right = this.input.getReferenceMonoSetLeftOutOfScope();
        Resource origin = this.input.getReferenceMonoSetOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"singleValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyRightToLeft((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        EObject leftValue = (EObject)leftDiffContainer.eGet(feature, false);
        EObject rightValue = (EObject)rightDiffContainer.eGet(feature, false);
        EObject originValue = (EObject)originDiffContainer.eGet(feature, false);
        Assert.assertTrue((boolean)leftValue.eIsProxy());
        Assert.assertTrue((boolean)rightValue.eIsProxy());
        Assert.assertNull((Object)originValue);
        Assert.assertEquals((Object)((InternalEObject)leftValue).eProxyURI(), (Object)((InternalEObject)rightValue).eProxyURI());
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoUnset2WayLtR() throws IOException {
        Resource left = this.input.getReferenceMonoUnsetLeftOutOfScope();
        Resource right = this.input.getReferenceMonoUnsetRightOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"singleValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyLeftToRight((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        EObject leftValue = (EObject)leftDiffContainer.eGet(feature, false);
        EObject rightValue = (EObject)rightDiffContainer.eGet(feature, false);
        Assert.assertNull((Object)leftValue);
        Assert.assertNull((Object)rightValue);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoUnset2WayRtL() throws IOException {
        Resource left = this.input.getReferenceMonoUnsetLeftOutOfScope();
        Resource right = this.input.getReferenceMonoUnsetRightOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"singleValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyRightToLeft((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        EObject leftValue = (EObject)leftDiffContainer.eGet(feature, false);
        EObject rightValue = (EObject)rightDiffContainer.eGet(feature, false);
        Assert.assertTrue((boolean)leftValue.eIsProxy());
        Assert.assertTrue((boolean)rightValue.eIsProxy());
        Assert.assertEquals((Object)((InternalEObject)leftValue).eProxyURI(), (Object)((InternalEObject)rightValue).eProxyURI());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoUnset3WayLeftChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMonoUnsetLeftOutOfScope();
        Resource right = this.input.getReferenceMonoUnsetRightOutOfScope();
        Resource origin = this.input.getReferenceMonoUnsetOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"singleValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyLeftToRight((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        EObject leftValue = (EObject)leftDiffContainer.eGet(feature, false);
        EObject rightValue = (EObject)rightDiffContainer.eGet(feature, false);
        EObject originValue = (EObject)originDiffContainer.eGet(feature, false);
        Assert.assertNull((Object)leftValue);
        Assert.assertNull((Object)rightValue);
        Assert.assertTrue((boolean)originValue.eIsProxy());
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoUnset3WayLeftChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMonoUnsetLeftOutOfScope();
        Resource right = this.input.getReferenceMonoUnsetRightOutOfScope();
        Resource origin = this.input.getReferenceMonoUnsetOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"singleValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyRightToLeft((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        EObject leftValue = (EObject)leftDiffContainer.eGet(feature, false);
        EObject rightValue = (EObject)rightDiffContainer.eGet(feature, false);
        EObject originValue = (EObject)originDiffContainer.eGet(feature, false);
        Assert.assertTrue((boolean)leftValue.eIsProxy());
        Assert.assertTrue((boolean)rightValue.eIsProxy());
        Assert.assertTrue((boolean)originValue.eIsProxy());
        Assert.assertEquals((Object)((InternalEObject)leftValue).eProxyURI(), (Object)((InternalEObject)rightValue).eProxyURI());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoUnset3WayRightChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMonoUnsetRightOutOfScope();
        Resource right = this.input.getReferenceMonoUnsetLeftOutOfScope();
        Resource origin = this.input.getReferenceMonoUnsetOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"singleValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyLeftToRight((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        EObject leftValue = (EObject)leftDiffContainer.eGet(feature, false);
        EObject rightValue = (EObject)rightDiffContainer.eGet(feature, false);
        EObject originValue = (EObject)originDiffContainer.eGet(feature, false);
        Assert.assertTrue((boolean)leftValue.eIsProxy());
        Assert.assertTrue((boolean)rightValue.eIsProxy());
        Assert.assertTrue((boolean)originValue.eIsProxy());
        Assert.assertEquals((Object)((InternalEObject)leftValue).eProxyURI(), (Object)((InternalEObject)rightValue).eProxyURI());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMonoUnset3WayRightChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMonoUnsetRightOutOfScope();
        Resource right = this.input.getReferenceMonoUnsetLeftOutOfScope();
        Resource origin = this.input.getReferenceMonoUnsetOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "singleValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"singleValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyRightToLeft((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("singleValuedReference");
        Assert.assertNotNull((Object)feature);
        EObject leftValue = (EObject)leftDiffContainer.eGet(feature, false);
        EObject rightValue = (EObject)rightDiffContainer.eGet(feature, false);
        EObject originValue = (EObject)originDiffContainer.eGet(feature, false);
        Assert.assertNull((Object)leftValue);
        Assert.assertNull((Object)rightValue);
        Assert.assertTrue((boolean)originValue.eIsProxy());
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiAdd2WayLtR() throws IOException {
        EObject candidate;
        Resource left = this.input.getReferenceMultiAddLeftOutOfScope();
        Resource right = this.input.getReferenceMultiAddRightOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"multiValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyLeftToRight((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        List leftValue = (List)leftDiffContainer.eGet(feature, false);
        List rightValue = (List)rightDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)3L, (long)leftValue.size());
        Assert.assertEquals((long)3L, (long)rightValue.size());
        URI proxyURI = ((InternalEObject)diff.getValue()).eProxyURI();
        int leftProxyIndex = -1;
        int rightProxyIndex = -1;
        int i = 0;
        while (i < leftValue.size() && leftProxyIndex == -1) {
            candidate = (EObject)leftValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                leftProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < rightValue.size() && rightProxyIndex == -1) {
            candidate = (EObject)rightValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                rightProxyIndex = i;
            }
            ++i;
        }
        Assert.assertTrue((leftProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((rightProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)leftProxyIndex, (long)rightProxyIndex);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiAdd2WayRtL() throws IOException {
        EObject candidate;
        Resource left = this.input.getReferenceMultiAddLeftOutOfScope();
        Resource right = this.input.getReferenceMultiAddRightOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"multiValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyRightToLeft((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        List leftValue = (List)leftDiffContainer.eGet(feature, false);
        List rightValue = (List)rightDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)2L, (long)leftValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        URI proxyURI = ((InternalEObject)diff.getValue()).eProxyURI();
        int leftProxyIndex = -1;
        int rightProxyIndex = -1;
        int i = 0;
        while (i < leftValue.size() && leftProxyIndex == -1) {
            candidate = (EObject)leftValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                leftProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < rightValue.size() && rightProxyIndex == -1) {
            candidate = (EObject)rightValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                rightProxyIndex = i;
            }
            ++i;
        }
        Assert.assertEquals((long)-1L, (long)leftProxyIndex);
        Assert.assertEquals((long)-1L, (long)rightProxyIndex);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiAdd3WayLeftChangeLtR() throws IOException {
        EObject candidate;
        Resource left = this.input.getReferenceMultiAddLeftOutOfScope();
        Resource right = this.input.getReferenceMultiAddRightOutOfScope();
        Resource origin = this.input.getReferenceMultiAddOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"multiValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyLeftToRight((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        List leftValue = (List)leftDiffContainer.eGet(feature, false);
        List rightValue = (List)rightDiffContainer.eGet(feature, false);
        List originValue = (List)originDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)3L, (long)leftValue.size());
        Assert.assertEquals((long)3L, (long)rightValue.size());
        Assert.assertEquals((long)2L, (long)originValue.size());
        URI proxyURI = ((InternalEObject)diff.getValue()).eProxyURI();
        int leftProxyIndex = -1;
        int rightProxyIndex = -1;
        int originProxyIndex = -1;
        int i = 0;
        while (i < leftValue.size() && leftProxyIndex == -1) {
            candidate = (EObject)leftValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                leftProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < rightValue.size() && rightProxyIndex == -1) {
            candidate = (EObject)rightValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                rightProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < originValue.size() && originProxyIndex == -1) {
            candidate = (EObject)originValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                originProxyIndex = i;
            }
            ++i;
        }
        Assert.assertTrue((leftProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((rightProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)-1L, (long)originProxyIndex);
        Assert.assertEquals((long)leftProxyIndex, (long)rightProxyIndex);
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiAdd3WayLeftChangeRtL() throws IOException {
        EObject candidate;
        Resource left = this.input.getReferenceMultiAddLeftOutOfScope();
        Resource right = this.input.getReferenceMultiAddRightOutOfScope();
        Resource origin = this.input.getReferenceMultiAddOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"multiValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyRightToLeft((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        List leftValue = (List)leftDiffContainer.eGet(feature, false);
        List rightValue = (List)rightDiffContainer.eGet(feature, false);
        List originValue = (List)originDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)2L, (long)leftValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        Assert.assertEquals((long)2L, (long)originValue.size());
        URI proxyURI = ((InternalEObject)diff.getValue()).eProxyURI();
        int leftProxyIndex = -1;
        int rightProxyIndex = -1;
        int originProxyIndex = -1;
        int i = 0;
        while (i < leftValue.size() && leftProxyIndex == -1) {
            candidate = (EObject)leftValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                leftProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < rightValue.size() && rightProxyIndex == -1) {
            candidate = (EObject)rightValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                rightProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < originValue.size() && originProxyIndex == -1) {
            candidate = (EObject)originValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                originProxyIndex = i;
            }
            ++i;
        }
        Assert.assertEquals((long)-1L, (long)leftProxyIndex);
        Assert.assertEquals((long)-1L, (long)rightProxyIndex);
        Assert.assertEquals((long)-1L, (long)originProxyIndex);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiAdd3WayRightChangeLtR() throws IOException {
        EObject candidate;
        Resource left = this.input.getReferenceMultiAddRightOutOfScope();
        Resource right = this.input.getReferenceMultiAddLeftOutOfScope();
        Resource origin = this.input.getReferenceMultiAddOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"multiValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyLeftToRight((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        List leftValue = (List)leftDiffContainer.eGet(feature, false);
        List rightValue = (List)rightDiffContainer.eGet(feature, false);
        List originValue = (List)originDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)2L, (long)leftValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        Assert.assertEquals((long)2L, (long)originValue.size());
        URI proxyURI = ((InternalEObject)diff.getValue()).eProxyURI();
        int leftProxyIndex = -1;
        int rightProxyIndex = -1;
        int originProxyIndex = -1;
        int i = 0;
        while (i < leftValue.size() && leftProxyIndex == -1) {
            candidate = (EObject)leftValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                leftProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < rightValue.size() && rightProxyIndex == -1) {
            candidate = (EObject)rightValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                rightProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < originValue.size() && originProxyIndex == -1) {
            candidate = (EObject)originValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                originProxyIndex = i;
            }
            ++i;
        }
        Assert.assertEquals((long)-1L, (long)leftProxyIndex);
        Assert.assertEquals((long)-1L, (long)rightProxyIndex);
        Assert.assertEquals((long)-1L, (long)originProxyIndex);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiAdd3WayRightChangeRtL() throws IOException {
        EObject candidate;
        Resource left = this.input.getReferenceMultiAddRightOutOfScope();
        Resource right = this.input.getReferenceMultiAddLeftOutOfScope();
        Resource origin = this.input.getReferenceMultiAddOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"multiValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyRightToLeft((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        List leftValue = (List)leftDiffContainer.eGet(feature, false);
        List rightValue = (List)rightDiffContainer.eGet(feature, false);
        List originValue = (List)originDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)3L, (long)leftValue.size());
        Assert.assertEquals((long)3L, (long)rightValue.size());
        Assert.assertEquals((long)2L, (long)originValue.size());
        URI proxyURI = ((InternalEObject)diff.getValue()).eProxyURI();
        int leftProxyIndex = -1;
        int rightProxyIndex = -1;
        int originProxyIndex = -1;
        int i = 0;
        while (i < leftValue.size() && leftProxyIndex == -1) {
            candidate = (EObject)leftValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                leftProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < rightValue.size() && rightProxyIndex == -1) {
            candidate = (EObject)rightValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                rightProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < originValue.size() && originProxyIndex == -1) {
            candidate = (EObject)originValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                originProxyIndex = i;
            }
            ++i;
        }
        Assert.assertTrue((leftProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((rightProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)-1L, (long)originProxyIndex);
        Assert.assertEquals((long)leftProxyIndex, (long)rightProxyIndex);
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiDel2WayLtR() throws IOException {
        EObject candidate;
        Resource left = this.input.getReferenceMultiDelLeftOutOfScope();
        Resource right = this.input.getReferenceMultiDelRightOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"multiValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyLeftToRight((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        List leftValue = (List)leftDiffContainer.eGet(feature, false);
        List rightValue = (List)rightDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)2L, (long)leftValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        URI proxyURI = ((InternalEObject)diff.getValue()).eProxyURI();
        int leftProxyIndex = -1;
        int rightProxyIndex = -1;
        int i = 0;
        while (i < leftValue.size() && leftProxyIndex == -1) {
            candidate = (EObject)leftValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                leftProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < rightValue.size() && rightProxyIndex == -1) {
            candidate = (EObject)rightValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                rightProxyIndex = i;
            }
            ++i;
        }
        Assert.assertEquals((long)-1L, (long)leftProxyIndex);
        Assert.assertEquals((long)-1L, (long)rightProxyIndex);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiDel2WayRtL() throws IOException {
        EObject candidate;
        Resource left = this.input.getReferenceMultiDelLeftOutOfScope();
        Resource right = this.input.getReferenceMultiDelRightOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"multiValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyRightToLeft((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        List leftValue = (List)leftDiffContainer.eGet(feature, false);
        List rightValue = (List)rightDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)3L, (long)leftValue.size());
        Assert.assertEquals((long)3L, (long)rightValue.size());
        URI proxyURI = ((InternalEObject)diff.getValue()).eProxyURI();
        int leftProxyIndex = -1;
        int rightProxyIndex = -1;
        int i = 0;
        while (i < leftValue.size() && leftProxyIndex == -1) {
            candidate = (EObject)leftValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                leftProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < rightValue.size() && rightProxyIndex == -1) {
            candidate = (EObject)rightValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                rightProxyIndex = i;
            }
            ++i;
        }
        Assert.assertTrue((leftProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((rightProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)leftProxyIndex, (long)rightProxyIndex);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiDel3WayLeftChangeLtR() throws IOException {
        EObject candidate;
        Resource left = this.input.getReferenceMultiDelLeftOutOfScope();
        Resource right = this.input.getReferenceMultiDelRightOutOfScope();
        Resource origin = this.input.getReferenceMultiDelOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"multiValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyLeftToRight((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        List leftValue = (List)leftDiffContainer.eGet(feature, false);
        List rightValue = (List)rightDiffContainer.eGet(feature, false);
        List originValue = (List)originDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)2L, (long)leftValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        Assert.assertEquals((long)3L, (long)originValue.size());
        URI proxyURI = ((InternalEObject)diff.getValue()).eProxyURI();
        int leftProxyIndex = -1;
        int rightProxyIndex = -1;
        int originProxyIndex = -1;
        int i = 0;
        while (i < leftValue.size() && leftProxyIndex == -1) {
            candidate = (EObject)leftValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                leftProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < rightValue.size() && rightProxyIndex == -1) {
            candidate = (EObject)rightValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                rightProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < originValue.size() && originProxyIndex == -1) {
            candidate = (EObject)originValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                originProxyIndex = i;
            }
            ++i;
        }
        Assert.assertEquals((long)-1L, (long)leftProxyIndex);
        Assert.assertEquals((long)-1L, (long)rightProxyIndex);
        Assert.assertEquals((long)2L, (long)originProxyIndex);
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiDel3WayRightChangeRtL() throws IOException {
        EObject candidate;
        Resource left = this.input.getReferenceMultiDelRightOutOfScope();
        Resource right = this.input.getReferenceMultiDelLeftOutOfScope();
        Resource origin = this.input.getReferenceMultiDelOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"multiValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyRightToLeft((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        List leftValue = (List)leftDiffContainer.eGet(feature, false);
        List rightValue = (List)rightDiffContainer.eGet(feature, false);
        List originValue = (List)originDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)2L, (long)leftValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        Assert.assertEquals((long)3L, (long)originValue.size());
        URI proxyURI = ((InternalEObject)diff.getValue()).eProxyURI();
        int leftProxyIndex = -1;
        int rightProxyIndex = -1;
        int originProxyIndex = -1;
        int i = 0;
        while (i < leftValue.size() && leftProxyIndex == -1) {
            candidate = (EObject)leftValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                leftProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < rightValue.size() && rightProxyIndex == -1) {
            candidate = (EObject)rightValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                rightProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < originValue.size() && originProxyIndex == -1) {
            candidate = (EObject)originValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                originProxyIndex = i;
            }
            ++i;
        }
        Assert.assertEquals((long)-1L, (long)leftProxyIndex);
        Assert.assertEquals((long)-1L, (long)rightProxyIndex);
        Assert.assertEquals((long)2L, (long)originProxyIndex);
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiDel3WayRightChangeLtR() throws IOException {
        EObject candidate;
        Resource left = this.input.getReferenceMultiDelRightOutOfScope();
        Resource right = this.input.getReferenceMultiDelLeftOutOfScope();
        Resource origin = this.input.getReferenceMultiDelOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"multiValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyLeftToRight((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        List leftValue = (List)leftDiffContainer.eGet(feature, false);
        List rightValue = (List)rightDiffContainer.eGet(feature, false);
        List originValue = (List)originDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)3L, (long)leftValue.size());
        Assert.assertEquals((long)3L, (long)rightValue.size());
        Assert.assertEquals((long)3L, (long)originValue.size());
        URI proxyURI = ((InternalEObject)diff.getValue()).eProxyURI();
        int leftProxyIndex = -1;
        int rightProxyIndex = -1;
        int originProxyIndex = -1;
        int i = 0;
        while (i < leftValue.size() && leftProxyIndex == -1) {
            candidate = (EObject)leftValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                leftProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < rightValue.size() && rightProxyIndex == -1) {
            candidate = (EObject)rightValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                rightProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < originValue.size() && originProxyIndex == -1) {
            candidate = (EObject)originValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                originProxyIndex = i;
            }
            ++i;
        }
        Assert.assertTrue((leftProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((rightProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)originProxyIndex);
        Assert.assertEquals((long)leftProxyIndex, (long)rightProxyIndex);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiDel3WayLeftChangeRtL() throws IOException {
        EObject candidate;
        Resource left = this.input.getReferenceMultiDelLeftOutOfScope();
        Resource right = this.input.getReferenceMultiDelRightOutOfScope();
        Resource origin = this.input.getReferenceMultiDelOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"multiValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyRightToLeft((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        List leftValue = (List)leftDiffContainer.eGet(feature, false);
        List rightValue = (List)rightDiffContainer.eGet(feature, false);
        List originValue = (List)originDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)3L, (long)leftValue.size());
        Assert.assertEquals((long)3L, (long)rightValue.size());
        Assert.assertEquals((long)3L, (long)originValue.size());
        URI proxyURI = ((InternalEObject)diff.getValue()).eProxyURI();
        int leftProxyIndex = -1;
        int rightProxyIndex = -1;
        int originProxyIndex = -1;
        int i = 0;
        while (i < leftValue.size() && leftProxyIndex == -1) {
            candidate = (EObject)leftValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                leftProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < rightValue.size() && rightProxyIndex == -1) {
            candidate = (EObject)rightValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                rightProxyIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < originValue.size() && originProxyIndex == -1) {
            candidate = (EObject)originValue.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                originProxyIndex = i;
            }
            ++i;
        }
        Assert.assertTrue((leftProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((rightProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)originProxyIndex);
        Assert.assertEquals((long)leftProxyIndex, (long)rightProxyIndex);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiMove2WayLtR() throws IOException {
        Resource left = this.input.getReferenceMultiMoveLeftOutOfScope();
        Resource right = this.input.getReferenceMultiMoveRightOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"multiValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        List leftValue = (List)leftDiffContainer.eGet(feature, false);
        List rightValue = (List)rightDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)2L, (long)leftValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        URI proxyURI = ((InternalEObject)diff.getValue()).eProxyURI();
        int leftProxyIndex = this.findProxyIndexIn(proxyURI, leftValue);
        int rightProxyIndex = this.findProxyIndexIn(proxyURI, rightValue);
        Assert.assertTrue((leftProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((rightProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertFalse((leftProxyIndex == rightProxyIndex ? 1 : 0) != 0);
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyLeftToRight((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        leftValue = (List)leftDiffContainer.eGet(feature, false);
        rightValue = (List)rightDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)2L, (long)leftValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        leftProxyIndex = this.findProxyIndexIn(proxyURI, leftValue);
        rightProxyIndex = this.findProxyIndexIn(proxyURI, rightValue);
        Assert.assertTrue((leftProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((rightProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)leftProxyIndex, (long)rightProxyIndex);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiMove2WayRtL() throws IOException {
        Resource left = this.input.getReferenceMultiMoveLeftOutOfScope();
        Resource right = this.input.getReferenceMultiMoveRightOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"multiValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        List leftValue = (List)leftDiffContainer.eGet(feature, false);
        List rightValue = (List)rightDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)2L, (long)leftValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        URI proxyURI = ((InternalEObject)diff.getValue()).eProxyURI();
        int leftProxyIndex = this.findProxyIndexIn(proxyURI, leftValue);
        int rightProxyIndex = this.findProxyIndexIn(proxyURI, rightValue);
        Assert.assertTrue((leftProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((rightProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertFalse((leftProxyIndex == rightProxyIndex ? 1 : 0) != 0);
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyRightToLeft((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        leftValue = (List)leftDiffContainer.eGet(feature, false);
        rightValue = (List)rightDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)2L, (long)leftValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        leftProxyIndex = this.findProxyIndexIn(proxyURI, leftValue);
        rightProxyIndex = this.findProxyIndexIn(proxyURI, rightValue);
        Assert.assertTrue((leftProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((rightProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)leftProxyIndex, (long)rightProxyIndex);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiMove3WayLeftChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMultiMoveLeftOutOfScope();
        Resource right = this.input.getReferenceMultiMoveRightOutOfScope();
        Resource origin = this.input.getReferenceMultiMoveOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"multiValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        List leftValue = (List)leftDiffContainer.eGet(feature, false);
        List rightValue = (List)rightDiffContainer.eGet(feature, false);
        List originValue = (List)originDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)2L, (long)leftValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        URI proxyURI = ((InternalEObject)diff.getValue()).eProxyURI();
        int leftProxyIndex = this.findProxyIndexIn(proxyURI, leftValue);
        int rightProxyIndex = this.findProxyIndexIn(proxyURI, rightValue);
        int originProxyIndex = this.findProxyIndexIn(proxyURI, originValue);
        Assert.assertTrue((leftProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((rightProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((originProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertFalse((leftProxyIndex == rightProxyIndex ? 1 : 0) != 0);
        Assert.assertEquals((long)rightProxyIndex, (long)originProxyIndex);
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyLeftToRight((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        leftValue = (List)leftDiffContainer.eGet(feature, false);
        rightValue = (List)rightDiffContainer.eGet(feature, false);
        originValue = (List)originDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)2L, (long)leftValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        Assert.assertEquals((long)2L, (long)originValue.size());
        leftProxyIndex = this.findProxyIndexIn(proxyURI, leftValue);
        rightProxyIndex = this.findProxyIndexIn(proxyURI, rightValue);
        originProxyIndex = this.findProxyIndexIn(proxyURI, originValue);
        Assert.assertTrue((leftProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((rightProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((originProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)leftProxyIndex, (long)rightProxyIndex);
        Assert.assertFalse((leftProxyIndex == originProxyIndex ? 1 : 0) != 0);
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiMove3WayLeftChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMultiMoveLeftOutOfScope();
        Resource right = this.input.getReferenceMultiMoveRightOutOfScope();
        Resource origin = this.input.getReferenceMultiMoveOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"multiValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        List leftValue = (List)leftDiffContainer.eGet(feature, false);
        List rightValue = (List)rightDiffContainer.eGet(feature, false);
        List originValue = (List)originDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)2L, (long)leftValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        URI proxyURI = ((InternalEObject)diff.getValue()).eProxyURI();
        int leftProxyIndex = this.findProxyIndexIn(proxyURI, leftValue);
        int rightProxyIndex = this.findProxyIndexIn(proxyURI, rightValue);
        int originProxyIndex = this.findProxyIndexIn(proxyURI, originValue);
        Assert.assertTrue((leftProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((rightProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((originProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertFalse((leftProxyIndex == rightProxyIndex ? 1 : 0) != 0);
        Assert.assertEquals((long)rightProxyIndex, (long)originProxyIndex);
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyRightToLeft((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        leftValue = (List)leftDiffContainer.eGet(feature, false);
        rightValue = (List)rightDiffContainer.eGet(feature, false);
        originValue = (List)originDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)2L, (long)leftValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        Assert.assertEquals((long)2L, (long)originValue.size());
        leftProxyIndex = this.findProxyIndexIn(proxyURI, leftValue);
        rightProxyIndex = this.findProxyIndexIn(proxyURI, rightValue);
        originProxyIndex = this.findProxyIndexIn(proxyURI, originValue);
        Assert.assertTrue((leftProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((rightProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((originProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)leftProxyIndex, (long)rightProxyIndex);
        Assert.assertEquals((long)leftProxyIndex, (long)originProxyIndex);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiMove3WayRightChangeLtR() throws IOException {
        Resource left = this.input.getReferenceMultiMoveRightOutOfScope();
        Resource right = this.input.getReferenceMultiMoveLeftOutOfScope();
        Resource origin = this.input.getReferenceMultiMoveOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"multiValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        List leftValue = (List)leftDiffContainer.eGet(feature, false);
        List rightValue = (List)rightDiffContainer.eGet(feature, false);
        List originValue = (List)originDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)2L, (long)leftValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        URI proxyURI = ((InternalEObject)diff.getValue()).eProxyURI();
        int leftProxyIndex = this.findProxyIndexIn(proxyURI, leftValue);
        int rightProxyIndex = this.findProxyIndexIn(proxyURI, rightValue);
        int originProxyIndex = this.findProxyIndexIn(proxyURI, originValue);
        Assert.assertTrue((leftProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((rightProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((originProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertFalse((leftProxyIndex == rightProxyIndex ? 1 : 0) != 0);
        Assert.assertEquals((long)leftProxyIndex, (long)originProxyIndex);
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyLeftToRight((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        leftValue = (List)leftDiffContainer.eGet(feature, false);
        rightValue = (List)rightDiffContainer.eGet(feature, false);
        originValue = (List)originDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)2L, (long)leftValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        Assert.assertEquals((long)2L, (long)originValue.size());
        leftProxyIndex = this.findProxyIndexIn(proxyURI, leftValue);
        rightProxyIndex = this.findProxyIndexIn(proxyURI, rightValue);
        originProxyIndex = this.findProxyIndexIn(proxyURI, originValue);
        Assert.assertTrue((leftProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((rightProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((originProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)leftProxyIndex, (long)rightProxyIndex);
        Assert.assertEquals((long)leftProxyIndex, (long)originProxyIndex);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testReferenceMultiMove3WayRightChangeRtL() throws IOException {
        Resource left = this.input.getReferenceMultiMoveRightOutOfScope();
        Resource right = this.input.getReferenceMultiMoveLeftOutOfScope();
        Resource origin = this.input.getReferenceMultiMoveOriginOutOfScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        String featureName = "multiValuedReference";
        Assert.assertTrue((boolean)(differences.get(0) instanceof ReferenceChange));
        ReferenceChange diff = (ReferenceChange)differences.get(0);
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        Assert.assertEquals((Object)"multiValuedReference", (Object)diff.getReference().getName());
        EObject leftDiffContainer = this.getNodeNamed(left, "origin");
        EObject rightDiffContainer = this.getNodeNamed(right, "origin");
        EObject originDiffContainer = this.getNodeNamed(origin, "origin");
        Assert.assertSame((Object)leftDiffContainer, (Object)diff.getMatch().getLeft());
        Assert.assertSame((Object)rightDiffContainer, (Object)diff.getMatch().getRight());
        Assert.assertSame((Object)originDiffContainer, (Object)diff.getMatch().getOrigin());
        EStructuralFeature feature = leftDiffContainer.eClass().getEStructuralFeature("multiValuedReference");
        Assert.assertNotNull((Object)feature);
        List leftValue = (List)leftDiffContainer.eGet(feature, false);
        List rightValue = (List)rightDiffContainer.eGet(feature, false);
        List originValue = (List)originDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)2L, (long)leftValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        URI proxyURI = ((InternalEObject)diff.getValue()).eProxyURI();
        int leftProxyIndex = this.findProxyIndexIn(proxyURI, leftValue);
        int rightProxyIndex = this.findProxyIndexIn(proxyURI, rightValue);
        int originProxyIndex = this.findProxyIndexIn(proxyURI, originValue);
        Assert.assertTrue((leftProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((rightProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((originProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertFalse((leftProxyIndex == rightProxyIndex ? 1 : 0) != 0);
        Assert.assertEquals((long)leftProxyIndex, (long)originProxyIndex);
        this.mergerRegistry.getHighestRankingMerger((Diff)diff).copyRightToLeft((Diff)diff, (Monitor)new BasicMonitor());
        Assert.assertTrue((boolean)diff.getValue().eIsProxy());
        leftValue = (List)leftDiffContainer.eGet(feature, false);
        rightValue = (List)rightDiffContainer.eGet(feature, false);
        originValue = (List)originDiffContainer.eGet(feature, false);
        Assert.assertEquals((long)2L, (long)leftValue.size());
        Assert.assertEquals((long)2L, (long)rightValue.size());
        Assert.assertEquals((long)2L, (long)originValue.size());
        leftProxyIndex = this.findProxyIndexIn(proxyURI, leftValue);
        rightProxyIndex = this.findProxyIndexIn(proxyURI, rightValue);
        originProxyIndex = this.findProxyIndexIn(proxyURI, originValue);
        Assert.assertTrue((leftProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((rightProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertTrue((originProxyIndex != -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)leftProxyIndex, (long)rightProxyIndex);
        Assert.assertFalse((leftProxyIndex == originProxyIndex ? 1 : 0) != 0);
        scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    private EObject getNodeNamed(Resource res, String name) {
        TreeIterator iterator = EcoreUtil.getAllProperContents((Resource)res, (boolean)false);
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            EStructuralFeature nameFeature = next.eClass().getEStructuralFeature("name");
            if (nameFeature == null || !name.equals(next.eGet(nameFeature))) continue;
            return next;
        }
        return null;
    }

    private int findProxyIndexIn(URI proxyURI, List<EObject> list) {
        int i = 0;
        while (i < list.size()) {
            EObject candidate = list.get(i);
            if (candidate.eIsProxy() && proxyURI.equals(((InternalEObject)candidate).eProxyURI())) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

