/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.papyrus.contentmergeviewer.provider;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.contentmergeviewer.facet.FacetUtil;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.contentmergeviewer.facet.PapyrusFacetContentProviderWrapper;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.provider.CompareAccessorMergeViewerItemProvider;
import org.eclipse.emf.compare.match.impl.NotLoadedFragmentMatch;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.ICompareAccessor;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.provider.IMergeViewerItemProviderConfiguration;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class PapyrusCompareAccessorMergeViewerItemProvider
extends CompareAccessorMergeViewerItemProvider {
    public List<Object> getMergeViewerItems(Object object, final IMergeViewerItemProviderConfiguration configuration) {
        if (!ICompareAccessor.class.isInstance(object)) {
            return super.getMergeViewerItems(object, configuration);
        }
        final List<Object> papyrusRootElements = this.getModelExplorerRootElements(configuration);
        List mergeViewerItems = super.getMergeViewerItems(object, configuration);
        Iterable filtered = Iterables.filter((Iterable)mergeViewerItems, (Predicate)new Predicate<Object>(){

            public boolean apply(Object input) {
                if (IMergeViewerItem.class.isInstance(input)) {
                    IMergeViewerItem item = (IMergeViewerItem)IMergeViewerItem.class.cast(input);
                    Object sideValue = item.getSideValue(configuration.getSide());
                    if (NotLoadedFragmentMatch.class.isInstance(sideValue)) {
                        Match matchChild = ((NotLoadedFragmentMatch)NotLoadedFragmentMatch.class.cast(sideValue)).getFirstMatchChild();
                        sideValue = PapyrusCompareAccessorMergeViewerItemProvider.this.getSide(matchChild, configuration.getSide());
                    }
                    return papyrusRootElements.contains(sideValue);
                }
                return false;
            }
        });
        return Lists.newArrayList((Iterable)filtered);
    }

    private List<Object> getModelExplorerRootElements(IMergeViewerItemProviderConfiguration configuration) {
        ResourceSet resourceSet = this.getResourceSet(configuration.getComparison(), configuration.getSide());
        PapyrusFacetContentProviderWrapper wrapper = new PapyrusFacetContentProviderWrapper(configuration.getAdapterFactory(), resourceSet);
        Collection<?> elements = wrapper.getElements(resourceSet);
        wrapper.dispose();
        return Lists.newArrayList((Iterable)Iterables.transform(elements, FacetUtil.UN_WRAP));
    }

    private ResourceSet getResourceSet(Comparison comparison, IMergeViewer.MergeViewerSide side) {
        for (MatchResource matchResource : comparison.getMatchedResources()) {
            Resource resource = this.getResource(matchResource, side);
            if (resource == null) continue;
            return resource.getResourceSet();
        }
        return null;
    }

    private Resource getResource(MatchResource matchResource, IMergeViewer.MergeViewerSide side) {
        if (side == IMergeViewer.MergeViewerSide.LEFT) {
            return matchResource.getLeft();
        }
        if (side == IMergeViewer.MergeViewerSide.RIGHT) {
            return matchResource.getRight();
        }
        if (side == IMergeViewer.MergeViewerSide.ANCESTOR) {
            return matchResource.getOrigin();
        }
        return null;
    }

    private Object getSide(Match match, IMergeViewer.MergeViewerSide side) {
        if (side == IMergeViewer.MergeViewerSide.LEFT) {
            return match.getLeft();
        }
        if (side == IMergeViewer.MergeViewerSide.RIGHT) {
            return match.getRight();
        }
        if (side == IMergeViewer.MergeViewerSide.ANCESTOR) {
            return match.getOrigin();
        }
        return null;
    }
}

