/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.merge.DiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.IMerger2;

public class CachingDiffRelationshipComputer
implements IDiffRelationshipComputer {
    protected IDiffRelationshipComputer computer;
    protected Map<Diff, Set<Diff>> directMergeDependenciesR2L = new ConcurrentHashMap<Diff, Set<Diff>>();
    protected Map<Diff, Set<Diff>> directMergeDependenciesL2R = new ConcurrentHashMap<Diff, Set<Diff>>();
    protected Map<Diff, Set<Diff>> directResultingMergesR2L = new ConcurrentHashMap<Diff, Set<Diff>>();
    protected Map<Diff, Set<Diff>> directResultingMergesL2R = new ConcurrentHashMap<Diff, Set<Diff>>();
    protected Map<Diff, Set<Diff>> directResultingRejectionsR2L = new ConcurrentHashMap<Diff, Set<Diff>>();
    protected Map<Diff, Set<Diff>> directResultingRejectionsL2R = new ConcurrentHashMap<Diff, Set<Diff>>();
    protected Map<Diff, Set<Diff>> allResultingMergesR2L = new ConcurrentHashMap<Diff, Set<Diff>>();
    protected Map<Diff, Set<Diff>> allResultingMergesL2R = new ConcurrentHashMap<Diff, Set<Diff>>();
    protected Map<Diff, Set<Diff>> allResultingRejectionsR2L = new ConcurrentHashMap<Diff, Set<Diff>>();
    protected Map<Diff, Set<Diff>> allResultingRejectionsL2R = new ConcurrentHashMap<Diff, Set<Diff>>();

    public CachingDiffRelationshipComputer(IMerger.Registry registry) {
        this(registry, IMergeCriterion.NONE);
    }

    public CachingDiffRelationshipComputer(IMerger.Registry registry, IMergeCriterion criterion) {
        this(new DiffRelationshipComputer(registry, criterion));
    }

    public CachingDiffRelationshipComputer(IDiffRelationshipComputer computer) {
        this.computer = computer;
    }

    protected IDiffRelationshipComputer getComputer() {
        return this.computer;
    }

    @Override
    public IMerger.Registry getMergerRegistry() {
        return this.getComputer().getMergerRegistry();
    }

    @Override
    public void setMergerRegistry(IMerger.Registry mergerRegistry) {
        if (this.getMergerRegistry() != mergerRegistry) {
            this.getComputer().setMergerRegistry(mergerRegistry);
            this.invalidate();
        }
    }

    @Override
    public IMergeCriterion getMergeCriterion() {
        return this.getComputer().getMergeCriterion();
    }

    @Override
    public IMerger2 getMerger(Diff diff) {
        return this.getComputer().getMerger(diff);
    }

    @Override
    public boolean hasMerger(Diff diff) {
        return this.getComputer().hasMerger(diff);
    }

    @Override
    public void setMergeCriterion(IMergeCriterion mergeCriterion) {
        if (this.getMergeCriterion() != mergeCriterion) {
            this.getComputer().setMergeCriterion(mergeCriterion);
            this.invalidate();
        }
    }

    protected void setCachedDirectMergeDependencies(Diff diff, boolean mergeRightToLeft, Set<Diff> directMergeDependencies) {
        if (mergeRightToLeft) {
            this.directMergeDependenciesR2L.put(diff, directMergeDependencies);
        } else {
            this.directMergeDependenciesL2R.put(diff, directMergeDependencies);
        }
    }

    protected Set<Diff> getCachedDirectMergeDependencies(Diff diff, boolean mergeRightToLeft) {
        if (mergeRightToLeft) {
            return this.directMergeDependenciesR2L.get(diff);
        }
        return this.directMergeDependenciesL2R.get(diff);
    }

    protected Set<Diff> computeDirectMergeDependencies(Diff diff, boolean mergeRightToLeft) {
        return this.getComputer().getDirectMergeDependencies(diff, mergeRightToLeft);
    }

    @Override
    public Set<Diff> getDirectMergeDependencies(Diff diff, boolean mergeRightToLeft) {
        Set<Diff> directMergeDependencies = this.getCachedDirectMergeDependencies(diff, mergeRightToLeft);
        if (directMergeDependencies == null) {
            directMergeDependencies = this.computeDirectMergeDependencies(diff, mergeRightToLeft);
            this.setCachedDirectMergeDependencies(diff, mergeRightToLeft, directMergeDependencies);
        }
        return directMergeDependencies;
    }

    protected void setCachedDirectResultingMerges(Diff diff, boolean mergeRightToLeft, Set<Diff> directResultingMerges) {
        if (mergeRightToLeft) {
            this.directResultingMergesR2L.put(diff, directResultingMerges);
        } else {
            this.directResultingMergesL2R.put(diff, directResultingMerges);
        }
    }

    protected Set<Diff> getCachedDirectResultingMerges(Diff diff, boolean mergeRightToLeft) {
        if (mergeRightToLeft) {
            return this.directResultingMergesR2L.get(diff);
        }
        return this.directResultingMergesL2R.get(diff);
    }

    protected Set<Diff> computeDirectResultingMerges(Diff diff, boolean mergeRightToLeft) {
        return this.getComputer().getDirectResultingMerges(diff, mergeRightToLeft);
    }

    @Override
    public Set<Diff> getDirectResultingMerges(Diff diff, boolean mergeRightToLeft) {
        Set<Diff> directResultingMerges = this.getCachedDirectResultingMerges(diff, mergeRightToLeft);
        if (directResultingMerges == null) {
            directResultingMerges = this.computeDirectResultingMerges(diff, mergeRightToLeft);
            this.setCachedDirectResultingMerges(diff, mergeRightToLeft, directResultingMerges);
        }
        return directResultingMerges;
    }

    protected void setCachedDirectResultingRejections(Diff diff, boolean mergeRightToLeft, Set<Diff> directResultingRejections) {
        if (mergeRightToLeft) {
            this.directResultingRejectionsR2L.put(diff, directResultingRejections);
        } else {
            this.directResultingRejectionsL2R.put(diff, directResultingRejections);
        }
    }

    protected Set<Diff> getCachedDirectResultingRejections(Diff diff, boolean mergeRightToLeft) {
        if (mergeRightToLeft) {
            return this.directResultingRejectionsR2L.get(diff);
        }
        return this.directResultingRejectionsL2R.get(diff);
    }

    protected Set<Diff> computeDirectResultingRejections(Diff diff, boolean mergeRightToLeft) {
        return this.getComputer().getDirectResultingRejections(diff, mergeRightToLeft);
    }

    @Override
    public Set<Diff> getDirectResultingRejections(Diff diff, boolean mergeRightToLeft) {
        Set<Diff> directResultingRejections = this.getCachedDirectResultingRejections(diff, mergeRightToLeft);
        if (directResultingRejections == null) {
            directResultingRejections = this.computeDirectResultingRejections(diff, mergeRightToLeft);
            this.setCachedDirectResultingRejections(diff, mergeRightToLeft, directResultingRejections);
        }
        return directResultingRejections;
    }

    protected void setCachedAllResultingRejections(Diff diff, boolean mergeRightToLeft, Set<Diff> allResultingRejections) {
        if (mergeRightToLeft) {
            this.allResultingRejectionsR2L.put(diff, allResultingRejections);
        } else {
            this.allResultingRejectionsL2R.put(diff, allResultingRejections);
        }
    }

    protected Set<Diff> getCachedAllResultingRejections(Diff diff, boolean mergeRightToLeft) {
        if (mergeRightToLeft) {
            return this.allResultingRejectionsR2L.get(diff);
        }
        return this.allResultingRejectionsL2R.get(diff);
    }

    protected Set<Diff> computeAllResultingRejections(Diff diff, boolean mergeRightToLeft) {
        return this.getComputer().getAllResultingRejections(diff, mergeRightToLeft);
    }

    @Override
    public Set<Diff> getAllResultingRejections(Diff diff, boolean mergeRightToLeft) {
        Set<Diff> allResultingRejections = this.getCachedAllResultingRejections(diff, mergeRightToLeft);
        if (allResultingRejections == null) {
            allResultingRejections = this.computeAllResultingRejections(diff, mergeRightToLeft);
            this.setCachedAllResultingRejections(diff, mergeRightToLeft, allResultingRejections);
        }
        return allResultingRejections;
    }

    protected void setCachedAllResultingMerges(Diff diff, boolean mergeRightToLeft, Set<Diff> allResultingMerges) {
        if (mergeRightToLeft) {
            this.allResultingMergesR2L.put(diff, allResultingMerges);
        } else {
            this.allResultingMergesL2R.put(diff, allResultingMerges);
        }
    }

    protected Set<Diff> getCachedAllResultingMerges(Diff diff, boolean mergeRightToLeft) {
        if (mergeRightToLeft) {
            return this.allResultingMergesR2L.get(diff);
        }
        return this.allResultingMergesL2R.get(diff);
    }

    protected Set<Diff> computeAllResultingMerges(Diff diff, boolean mergeRightToLeft) {
        return this.getComputer().getAllResultingMerges(diff, mergeRightToLeft);
    }

    @Override
    public Set<Diff> getAllResultingMerges(Diff diff, boolean mergeRightToLeft) {
        Set<Diff> allResultingMerges = this.getCachedAllResultingMerges(diff, mergeRightToLeft);
        if (allResultingMerges == null) {
            allResultingMerges = this.computeAllResultingMerges(diff, mergeRightToLeft);
            this.setCachedAllResultingMerges(diff, mergeRightToLeft, allResultingMerges);
        }
        return allResultingMerges;
    }

    public void invalidate(Diff diff) {
        this.directMergeDependenciesR2L.remove(diff);
        this.directMergeDependenciesL2R.remove(diff);
        this.directResultingRejectionsR2L.remove(diff);
        this.directResultingRejectionsL2R.remove(diff);
        this.directResultingMergesR2L.remove(diff);
        this.directResultingMergesL2R.remove(diff);
        this.allResultingMergesL2R.remove(diff);
        this.allResultingMergesR2L.remove(diff);
        this.allResultingRejectionsL2R.remove(diff);
        this.allResultingRejectionsR2L.remove(diff);
    }

    public void invalidate(Iterable<Diff> diffs) {
        for (Diff diff : diffs) {
            this.invalidate(diff);
        }
    }

    public void invalidate() {
        this.directMergeDependenciesR2L.clear();
        this.directMergeDependenciesL2R.clear();
        this.directResultingRejectionsR2L.clear();
        this.directResultingRejectionsL2R.clear();
        this.directResultingMergesR2L.clear();
        this.directResultingMergesL2R.clear();
        this.allResultingMergesL2R.clear();
        this.allResultingMergesR2L.clear();
        this.allResultingRejectionsL2R.clear();
        this.allResultingRejectionsR2L.clear();
    }
}

