/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.utils;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.concurrent.ExecutionException;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;

public class EqualityHelper
extends AdapterImpl
implements IEqualityHelper {
    private final LoadingCache<EObject, URI> uriCache;
    private WeakReference<EObject> lastMatchedEObject;
    private WeakReference<Match> lastMatch;

    @Deprecated
    public EqualityHelper() {
        this(EqualityHelper.createDefaultCache((CacheBuilder<Object, Object>)CacheBuilder.newBuilder().maximumSize(1024L)));
    }

    public EqualityHelper(LoadingCache<EObject, URI> uriCache) {
        this.uriCache = uriCache;
    }

    @Override
    public Comparison getTarget() {
        return (Comparison)super.getTarget();
    }

    public boolean isAdapterForType(Object type) {
        return type == IEqualityHelper.class;
    }

    @Deprecated
    public boolean matchingValues(Comparison comparison, Object object1, Object object2) {
        return this.matchingValues(object1, object2);
    }

    @Override
    public boolean matchingValues(Object object1, Object object2) {
        boolean equal;
        if (object1 == object2) {
            equal = true;
        } else if (object1 == null) {
            equal = "".equals(object2);
        } else if (object2 == null) {
            equal = "".equals(object1);
        } else if (object1 instanceof EObject) {
            equal = object2 instanceof EObject ? this.matchingEObjects((EObject)object1, (EObject)object2) : false;
        } else if (object1 instanceof String || object1 instanceof Integer || object1 instanceof Boolean) {
            equal = object1.equals(object2);
        } else if (object1.getClass().isArray() && object2.getClass().isArray()) {
            equal = this.matchingArrays(object1, object2);
        } else if (object1 instanceof FeatureMap.Entry && object2 instanceof FeatureMap.Entry) {
            FeatureMap.Entry featureMapEntry1 = (FeatureMap.Entry)object1;
            EStructuralFeature key1 = featureMapEntry1.getEStructuralFeature();
            FeatureMap.Entry featureMapEntry2 = (FeatureMap.Entry)object2;
            EStructuralFeature key2 = featureMapEntry2.getEStructuralFeature();
            Object value1 = featureMapEntry1.getValue();
            Object value2 = featureMapEntry2.getValue();
            equal = key1.equals(key2) && this.matchingValues(value1, value2);
        } else {
            equal = object1.equals(object2);
        }
        return equal;
    }

    protected boolean matchingEObjects(EObject object1, EObject object2) {
        Match match = this.getMatch(object1);
        boolean equal = match != null ? match.getLeft() == object2 || match.getRight() == object2 || match.getOrigin() == object2 : (this.getTarget().getMatch(object2) != null ? false : (object1.eClass() != object2.eClass() ? false : this.matchingURIs(object1, object2)));
        return equal;
    }

    protected Match getMatch(EObject o) {
        Match match;
        if (this.lastMatchedEObject != null && this.lastMatchedEObject.get() == o) {
            Match temp = (Match)this.lastMatch.get();
            if (temp != null) {
                match = temp;
            } else {
                match = this.getTarget().getMatch(o);
                this.lastMatch = new WeakReference<Match>(match);
            }
        } else {
            match = this.getTarget().getMatch(o);
            this.lastMatchedEObject = new WeakReference<EObject>(o);
            this.lastMatch = new WeakReference<Match>(match);
        }
        return match;
    }

    protected boolean matchingURIs(EObject object1, EObject object2) {
        boolean equal;
        if (!object1.eIsProxy() && this.isUncontained(object1) || !object2.eIsProxy() && this.isUncontained(object2)) {
            return false;
        }
        URI uri1 = (URI)this.uriCache.getUnchecked((Object)object1);
        URI uri2 = (URI)this.uriCache.getUnchecked((Object)object2);
        if (uri1.hasFragment() && uri2.hasFragment()) {
            String uri1Fragment = this.removeURIAttachment(uri1.fragment());
            String uri2Fragment = this.removeURIAttachment(uri2.fragment());
            equal = uri1Fragment.equals(uri2Fragment);
        } else {
            equal = uri1.equals(uri2);
        }
        return equal;
    }

    private String removeURIAttachment(String fragment) {
        boolean hasTwoQuestionMarks;
        int questionMark1 = fragment.indexOf(63);
        boolean bl = hasTwoQuestionMarks = questionMark1 != -1 && fragment.indexOf(63, questionMark1 + 1) != -1;
        if (hasTwoQuestionMarks) {
            return fragment.substring(0, questionMark1);
        }
        return fragment;
    }

    private boolean isUncontained(EObject object) {
        return object.eContainer() == null && object.eResource() == null;
    }

    @Override
    public boolean matchingAttributeValues(Object object1, Object object2) {
        return this.matchingValues(object1, object2);
    }

    private boolean matchingArrays(Object object1, Object object2) {
        boolean equal = true;
        int length1 = Array.getLength(object1);
        if (length1 != Array.getLength(object2)) {
            equal = false;
        } else {
            int i = 0;
            while (i < length1 && equal) {
                Object element1 = Array.get(object1, i);
                Object element2 = Array.get(object2, i);
                equal = this.matchingValues(element1, element2);
                ++i;
            }
        }
        return equal;
    }

    @Deprecated
    public URI getURI(EObject object) {
        try {
            return (URI)this.uriCache.get((Object)object);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Deprecated
    public Cache<EObject, URI> getCache() {
        return this.uriCache;
    }

    public static LoadingCache<EObject, URI> createDefaultCache(CacheBuilder<Object, Object> cacheBuilder) {
        return cacheBuilder.build(CacheLoader.from((Function)new URICacheFunction()));
    }

    private static class URICacheFunction
    implements Function<EObject, URI> {
        private URICacheFunction() {
        }

        public URI apply(EObject input) {
            if (input == null) {
                return null;
            }
            return EcoreUtil.getURI((EObject)input);
        }
    }
}

