/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.checkers;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.merge.DiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;
import org.junit.Assert;

public class MergeDependenciesChecker {
    private IMerger.Registry registry;
    private Diff diff;
    private int nbMerges = 0;
    private int nbRejections = 0;
    private boolean rightToLeft = true;

    private MergeDependenciesChecker() {
    }

    private MergeDependenciesChecker(IMerger.Registry mergerRegistry, Diff testedDiff) {
        this.registry = mergerRegistry;
        this.diff = testedDiff;
    }

    public static MergeDependenciesChecker getDependenciesChecker(IMerger.Registry mergerRegistry, Diff testedDiff) {
        return new MergeDependenciesChecker(mergerRegistry, testedDiff);
    }

    public MergeDependenciesChecker implies(int nbResultingMerges) {
        this.nbMerges = nbResultingMerges;
        return this;
    }

    public MergeDependenciesChecker rejects(int nbResultingRejections) {
        this.nbRejections = nbResultingRejections;
        return this;
    }

    public MergeDependenciesChecker rightToLeft() {
        this.rightToLeft = true;
        return this;
    }

    public MergeDependenciesChecker leftToRight() {
        this.rightToLeft = false;
        return this;
    }

    public void check() {
        DiffRelationshipComputer computer = new DiffRelationshipComputer(this.registry);
        Set allResultingMerges = computer.getAllResultingMerges(this.diff, this.rightToLeft);
        Set allResultingRejections = computer.getAllResultingRejections(this.diff, this.rightToLeft);
        Assert.assertEquals((long)this.nbMerges, (long)Sets.difference((Set)allResultingMerges, (Set)allResultingRejections).size());
        Assert.assertEquals((long)this.nbRejections, (long)allResultingRejections.size());
    }
}

