/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.diff;

import java.io.IOException;
import org.eclipse.emf.compare.internal.ThreeWayTextDiff;
import org.junit.Assert;
import org.junit.Test;

public class ThreeWayTextDiffTest {
    private static final String NL = "\n";

    @Test
    public void changeSingleLineTextOnOneSide() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?";
        String left = "They don't call it a Quarter Pounder with Cheese?";
        String right = "They do not call it a Quarter Pounder with Cheese?";
        String merged = "They do not call it a Quarter Pounder with Cheese?";
        this.assertNonConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?", "They don't call it a Quarter Pounder with Cheese?", "They do not call it a Quarter Pounder with Cheese?");
        this.assertMergedBidirectional("They don't call it a Quarter Pounder with Cheese?", "They don't call it a Quarter Pounder with Cheese?", "They do not call it a Quarter Pounder with Cheese?", "They do not call it a Quarter Pounder with Cheese?");
    }

    @Test
    public void setSingleLineTextOnOneSide() throws IOException {
        String origin = null;
        String left = "They don't call it a Quarter Pounder with Cheese?";
        String right = null;
        String merged = "They don't call it a Quarter Pounder with Cheese?";
        this.assertNonConflictingBidirectional(origin, "They don't call it a Quarter Pounder with Cheese?", right);
        this.assertMergedBidirectional(origin, "They don't call it a Quarter Pounder with Cheese?", right, "They don't call it a Quarter Pounder with Cheese?");
    }

    @Test
    public void addSingleLineTextOnOneSide() throws IOException {
        String origin = "";
        String left = "They don't call it a Quarter Pounder with Cheese?";
        String right = "";
        String merged = "They don't call it a Quarter Pounder with Cheese?";
        this.assertNonConflictingBidirectional("", "They don't call it a Quarter Pounder with Cheese?", "");
        this.assertMergedBidirectional("", "They don't call it a Quarter Pounder with Cheese?", "", "They don't call it a Quarter Pounder with Cheese?");
    }

    @Test
    public void changeSingleLineTextOnBothSides() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?";
        String left = "They don't call it a Quarter Pounder?";
        String right = "They do not call it a Quarter Pounder with Cheese?";
        this.assertConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?", "They don't call it a Quarter Pounder?", "They do not call it a Quarter Pounder with Cheese?");
    }

    @Test
    public void unsetSingleLineTextOnOneSide() throws IOException {
        String right;
        String origin = "They don't call it a Quarter Pounder with Cheese?";
        String left = "They don't call it a Quarter Pounder with Cheese?";
        String merged = right = null;
        this.assertNonConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?", "They don't call it a Quarter Pounder with Cheese?", right);
        this.assertMergedBidirectional("They don't call it a Quarter Pounder with Cheese?", "They don't call it a Quarter Pounder with Cheese?", right, merged);
    }

    @Test
    public void removeSingleLineTextOnOneSide() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?";
        String left = "They don't call it a Quarter Pounder with Cheese?";
        String right = "";
        String merged = "";
        this.assertNonConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?", "They don't call it a Quarter Pounder with Cheese?", "");
        this.assertMergedBidirectional("They don't call it a Quarter Pounder with Cheese?", "They don't call it a Quarter Pounder with Cheese?", "", "");
    }

    @Test
    public void changeAndRemoveSingleLine() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?";
        String left = "";
        String right = "Nah, they got the metric system, they wouldn't know what a Quarter Pounder is.";
        this.assertConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?", "", "Nah, they got the metric system, they wouldn't know what a Quarter Pounder is.");
    }

    @Test
    public void addDifferentSingleLineTextOnBothSide() throws IOException {
        String origin = "";
        String left = "They don't call it a Quarter Pounder with Cheese?";
        String right = "Nah, they got the metric system, they wouldn't know what a Quarter Pounder is.";
        this.assertConflictingBidirectional("", "They don't call it a Quarter Pounder with Cheese?", "Nah, they got the metric system, they wouldn't know what a Quarter Pounder is.");
    }

    @Test
    public void changeAndRemoveLinesInMultiLineTextOnOneSide() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String right = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String merged = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        this.assertNonConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.");
        this.assertMergedBidirectional("They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.");
    }

    @Test
    public void changeAndRemoveDifferentLinesInMultiLineOnTextBothSides() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a \"Big Mac\"?";
        String right = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String merged = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a \"Big Mac\"?";
        this.assertNonConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a \"Big Mac\"?", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.");
        this.assertMergedBidirectional("They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a \"Big Mac\"?", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a \"Big Mac\"?");
    }

    @Test
    public void changeSameLineInMultiLineTextOnBothSides() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a \"Royale with Cheese\".\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String right = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey'd call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        this.assertConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a \"Royale with Cheese\".\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey'd call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.");
    }

    @Test
    public void changeLineAndRemoveSameLineInMultiLineText() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a \"Royale with Cheese\".\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String right = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        this.assertConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a \"Royale with Cheese\".\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.");
    }

    @Test
    public void changeLineAndRemoveSameAreaInMultiLineTextOnBothSides() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a \"Royale with Cheese\".\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String right = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        this.assertConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a \"Royale with Cheese\".\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.");
    }

    @Test
    public void changeLineAndAddMultipleLinesInSameAreaInMultiLineTextOnBothSides() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a \"Royale with Cheese\".\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String right = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nI asked, what do they call it?\nDo you hear me?\nThey call it a Royale with Cheese.\nAlright.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String merged = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nI asked, what do they call it?\nDo you hear me?\nThey call it a \"Royale with Cheese\".\nAlright.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        this.assertNonConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a \"Royale with Cheese\".\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nI asked, what do they call it?\nDo you hear me?\nThey call it a Royale with Cheese.\nAlright.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.");
        this.assertMergedBidirectional("They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a \"Royale with Cheese\".\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nI asked, what do they call it?\nDo you hear me?\nThey call it a Royale with Cheese.\nAlright.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nI asked, what do they call it?\nDo you hear me?\nThey call it a \"Royale with Cheese\".\nAlright.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.");
    }

    @Test
    public void addDifferentLineAtSameLineInMultiLineText() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String right = "They don't call it a Quarter Pounder with Cheese?\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        this.assertConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.");
    }

    @Test
    public void addDifferentLineAtTheBeginningInMultiLineText() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        String left = "Whose chopper is this?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        String right = "Who's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        this.assertConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Whose chopper is this?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Who's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.");
    }

    @Test
    public void addDifferentLineAtTheEndOfMultiLineText() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nWhose chopper is this?\n";
        String right = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nWho's Zed?\n";
        this.assertConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nWhose chopper is this?\n", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nWho's Zed?\n");
    }

    @Test
    public void addDifferentMultipleLinesAtTheBeginningInMultiLineText() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        String left = "Whose chopper is this?\nIt's Zed's!\nWho is Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        String right = "Whose chopper is this?\nIt's Zed's!\nWho's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        this.assertConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Whose chopper is this?\nIt's Zed's!\nWho is Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Whose chopper is this?\nIt's Zed's!\nWho's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.");
    }

    @Test
    public void addSameMultipleLinesAtTheBeginningOfFirstLineInMultiLineText() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        String left = "Whose chopper is this?\nIt's Zed's!\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        String right = "Whose chopper is this?\nIt's Zed's!\nWho's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        String merged = "Whose chopper is this?\nIt's Zed's!\nWho's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        this.assertNonConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Whose chopper is this?\nIt's Zed's!\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Whose chopper is this?\nIt's Zed's!\nWho's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.");
        this.assertMergedBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Whose chopper is this?\nIt's Zed's!\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Whose chopper is this?\nIt's Zed's!\nWho's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Whose chopper is this?\nIt's Zed's!\nWho's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.");
    }

    @Test
    public void addSameMultipleLinesAtTheBeginningAndChangeOfFirstLineInMultiLineText() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        String left = "Whose chopper is this?\nIt's Zed's!\nThey do not call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        String right = "Whose chopper is this?\nIt's Zed's!\nWho's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        String merged = "Whose chopper is this?\nIt's Zed's!\nWho's Zed?\nThey do not call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        this.assertNonConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Whose chopper is this?\nIt's Zed's!\nThey do not call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Whose chopper is this?\nIt's Zed's!\nWho's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.");
        this.assertMergedBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Whose chopper is this?\nIt's Zed's!\nThey do not call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Whose chopper is this?\nIt's Zed's!\nWho's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Whose chopper is this?\nIt's Zed's!\nWho's Zed?\nThey do not call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.");
    }

    @Test
    public void addSameMultipleLinesAtTheBeginningAndChangeOfFirstLine2InMultiLineText() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        String left = "Whose chopper is this?\nIt's Zed's!\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        String right = "Whose chopper is this?\nIt's Zed's!\nWho's Zed?\nThey do not call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        String merged = "Whose chopper is this?\nIt's Zed's!\nWho's Zed?\nThey do not call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        this.assertNonConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Whose chopper is this?\nIt's Zed's!\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Whose chopper is this?\nIt's Zed's!\nWho's Zed?\nThey do not call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.");
        this.assertMergedBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Whose chopper is this?\nIt's Zed's!\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Whose chopper is this?\nIt's Zed's!\nWho's Zed?\nThey do not call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Whose chopper is this?\nIt's Zed's!\nWho's Zed?\nThey do not call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.");
    }

    @Test
    public void addDifferentLinesAtTheBeginningInMultiLineText() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        String left = "Whose chopper is this?\nWhose chopper is this?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        String right = "Who's Zed?\nIt's Zed's.\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        this.assertConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Whose chopper is this?\nWhose chopper is this?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Who's Zed?\nIt's Zed's.\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.");
    }

    @Test
    public void addSameLineAtTheBeginningInMultiLineText() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        String left = "Who's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        String right = "Who's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        String merged = "Who's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.";
        this.assertNonConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Who's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Who's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.");
        this.assertMergedBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Who's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Who's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.", "Who's Zed?\nThey don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.");
    }

    @Test
    public void changeAndAddDifferentLinesOnBothSides() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system.1\nNah, they got the metric system.2\nNah, they got the metric system.3\nThey call it a \"Royale\" with Cheese.\nRoyale with Cheese.\nThat's right.";
        String right = "What do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right!";
        String merged = "What do they call it?\nNah, they got the metric system.1\nNah, they got the metric system.2\nNah, they got the metric system.3\nThey call it a \"Royale\" with Cheese.\nRoyale with Cheese.\nThat's right!";
        this.assertNonConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system.1\nNah, they got the metric system.2\nNah, they got the metric system.3\nThey call it a \"Royale\" with Cheese.\nRoyale with Cheese.\nThat's right.", "What do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right!");
        this.assertMergedBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system.1\nNah, they got the metric system.2\nNah, they got the metric system.3\nThey call it a \"Royale\" with Cheese.\nRoyale with Cheese.\nThat's right.", "What do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right!", "What do they call it?\nNah, they got the metric system.1\nNah, they got the metric system.2\nNah, they got the metric system.3\nThey call it a \"Royale\" with Cheese.\nRoyale with Cheese.\nThat's right!");
    }

    @Test
    public void addDifferentLineAtDifferentLineInMultiLineText() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String right = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?";
        String merged = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?";
        this.assertNonConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?");
        this.assertMergedBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?");
    }

    @Test
    public void addSameLineAtSameLineOnBothSidesInMultiLineText() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right!!!";
        String right = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String merged = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right!!!";
        this.assertNonConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right!!!", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.");
        this.assertMergedBidirectional("They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right!!!", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right!!!");
    }

    @Test
    public void changeSameLineToSameContentOnBothSidesInMultiLineText() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese!!!\nRoyale with Cheese.\nThat's right!!!\nThey call it a Royale with Cheese!!!";
        String right = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese!!!\nRoyale with Cheese.\nThat's right.";
        String merged = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese!!!\nRoyale with Cheese.\nThat's right!!!\nThey call it a Royale with Cheese!!!";
        this.assertNonConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese!!!\nRoyale with Cheese.\nThat's right!!!\nThey call it a Royale with Cheese!!!", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese!!!\nRoyale with Cheese.\nThat's right.");
        this.assertMergedBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese!!!\nRoyale with Cheese.\nThat's right!!!\nThey call it a Royale with Cheese!!!", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese!!!\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese!!!\nRoyale with Cheese.\nThat's right!!!\nThey call it a Royale with Cheese!!!");
    }

    @Test
    public void removeAndChangeVersusSameChangeInMultiLineText() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right!";
        String right = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right!";
        String merged = "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right!";
        this.assertNonConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right!", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right!");
        this.assertMergedBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right!", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right!", "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right!");
    }

    @Test
    public void removeSameLineOnBothSidesInMultiLineText() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right!!!";
        String right = "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right.";
        String merged = "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right!!!";
        this.assertNonConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right!!!", "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right.");
        this.assertMergedBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right!!!", "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right!!!");
    }

    @Test
    public void removeLineAndAddLineAtSameLineInMultiLineText() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String right = "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?";
        String merged = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?";
        this.assertNonConflictingBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?");
        this.assertMergedBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?");
    }

    private void assertNonConflictingBidirectional(String origin, String left, String right) {
        this.assertNonConflicting(origin, left, right);
        this.assertNonConflicting(origin, right, left);
    }

    private void assertNonConflicting(String origin, String left, String right) {
        ThreeWayTextDiff diff = new ThreeWayTextDiff(origin, left, right);
        Assert.assertFalse((boolean)diff.isConflicting());
    }

    private void assertConflictingBidirectional(String origin, String left, String right) {
        this.assertConflicting(origin, left, right);
        this.assertConflicting(origin, right, left);
    }

    private void assertConflicting(String origin, String left, String right) {
        ThreeWayTextDiff diff = new ThreeWayTextDiff(origin, left, right);
        Assert.assertTrue((boolean)diff.isConflicting());
    }

    private void assertMergedBidirectional(String origin, String left, String right, String merged) {
        this.assertMerged(origin, left, right, merged);
        this.assertMerged(origin, right, left, merged);
    }

    private void assertMerged(String origin, String left, String right, String merged) {
        ThreeWayTextDiff diff = new ThreeWayTextDiff(origin, left, right);
        Assert.assertEquals((Object)merged, (Object)diff.getMerged());
    }
}

