/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.multiplicitychanges;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ide.ui.tests.framework.ResolutionStrategyID;
import org.eclipse.emf.compare.ide.ui.tests.framework.RuntimeTestRunner;
import org.eclipse.emf.compare.ide.ui.tests.framework.annotations.Compare;
import org.eclipse.emf.compare.ide.ui.tests.framework.annotations.ResolutionStrategies;
import org.eclipse.emf.compare.uml2.internal.MultiplicityElementChange;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.UMLPackage;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=RuntimeTestRunner.class)
@ResolutionStrategies(value={ResolutionStrategyID.PROJECT})
public class MultiplicityElementChangesTest {
    private static final Predicate<Diff> IS_MULTIPLICITY_CHANGE = new Predicate<Diff>(){

        public boolean apply(Diff diff) {
            return diff instanceof MultiplicityElementChange;
        }
    };
    private static final Predicate<Diff> IS_LOWER_VALUE_REFERENCE_CHANGE = new Predicate<Diff>(){

        public boolean apply(Diff diff) {
            if (!(diff instanceof ReferenceChange)) {
                return false;
            }
            ReferenceChange refChange = (ReferenceChange)diff;
            return refChange.getReference() == UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue();
        }
    };
    private static final Predicate<Diff> IS_LOWER_VALUE_ATTRIBUTE_CHANGE = new Predicate<Diff>(){

        public boolean apply(Diff diff) {
            if (!(diff instanceof AttributeChange)) {
                return false;
            }
            EObject container = MatchUtil.getContainer((Comparison)diff.getMatch().getComparison(), (Diff)diff);
            if (container instanceof LiteralInteger || container instanceof LiteralUnlimitedNatural) {
                EStructuralFeature eContainingFeature = container.eContainingFeature();
                return eContainingFeature == UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue();
            }
            return false;
        }
    };
    private static final Predicate<Diff> IS_UPPER_VALUE_REFERENCE_CHANGE = new Predicate<Diff>(){

        public boolean apply(Diff diff) {
            if (!(diff instanceof ReferenceChange)) {
                return false;
            }
            ReferenceChange refChange = (ReferenceChange)diff;
            return refChange.getReference() == UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue();
        }
    };
    private static final Predicate<Diff> IS_UPPER_VALUE_ATTRIBUTE_CHANGE = new Predicate<Diff>(){

        public boolean apply(Diff diff) {
            if (!(diff instanceof AttributeChange)) {
                return false;
            }
            EObject container = MatchUtil.getContainer((Comparison)diff.getMatch().getComparison(), (Diff)diff);
            if (container instanceof LiteralInteger || container instanceof LiteralUnlimitedNatural) {
                EStructuralFeature eContainingFeature = container.eContainingFeature();
                return eContainingFeature == UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue();
            }
            return false;
        }
    };
    private static final Predicate<Diff> IS_UPPER_VALUE_CHANGE = new Predicate<Diff>(){

        public boolean apply(Diff diff) {
            return IS_UPPER_VALUE_REFERENCE_CHANGE.apply((Object)diff) || IS_UPPER_VALUE_ATTRIBUTE_CHANGE.apply((Object)diff);
        }
    };
    private static final Predicate<Diff> IS_LOWER_VALUE_CHANGE = new Predicate<Diff>(){

        public boolean apply(Diff diff) {
            return IS_LOWER_VALUE_REFERENCE_CHANGE.apply((Object)diff) || IS_LOWER_VALUE_ATTRIBUTE_CHANGE.apply((Object)diff);
        }
    };

    @Compare(left="a1/left.uml", right="a1/right.uml", ancestor="a1/origin.uml")
    public void testNonConflictingAddition(Comparison comparison) throws IOException {
        EList diffs = comparison.getDifferences();
        Iterable leftChanges = Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
        Iterable rightChanges = Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT)));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)leftChanges));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)rightChanges));
        MultiplicityElementChange leftChange = (MultiplicityElementChange)leftChanges.iterator().next();
        Assert.assertEquals((long)1L, (long)leftChange.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)leftChange) instanceof ReferenceChange));
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)leftChange.getKind());
        MultiplicityElementChange rightChange = (MultiplicityElementChange)rightChanges.iterator().next();
        Assert.assertEquals((long)1L, (long)rightChange.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)rightChange) instanceof ReferenceChange));
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)rightChange.getKind());
        Assert.assertEquals((long)0L, (long)comparison.getConflicts().size());
    }

    @Compare(left="a2/left.uml", right="a2/right.uml", ancestor="a2/origin.uml")
    public void testAdditionsWithPseudoconflict(Comparison comparison) throws IOException {
        EList diffs = comparison.getDifferences();
        ArrayList leftChanges = Lists.newArrayList((Iterable)Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT))));
        ArrayList rightChanges = Lists.newArrayList((Iterable)Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT))));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)leftChanges));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)rightChanges));
        MultiplicityElementChange leftChange = (MultiplicityElementChange)leftChanges.get(0);
        Assert.assertEquals((long)1L, (long)leftChange.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)leftChange) instanceof ReferenceChange));
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)leftChange.getKind());
        MultiplicityElementChange rightChange1 = (MultiplicityElementChange)rightChanges.get(0);
        Assert.assertEquals((long)1L, (long)rightChange1.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)rightChange1) instanceof ReferenceChange));
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)rightChange1.getKind());
        MultiplicityElementChange rightChange2 = (MultiplicityElementChange)rightChanges.get(1);
        Assert.assertEquals((long)1L, (long)rightChange2.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)rightChange2) instanceof ReferenceChange));
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)rightChange2.getKind());
        Assert.assertEquals((long)1L, (long)comparison.getConflicts().size());
        Conflict conflict = (Conflict)comparison.getConflicts().get(0);
        Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)conflict.getKind());
        Assert.assertTrue((boolean)conflict.getDifferences().contains((Object)this.getFirstRefiningDiff((Diff)leftChange)));
        if (this.isLowerValueChange(rightChange1)) {
            Assert.assertEquals((Object)conflict, (Object)this.getRefiningsConflict((Diff)rightChange1));
        } else {
            Assert.assertTrue((boolean)this.isLowerValueChange(rightChange2));
            Assert.assertEquals((Object)conflict, (Object)this.getRefiningsConflict((Diff)rightChange2));
        }
    }

    @Compare(left="a3/left.uml", right="a3/right.uml", ancestor="a3/origin.uml")
    public void testAdditionsWithConflict(Comparison comparison) throws IOException {
        EList diffs = comparison.getDifferences();
        ArrayList leftChanges = Lists.newArrayList((Iterable)Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT))));
        ArrayList rightChanges = Lists.newArrayList((Iterable)Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT))));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)leftChanges));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)rightChanges));
        MultiplicityElementChange leftChange = (MultiplicityElementChange)leftChanges.get(0);
        Assert.assertEquals((long)1L, (long)leftChange.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)leftChange) instanceof ReferenceChange));
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)leftChange.getKind());
        MultiplicityElementChange rightChange1 = (MultiplicityElementChange)rightChanges.get(0);
        Assert.assertEquals((long)1L, (long)rightChange1.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)rightChange1) instanceof ReferenceChange));
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)rightChange1.getKind());
        MultiplicityElementChange rightChange2 = (MultiplicityElementChange)rightChanges.get(1);
        Assert.assertEquals((long)1L, (long)rightChange2.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)rightChange2) instanceof ReferenceChange));
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)rightChange2.getKind());
        Assert.assertEquals((long)1L, (long)comparison.getConflicts().size());
        Conflict conflict = (Conflict)comparison.getConflicts().get(0);
        Assert.assertEquals((Object)ConflictKind.REAL, (Object)conflict.getKind());
        if (this.isLowerValueChange(rightChange1)) {
            Assert.assertEquals((Object)conflict, (Object)this.getRefiningsConflict((Diff)rightChange1));
        } else {
            Assert.assertTrue((boolean)this.isLowerValueChange(rightChange2));
            Assert.assertEquals((Object)conflict, (Object)this.getRefiningsConflict((Diff)rightChange2));
        }
    }

    @Compare(left="a4/left.uml", right="a4/right.uml", ancestor="a4/origin.uml")
    public void testChangesWithConflict(Comparison comparison) throws IOException {
        EList diffs = comparison.getDifferences();
        Iterable leftChanges = Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
        Iterable rightChanges = Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT)));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)leftChanges));
        MultiplicityElementChange leftChange = (MultiplicityElementChange)leftChanges.iterator().next();
        Assert.assertEquals((long)1L, (long)leftChange.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)leftChange) instanceof AttributeChange));
        Assert.assertEquals((Object)DifferenceKind.CHANGE, (Object)leftChange.getKind());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)rightChanges));
        MultiplicityElementChange rightChange = (MultiplicityElementChange)rightChanges.iterator().next();
        Assert.assertEquals((long)1L, (long)rightChange.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)rightChange) instanceof AttributeChange));
        Assert.assertEquals((Object)DifferenceKind.CHANGE, (Object)rightChange.getKind());
        Assert.assertEquals((long)1L, (long)comparison.getConflicts().size());
        Conflict conflict = (Conflict)comparison.getConflicts().get(0);
        Assert.assertEquals((Object)ConflictKind.REAL, (Object)conflict.getKind());
        Assert.assertEquals((Object)conflict, (Object)this.getRefiningsConflict((Diff)rightChange));
    }

    @Compare(left="a5/left.uml", right="a5/right.uml", ancestor="a5/origin.uml")
    public void testChangesWithPseudoconflict(Comparison comparison) throws IOException {
        EList diffs = comparison.getDifferences();
        Iterable leftChanges = Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
        Iterable rightChanges = Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT)));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)leftChanges));
        Diff leftChange = (Diff)leftChanges.iterator().next();
        Assert.assertEquals((long)1L, (long)leftChange.getRefinedBy().size());
        Assert.assertTrue((boolean)(leftChange.getRefinedBy().get(0) instanceof AttributeChange));
        Assert.assertEquals((Object)DifferenceKind.CHANGE, (Object)leftChange.getKind());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)rightChanges));
        Diff rightChange = (Diff)rightChanges.iterator().next();
        Assert.assertEquals((long)1L, (long)rightChange.getRefinedBy().size());
        Assert.assertTrue((boolean)(rightChange.getRefinedBy().get(0) instanceof AttributeChange));
        Assert.assertEquals((Object)DifferenceKind.CHANGE, (Object)rightChange.getKind());
        Assert.assertEquals((long)1L, (long)comparison.getConflicts().size());
        Conflict conflict = (Conflict)comparison.getConflicts().get(0);
        Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)conflict.getKind());
        Assert.assertEquals((Object)conflict, (Object)this.getRefiningsConflict(rightChange));
    }

    @Compare(left="a6/left.uml", right="a6/right.uml", ancestor="a6/origin.uml")
    public void testRemoveConflict(Comparison comparison) throws IOException {
        EList diffs = comparison.getDifferences();
        ArrayList leftChanges = Lists.newArrayList((Iterable)Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT))));
        ArrayList rightChanges = Lists.newArrayList((Iterable)Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT))));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)leftChanges));
        MultiplicityElementChange leftChange = (MultiplicityElementChange)leftChanges.iterator().next();
        Assert.assertEquals((long)1L, (long)leftChange.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)leftChange) instanceof AttributeChange));
        Assert.assertEquals((Object)DifferenceKind.CHANGE, (Object)leftChange.getKind());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)rightChanges));
        MultiplicityElementChange rightChange1 = (MultiplicityElementChange)rightChanges.get(0);
        Assert.assertEquals((long)1L, (long)rightChange1.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)rightChange1) instanceof ReferenceChange));
        Assert.assertEquals((Object)DifferenceKind.DELETE, (Object)rightChange1.getKind());
        MultiplicityElementChange rightChange2 = (MultiplicityElementChange)rightChanges.get(1);
        Assert.assertEquals((long)1L, (long)rightChange2.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)rightChange2) instanceof ReferenceChange));
        Assert.assertEquals((Object)DifferenceKind.DELETE, (Object)rightChange2.getKind());
        Assert.assertEquals((long)1L, (long)comparison.getConflicts().size());
        Conflict conflict = (Conflict)comparison.getConflicts().get(0);
        Assert.assertEquals((Object)ConflictKind.REAL, (Object)conflict.getKind());
        if (this.isLowerValueChange(rightChange1)) {
            Assert.assertTrue((boolean)this.isUpperValueChange(rightChange2));
            Assert.assertEquals((Object)conflict, (Object)this.getRefiningsConflict((Diff)rightChange1));
        } else {
            Assert.assertTrue((boolean)this.isUpperValueChange(rightChange1));
            Assert.assertTrue((boolean)this.isLowerValueChange(rightChange2));
            Assert.assertEquals((Object)conflict, (Object)this.getRefiningsConflict((Diff)rightChange2));
        }
    }

    @Compare(left="a7/left.uml", right="a7/right.uml", ancestor="a7/origin.uml")
    public void testRemoveNoConflict(Comparison comparison) throws IOException {
        EList diffs = comparison.getDifferences();
        Iterable leftChanges = Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
        Iterable rightChanges = Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT)));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)leftChanges));
        MultiplicityElementChange leftChange = (MultiplicityElementChange)leftChanges.iterator().next();
        Assert.assertEquals((long)1L, (long)leftChange.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)leftChange) instanceof ReferenceChange));
        Assert.assertEquals((Object)DifferenceKind.DELETE, (Object)leftChange.getKind());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)rightChanges));
        MultiplicityElementChange rightChange = (MultiplicityElementChange)rightChanges.iterator().next();
        Assert.assertEquals((long)1L, (long)rightChange.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)rightChange) instanceof AttributeChange));
        Assert.assertEquals((Object)DifferenceKind.CHANGE, (Object)rightChange.getKind());
        Assert.assertEquals((long)0L, (long)comparison.getConflicts().size());
    }

    @Compare(left="a8/left.uml", right="a8/right.uml", ancestor="a8/origin.uml")
    public void testRemovePseudoConflict(Comparison comparison) throws IOException {
        EList diffs = comparison.getDifferences();
        Iterable leftChanges = Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
        Iterable rightChanges = Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT)));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)leftChanges));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)rightChanges));
        MultiplicityElementChange leftChange = (MultiplicityElementChange)leftChanges.iterator().next();
        Assert.assertEquals((long)1L, (long)leftChange.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)leftChange) instanceof ReferenceChange));
        Assert.assertEquals((Object)DifferenceKind.DELETE, (Object)leftChange.getKind());
        MultiplicityElementChange rightChange = (MultiplicityElementChange)rightChanges.iterator().next();
        Assert.assertEquals((long)1L, (long)rightChange.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)rightChange) instanceof ReferenceChange));
        Assert.assertEquals((Object)DifferenceKind.DELETE, (Object)rightChange.getKind());
        Assert.assertEquals((long)1L, (long)comparison.getConflicts().size());
        Conflict conflict = (Conflict)comparison.getConflicts().get(0);
        Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)conflict.getKind());
    }

    @Compare(left="a9/left.uml", right="a9/right.uml", ancestor="a9/origin.uml")
    public void testRemoveAndAddNoConflict(Comparison comparison) throws IOException {
        EList diffs = comparison.getDifferences();
        Iterable leftChanges = Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
        Iterable rightChanges = Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT)));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)leftChanges));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)rightChanges));
        MultiplicityElementChange leftChange = (MultiplicityElementChange)leftChanges.iterator().next();
        Assert.assertEquals((long)1L, (long)leftChange.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)leftChange) instanceof ReferenceChange));
        Assert.assertEquals((Object)DifferenceKind.DELETE, (Object)leftChange.getKind());
        MultiplicityElementChange rightChange = (MultiplicityElementChange)rightChanges.iterator().next();
        Assert.assertEquals((long)1L, (long)rightChange.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)rightChange) instanceof ReferenceChange));
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)rightChange.getKind());
        Assert.assertEquals((long)0L, (long)comparison.getConflicts().size());
    }

    @Compare(left="a10/left.uml", right="a10/right.uml", ancestor="a10/origin.uml")
    public void testRealAndPseudoConflict(Comparison comparison) throws IOException {
        EList diffs = comparison.getDifferences();
        ArrayList leftChanges = Lists.newArrayList((Iterable)Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT))));
        ArrayList rightChanges = Lists.newArrayList((Iterable)Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT))));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)leftChanges));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)rightChanges));
        MultiplicityElementChange leftChange1 = (MultiplicityElementChange)leftChanges.get(0);
        Assert.assertEquals((long)1L, (long)leftChange1.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)leftChange1) instanceof ReferenceChange));
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)leftChange1.getKind());
        MultiplicityElementChange leftChange2 = (MultiplicityElementChange)leftChanges.get(1);
        Assert.assertEquals((long)1L, (long)leftChange2.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)leftChange2) instanceof ReferenceChange));
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)leftChange2.getKind());
        MultiplicityElementChange rightChange1 = (MultiplicityElementChange)rightChanges.get(0);
        Assert.assertEquals((long)1L, (long)rightChange1.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)rightChange1) instanceof ReferenceChange));
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)rightChange1.getKind());
        MultiplicityElementChange rightChange2 = (MultiplicityElementChange)rightChanges.get(1);
        Assert.assertEquals((long)1L, (long)rightChange2.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)rightChange2) instanceof ReferenceChange));
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)rightChange2.getKind());
        Assert.assertEquals((long)2L, (long)comparison.getConflicts().size());
        Conflict conflict1 = (Conflict)comparison.getConflicts().get(0);
        Conflict conflict2 = (Conflict)comparison.getConflicts().get(1);
        if (conflict1.getKind() == ConflictKind.PSEUDO) {
            Assert.assertEquals((Object)ConflictKind.REAL, (Object)conflict2.getKind());
        } else {
            Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)conflict2.getKind());
        }
        if (this.isUpperValueChange(leftChange1)) {
            Assert.assertTrue((boolean)this.isLowerValueChange(leftChange2));
            Assert.assertNotNull((Object)leftChange1.getConflict());
            Assert.assertEquals((Object)ConflictKind.REAL, (Object)leftChange1.getConflict().getKind());
            Assert.assertNotNull((Object)leftChange2.getConflict());
            Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)leftChange2.getConflict().getKind());
        } else {
            Assert.assertTrue((boolean)this.isLowerValueChange(leftChange1));
            Assert.assertTrue((boolean)this.isUpperValueChange(leftChange2));
            Assert.assertNotNull((Object)this.getRefiningsConflict((Diff)leftChange1));
            Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)this.getRefiningsConflict((Diff)leftChange1).getKind());
            Assert.assertNotNull((Object)this.getRefiningsConflict((Diff)leftChange2));
            Assert.assertEquals((Object)ConflictKind.REAL, (Object)this.getRefiningsConflict((Diff)leftChange2).getKind());
        }
        if (this.isUpperValueChange(rightChange1)) {
            Assert.assertTrue((boolean)this.isLowerValueChange(rightChange2));
            Assert.assertNotNull((Object)this.getRefiningsConflict((Diff)rightChange1));
            Assert.assertEquals((Object)ConflictKind.REAL, (Object)this.getRefiningsConflict((Diff)rightChange1).getKind());
            Assert.assertNotNull((Object)this.getRefiningsConflict((Diff)rightChange2));
            Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)this.getRefiningsConflict((Diff)rightChange2).getKind());
        } else {
            Assert.assertTrue((boolean)this.isLowerValueChange(rightChange1));
            Assert.assertTrue((boolean)this.isUpperValueChange(rightChange2));
            Assert.assertNotNull((Object)this.getRefiningsConflict((Diff)rightChange1));
            Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)this.getRefiningsConflict((Diff)rightChange1).getKind());
            Assert.assertNotNull((Object)this.getRefiningsConflict((Diff)rightChange2));
            Assert.assertEquals((Object)ConflictKind.REAL, (Object)this.getRefiningsConflict((Diff)rightChange2).getKind());
        }
    }

    private boolean isLowerValueChange(MultiplicityElementChange multiplicityElementChange) {
        if (multiplicityElementChange.getRefinedBy().size() != 1) {
            return false;
        }
        return IS_LOWER_VALUE_CHANGE.apply((Object)this.getFirstRefiningDiff((Diff)multiplicityElementChange));
    }

    private boolean isUpperValueChange(MultiplicityElementChange multiplicityElementChange) {
        if (multiplicityElementChange.getRefinedBy().size() != 1) {
            return false;
        }
        return IS_UPPER_VALUE_CHANGE.apply((Object)this.getFirstRefiningDiff((Diff)multiplicityElementChange));
    }

    @Compare(left="a11/left.uml", right="a11/right.uml", ancestor="a11/origin.uml")
    public void testRealAndPseudoConflictWithChangeAndDelete(Comparison comparison) throws IOException {
        EList diffs = comparison.getDifferences();
        ArrayList leftChanges = Lists.newArrayList((Iterable)Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT))));
        ArrayList rightChanges = Lists.newArrayList((Iterable)Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_MULTIPLICITY_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT))));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)leftChanges));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)rightChanges));
        MultiplicityElementChange leftAddChange = (MultiplicityElementChange)Iterables.find((Iterable)leftChanges, (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD));
        MultiplicityElementChange leftDeleteChange = (MultiplicityElementChange)Iterables.find((Iterable)leftChanges, (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE));
        Assert.assertEquals((long)1L, (long)leftAddChange.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)leftAddChange) instanceof ReferenceChange));
        Assert.assertEquals((long)1L, (long)leftDeleteChange.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)leftDeleteChange) instanceof ReferenceChange));
        MultiplicityElementChange rightAddChange = (MultiplicityElementChange)Iterables.find((Iterable)leftChanges, (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD));
        MultiplicityElementChange rightChange = (MultiplicityElementChange)Iterables.find((Iterable)rightChanges, (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE));
        Assert.assertEquals((long)1L, (long)rightAddChange.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)rightAddChange) instanceof ReferenceChange));
        Assert.assertEquals((long)1L, (long)rightChange.getRefinedBy().size());
        Assert.assertTrue((boolean)(this.getFirstRefiningDiff((Diff)rightChange) instanceof AttributeChange));
        Assert.assertEquals((long)2L, (long)comparison.getConflicts().size());
        Conflict conflict1 = (Conflict)comparison.getConflicts().get(0);
        Conflict conflict2 = (Conflict)comparison.getConflicts().get(1);
        if (conflict1.getKind() == ConflictKind.PSEUDO) {
            Assert.assertEquals((Object)ConflictKind.REAL, (Object)conflict2.getKind());
        } else {
            Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)conflict2.getKind());
        }
        Conflict leftChangeConflict = this.getRefiningsConflict((Diff)leftDeleteChange);
        Conflict rightChangeConflict = this.getRefiningsConflict((Diff)rightChange);
        Conflict leftAddConflict = this.getRefiningsConflict((Diff)leftAddChange);
        Conflict rightAddConflict = this.getRefiningsConflict((Diff)rightAddChange);
        Assert.assertEquals((Object)ConflictKind.REAL, (Object)leftChangeConflict.getKind());
        Assert.assertEquals((Object)leftChangeConflict, (Object)rightChangeConflict);
        Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)leftAddConflict.getKind());
        Assert.assertEquals((Object)leftAddConflict, (Object)rightAddConflict);
    }

    private Diff getFirstRefiningDiff(Diff change) {
        return (Diff)change.getRefinedBy().get(0);
    }

    private Conflict getRefiningsConflict(Diff change) {
        return this.getFirstRefiningDiff(change).getConflict();
    }
}

