/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.lang.reflect.Method;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDORevisionTuplizer;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.property.Setter;

public class CDOVirtualPropertySetter
implements Setter {
    private static final long serialVersionUID = 1L;
    private final boolean isResourceIdProperty;
    private final boolean isContainerIdProperty;
    private final boolean isContainingFeatureIdProperty;
    private final String propertyName;

    public CDOVirtualPropertySetter(CDORevisionTuplizer tuplizer, String propertyName) {
        this.isResourceIdProperty = propertyName.compareTo("resourceID") == 0;
        this.isContainerIdProperty = propertyName.compareTo("containerID") == 0;
        this.isContainingFeatureIdProperty = propertyName.compareTo("containingFeatureID") == 0;
        this.propertyName = propertyName;
        if (!(this.isResourceIdProperty || this.isContainerIdProperty || this.isContainingFeatureIdProperty)) {
            throw new IllegalArgumentException("Propertyname " + propertyName + " not supported must be one of resourceID, containerID, containingFeatureID");
        }
    }

    public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
        InternalCDORevision revision = (InternalCDORevision)target;
        if (this.isResourceIdProperty) {
            revision.setResourceID((CDOID)value);
            return;
        }
        if (this.isContainerIdProperty) {
            revision.setContainerID((CDOID)value);
            return;
        }
        if (this.isContainingFeatureIdProperty) {
            revision.setContainingFeatureID(((Integer)value).intValue());
            return;
        }
        throw new IllegalArgumentException("Propertyname " + this.propertyName + " not supported must be one of resourceID, containerID, containingFeatureID");
    }

    public Method getMethod() {
        return null;
    }

    public String getMethodName() {
        return null;
    }
}

