/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.CDOAudit;
import org.eclipse.emf.cdo.common.CDOProtocolView;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.emf.internal.cdo.CDORevisionManagerImpl;
import org.eclipse.emf.internal.cdo.CDOSessionImpl;
import org.eclipse.emf.internal.cdo.CDOViewImpl;

public class CDOAuditImpl
extends CDOViewImpl
implements CDOAudit {
    private long timeStamp;

    public CDOAuditImpl(int id, CDOSessionImpl session, long timeStamp) {
        super(id, session);
        this.timeStamp = timeStamp;
    }

    public CDOProtocolView.Type getViewType() {
        return CDOProtocolView.Type.AUDIT;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public InternalCDORevision getRevision(CDOID id, boolean loadOnDemand) {
        CDOSessionImpl session = this.getSession();
        CDORevisionManagerImpl revisionManager = session.getRevisionManager();
        return (InternalCDORevision)revisionManager.getRevisionByTime(id, session.getReferenceChunkSize(), this.timeStamp, loadOnDemand);
    }

    public String toString() {
        return MessageFormat.format("CDOAudit({0})", this.getViewID());
    }
}

