/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.bundle;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.internal.db.DBAdapterDescriptor;
import org.eclipse.net4j.internal.db.DBAdapterRegistry;
import org.eclipse.net4j.util.om.OMBundle;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.OSGiActivator;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.OMTracer;
import org.osgi.framework.BundleContext;

public abstract class OM {
    public static final String BUNDLE_ID = "org.eclipse.net4j.db";
    public static final OMBundle BUNDLE = OMPlatform.INSTANCE.bundle("org.eclipse.net4j.db", OM.class);
    public static final OMTracer DEBUG = BUNDLE.tracer("debug");
    public static final OMTracer DEBUG_SQL = DEBUG.tracer("sql");
    public static final OMLogger LOG = BUNDLE.logger();
    public static final String EXT_POINT = "dbAdapters";

    public static final class Activator
    extends OSGiActivator {
        public Activator() {
            super(BUNDLE);
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            this.initDBAdapterRegistry();
        }

        private void initDBAdapterRegistry() {
            IConfigurationElement[] elements;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(OM.BUNDLE_ID, OM.EXT_POINT);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                final IConfigurationElement element = iConfigurationElementArray[n2];
                if ("dbAdapter".equals(element.getName())) {
                    DBAdapterDescriptor descriptor = new DBAdapterDescriptor(element.getAttribute("name")){

                        public IDBAdapter createDBAdapter() {
                            try {
                                return (IDBAdapter)element.createExecutableExtension("class");
                            }
                            catch (CoreException ex) {
                                LOG.error((Throwable)ex);
                                return null;
                            }
                        }
                    };
                    DBAdapterRegistry.INSTANCE.addDescriptor(descriptor);
                }
                ++n2;
            }
        }
    }
}

