/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.jms;

import java.util.Date;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageProducer;
import org.eclipse.net4j.internal.jms.DestinationImpl;
import org.eclipse.net4j.internal.jms.JMSTemporaryDestination;
import org.eclipse.net4j.internal.jms.NotYetImplementedException;
import org.eclipse.net4j.internal.jms.SessionImpl;
import org.eclipse.net4j.internal.jms.messages.Messages;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public class MessageProducerImpl
extends Lifecycle
implements MessageProducer {
    private SessionImpl session;
    private DestinationImpl destination;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private boolean disableMessageTimestamp = false;
    private boolean disableMessageID = false;

    public MessageProducerImpl(SessionImpl session, DestinationImpl destination) {
        this.session = session;
        this.destination = destination;
    }

    public SessionImpl getSession() {
        return this.session;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public DestinationImpl getDestination() {
        return this.destination;
    }

    public boolean getDisableMessageID() {
        return this.disableMessageID;
    }

    public void setDisableMessageID(boolean disableMessageID) {
        this.disableMessageID = disableMessageID;
    }

    public boolean getDisableMessageTimestamp() {
        return this.disableMessageTimestamp;
    }

    public void setDisableMessageTimestamp(boolean disableMessageTimestamp) {
        this.disableMessageTimestamp = disableMessageTimestamp;
    }

    public void send(Message message) throws JMSException {
        this.send(this.getDestination(), message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(this.getDestination(), message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (message == null) {
            throw new MessageFormatException(Messages.getString("MessageProducerImpl_0"));
        }
        message.setJMSDestination(destination);
        message.setJMSTimestamp(new Date().getTime());
        message.setJMSPriority(priority);
        if (timeToLive > 0L) {
            message.setJMSExpiration(System.currentTimeMillis() + timeToLive);
        } else {
            message.setJMSExpiration(0L);
        }
        if (destination instanceof JMSTemporaryDestination) {
            message.setJMSDeliveryMode(1);
        } else {
            message.setJMSDeliveryMode(deliveryMode);
        }
        this.session.sendMessage(message);
    }

    public void close() {
        throw new NotYetImplementedException();
    }
}

