/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.core.impl;

import java.util.Arrays;
import org.eclipse.net4j.core.AuthenticationManager;
import org.eclipse.net4j.core.Connector;
import org.eclipse.net4j.core.NegotiationException;
import org.eclipse.net4j.core.Randomizer;
import org.eclipse.net4j.core.impl.AbstractChallengeNegotiator;
import org.eclipse.net4j.spring.ValidationException;

public class ServerChallengeNegotiatorImpl
extends AbstractChallengeNegotiator {
    public static final int DEFAULT_TOKEN_LENGTH = 128;
    private Randomizer randomizer;
    private AuthenticationManager authenticationManager;
    private int tokenLength = 128;

    public Randomizer getRandomizer() {
        return this.randomizer;
    }

    public void setRandomizer(Randomizer randomizer) {
        this.doSet("randomizer", randomizer);
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.doSet("authenticationManager", authenticationManager);
    }

    public int getTokenLength() {
        return this.tokenLength;
    }

    public void setTokenLength(int tokenLength) {
        this.doSet("tokenLength", tokenLength);
    }

    public void negotiate(Connector connector) throws NegotiationException {
        String login;
        char[] passwd;
        if (this.isDebugEnabled()) {
            this.debug("Transmitting token");
        }
        byte[] token = this.createRandomToken();
        connector.transmitNegotiation(token);
        if (this.isDebugEnabled()) {
            this.debug("Waiting for cryptedToken...");
        }
        byte[] cryptedToken = connector.receiveNegotiation();
        if (this.isDebugEnabled()) {
            this.debug("Received cryptedToken");
        }
        if (this.isDebugEnabled()) {
            this.debug("Waiting for userName...");
        }
        byte[] loginBytes = connector.receiveNegotiation();
        if (this.isDebugEnabled()) {
            this.debug("Received userName");
        }
        if (!this.verifyToken(cryptedToken, token, passwd = this.authenticationManager.getPassword(login = new String(loginBytes)))) {
            if (this.isDebugEnabled()) {
                this.debug("Transmitting failure");
            }
            connector.transmitNegotiation(NEGOTIATION_FAILURE);
            throw new NegotiationException("User " + login + " could not be authenticated");
        }
        if (this.isDebugEnabled()) {
            this.debug("Transmitting success");
        }
        connector.transmitNegotiation(NEGOTIATION_SUCCESS);
        connector.setUserName(login);
    }

    protected boolean verifyToken(byte[] cryptedToken, byte[] token, char[] passwd) {
        if (passwd == null) {
            return false;
        }
        try {
            byte[] locallyCryptedToken = this.encrypt(token, passwd);
            return Arrays.equals(cryptedToken, locallyCryptedToken);
        }
        catch (Exception ex) {
            this.warn("Token could not be encrypted", ex);
            return false;
        }
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("randomizer");
        this.assertNotNull("authenticationManager");
        if (this.tokenLength <= 0) {
            throw new ValidationException("tokenLength must be positive");
        }
    }

    protected void deactivate() throws Exception {
        this.authenticationManager = null;
        this.randomizer = null;
        super.deactivate();
    }

    protected byte[] createRandomToken() {
        byte[] token = new byte[this.tokenLength];
        this.randomizer.nextBytes(token);
        return token;
    }
}

