/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.ui.source;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.mint.internal.ui.MintUI;
import org.eclipse.emf.mint.internal.ui.source.CustomizeGeneratedMethodOperation;
import org.eclipse.emf.mint.internal.ui.source.GeneratedMethodPropertyTester;
import org.eclipse.emf.mint.internal.ui.source.Messages;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;

public class CustomizeGeneratedMethodHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            this.run((IStructuredSelection)selection, HandlerUtil.getActiveShell((ExecutionEvent)event));
        } else if (selection instanceof ITextSelection) {
            this.run((ITextSelection)selection, HandlerUtil.getActiveEditorChecked((ExecutionEvent)event));
        }
        return null;
    }

    private void run(IStructuredSelection selection, Shell shell) {
        IMethod[] methods = new IMethod[selection.size()];
        selection.toList().toArray(methods);
        this.run(methods, shell);
    }

    private void run(ITextSelection selection, IEditorPart targetPart) {
        IJavaElement element;
        IEditorInput editorInput = targetPart.getEditorInput();
        Shell shell = targetPart.getSite().getShell();
        IJavaElement je = JavaUI.getEditorInputJavaElement((IEditorInput)editorInput);
        try {
            element = this.getElementAtOffset(je, selection);
        }
        catch (JavaModelException e) {
            Status status = new Status(4, "org.eclipse.emf.mint.ui", 0, Messages.CustomizeGeneratedMethodAction_ErrorFindElement, (Throwable)e);
            MintUI.getDefault().getLog().log((IStatus)status);
            ErrorDialog.openError((Shell)shell, (String)Messages.CustomizeGeneratedMethodAction_ActionError, null, (IStatus)status);
            return;
        }
        if (!(element instanceof IMethod) || !GeneratedMethodPropertyTester.isCustomizableMethod((IMethod)element)) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.CustomizeGeneratedMethodAction_ActionError, (String)Messages.CustomizeGeneratedMethodAction_ErrorNotApplicable);
            return;
        }
        IMethod[] methods = new IMethod[]{(IMethod)element};
        this.run(methods, shell);
    }

    private void run(IMethod[] methods, Shell shell) {
        try {
            final CustomizeGeneratedMethodOperation op = new CustomizeGeneratedMethodOperation(methods);
            IProgressService svc = MintUI.getDefault().getWorkbench().getProgressService();
            svc.runInUI((IRunnableContext)svc, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        JavaCore.run((IWorkspaceRunnable)op, (IProgressMonitor)monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            }, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException e) {
            String msg = Messages.CustomizeGeneratedMethodAction_ErrorPerformAction;
            Status status = new Status(4, "org.eclipse.emf.mint.ui", 0, msg, (Throwable)e);
            MintUI.getDefault().getLog().log((IStatus)status);
            if (e.getCause() instanceof CoreException) {
                status = ((CoreException)e.getCause()).getStatus();
            } else {
                msg = null;
            }
            ErrorDialog.openError((Shell)shell, (String)Messages.CustomizeGeneratedMethodAction_ActionError, (String)msg, (IStatus)status);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IJavaElement getElementAtOffset(IJavaElement input, ITextSelection selection) throws JavaModelException {
        IJavaElement ref = null;
        if (input instanceof ICompilationUnit) {
            ICompilationUnit cunit = (ICompilationUnit)input;
            cunit.reconcile(0, false, null, null);
            ref = cunit.getElementAt(selection.getOffset());
            if (ref == null) {
                ref = input;
            }
        } else if (input instanceof IClassFile && (ref = ((IClassFile)input).getElementAt(selection.getOffset())) == null) {
            ref = input;
        }
        return ref;
    }
}

