/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.genmodel.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.search.core.results.IModelResultEntry;
import org.eclipse.emf.search.genmodel.ui.Activator;
import org.eclipse.emf.search.ui.actions.AbstractModelSearchPageAction;
import org.eclipse.emf.search.utils.ModelSearchImagesUtil;
import org.osgi.framework.Bundle;

public abstract class AbstractGenerateCodeAction
extends AbstractModelSearchPageAction {
    public AbstractGenerateCodeAction(String label) {
        super(label, ModelSearchImagesUtil.getImageDescriptor((Bundle)Activator.getDefault().getBundle(), (String)"icons/full/obj16/jcu_obj.gif"));
    }

    public boolean isEnabled() {
        Object target;
        Object o = this.getModelSearchResultPageSelection();
        return o instanceof IModelResultEntry && (target = ((IModelResultEntry)o).getSource()) instanceof GenBase;
    }

    public void run() {
        Object source;
        Object o = this.getModelSearchResultPageSelection();
        if (o instanceof IModelResultEntry && (source = ((IModelResultEntry)o).getSource()) instanceof GenBase) {
            this.handleGenBaseElement((GenBase)source, this.getTargetProjectTypes());
        }
    }

    protected abstract String[] getTargetProjectTypes();

    private String getTargetProjectGenTaskLabel(String type) {
        if ("org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject".equals(type)) {
            return "Generate Model Code";
        }
        if ("org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject".equals(type)) {
            return "Generate Edit Code";
        }
        if ("org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject".equals(type)) {
            return "Generate Editor Code";
        }
        if ("org.eclipse.emf.codegen.ecore.genmodel.generator.TestsProject".equals(type)) {
            return "Generate Tests Code";
        }
        return "";
    }

    private void handleGenBaseElement(GenBase genBase, String[] projectTypes) {
        new CodeGenJob(genBase, projectTypes).schedule();
    }

    private class CodeGenJob
    extends Job {
        private GenBase genElem;
        private String[] pTypes;

        public CodeGenJob(GenBase genBase, String[] projectTypes) {
            super("EMF Search GenModel Generator");
            this.genElem = genBase;
            this.pTypes = projectTypes;
        }

        public IStatus run(IProgressMonitor monitor) {
            this.genElem.getGenModel().setCanGenerate(true);
            monitor.beginTask("Generate Projects ...", this.pTypes.length);
            Generator generator = new Generator();
            generator.setInput((Object)this.genElem.getGenModel());
            String[] stringArray = this.pTypes;
            int n = this.pTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String projectType = stringArray[n2];
                monitor.setTaskName(AbstractGenerateCodeAction.this.getTargetProjectGenTaskLabel(projectType));
                generator.generate((Object)this.genElem, (Object)projectType, BasicMonitor.toMonitor((IProgressMonitor)monitor));
                monitor.worked(1);
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }
}

