/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.graphics;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.ScaledGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.internal.mapmode.DiagramMapModeUtil;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class MapModeGraphics
extends ScaledGraphics {
    private IMapMode mm;

    public MapModeGraphics(Graphics g, IMapMode mm) {
        super(g);
        this.setScale(DiagramMapModeUtil.getScale(mm));
        this.mm = mm;
    }

    public IMapMode getMapMode() {
        return this.mm;
    }

    @Override
    public void drawImage(Image srcImage, int x, int y) {
        Rectangle size = srcImage.getBounds();
        this.drawImage(srcImage, 0, 0, size.width, size.height, x, y, this.getMapMode().DPtoLP(size.width), this.getMapMode().DPtoLP(size.height));
    }

    @Override
    public void scale(double amount) {
        this.getGraphics().scale(amount);
    }

    @Override
    int zoomFontHeight(int height) {
        return height;
    }

    @Override
    Point zoomTextPoint(int x, int y) {
        return this.zoomRect(x, y, 0, 0).getTopLeft();
    }

    @Override
    Font zoomFont(Font f) {
        if (f == null) {
            f = Display.getCurrent().getSystemFont();
        }
        return f;
    }
}

