/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.ui.dashboard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.internal.bridge.ui.dashboard.ActionContainer;
import org.eclipse.gmf.internal.bridge.ui.dashboard.Messages;
import org.eclipse.gmf.internal.bridge.ui.dashboard.SeparatorFigure;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;

public class ModelFigure
extends RectangleFigure
implements ActionContainer {
    private IFigure labelsPlate;
    private IFigure actionsPlate;
    private IFigure stdActionsPlate;
    private List<SeparatorFigure> separators = new ArrayList<SeparatorFigure>();

    public ModelFigure() {
        ToolbarLayout layout = new ToolbarLayout();
        layout.setMinorAlignment(0);
        this.setLayoutManager((LayoutManager)layout);
        this.labelsPlate = new Figure();
        ToolbarLayout labelsLayout = new ToolbarLayout();
        this.labelsPlate.setLayoutManager((LayoutManager)labelsLayout);
        this.add(this.labelsPlate);
        SeparatorFigure s1 = new SeparatorFigure();
        this.separators.add(s1);
        this.add((IFigure)s1);
        this.actionsPlate = new Figure();
        ToolbarLayout actionsLayout = new ToolbarLayout();
        actionsLayout.setStretchMinorAxis(false);
        this.actionsPlate.setLayoutManager((LayoutManager)actionsLayout);
        this.add(this.actionsPlate);
        this.stdActionsPlate = new Figure();
        ToolbarLayout stdActionsLayout = new ToolbarLayout(true);
        stdActionsLayout.setSpacing(2);
        this.stdActionsPlate.setLayoutManager((LayoutManager)stdActionsLayout);
        this.actionsPlate.add(this.stdActionsPlate);
        Label descriptionFigure = new Label();
        descriptionFigure.setFont(JFaceResources.getBannerFont());
        this.addLabel((IFigure)descriptionFigure);
        Label nameFigure = new Label();
        this.addLabel((IFigure)nameFigure);
        this.setName(null);
    }

    public void setSpacing(int spacing) {
        this.setBorder((Border)new MarginBorder(spacing, 0, spacing, 0));
        for (SeparatorFigure separator : this.separators) {
            separator.setPreferredSize(new Dimension(0, spacing + separator.getLineWidth()));
        }
        this.labelsPlate.setBorder((Border)new MarginBorder(0, spacing, 0, spacing));
        this.actionsPlate.setBorder((Border)new MarginBorder(0, spacing, 0, spacing));
    }

    public void addLabel(IFigure labelFigure) {
        this.labelsPlate.add(labelFigure);
    }

    public void removeLabel(IFigure labelFigure) {
        this.labelsPlate.remove(labelFigure);
    }

    public final void addAction(IFigure actionFigure) {
        this.addAction(actionFigure, true);
    }

    public void addAction(IFigure actionFigure, boolean std) {
        Label bullet = new Label();
        if (std) {
            if (!this.stdActionsPlate.getChildren().isEmpty()) {
                bullet.setText("/");
            }
            this.stdActionsPlate.add((IFigure)bullet);
            this.stdActionsPlate.add(actionFigure);
        } else {
            Figure plate = new Figure();
            ToolbarLayout layout = new ToolbarLayout(true);
            layout.setSpacing(3);
            plate.setLayoutManager((LayoutManager)layout);
            plate.add((IFigure)bullet);
            plate.add(actionFigure);
            this.actionsPlate.add((IFigure)plate);
        }
    }

    public void removeAction(IFigure actionFigure, boolean std) {
        if (std) {
            int ix = this.stdActionsPlate.getChildren().indexOf(actionFigure);
            IFigure bullet = (IFigure)this.stdActionsPlate.getChildren().get(ix);
            this.stdActionsPlate.remove(actionFigure);
            this.stdActionsPlate.remove(bullet);
        } else {
            this.actionsPlate.remove(actionFigure.getParent());
        }
    }

    protected Label getLabel(int i) {
        return (Label)this.labelsPlate.getChildren().get(i);
    }

    public String getDescription() {
        return this.getLabel(0).getText();
    }

    public void setDescription(String description) {
        this.getLabel(0).setText(description);
    }

    public void setIcon(Image icon) {
        this.getLabel(0).setIcon(icon);
    }

    public void setName(String name) {
        if (name == null || name.trim().length() == 0) {
            name = Messages.ModelFigure_NoName;
        }
        this.getLabel(1).setText(name);
    }

    public void setFullName(String name) {
        if (name == null || name.trim().length() == 0) {
            this.setToolTip(null);
        } else {
            Label tooltip = new Label(name);
            this.setToolTip((IFigure)tooltip);
        }
    }
}

