/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.part;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gmf.ecore.navigator.EcoreNavigatorItem;
import org.eclipse.gmf.ecore.part.EcoreDiagramEditorPlugin;
import org.eclipse.gmf.ecore.part.EcoreDocumentProvider;
import org.eclipse.gmf.ecore.part.EcorePaletteFactory;
import org.eclipse.gmf.runtime.common.ui.services.marker.MarkerNavigationService;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramDropTargetListener;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditorInput;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.StorageDiagramDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;

public class EcoreDiagramEditor
extends DiagramDocumentEditor
implements IGotoMarker {
    public static final String ID = "org.eclipse.gmf.ecore.part.EcoreDiagramEditorID";
    private String contentObjectURI;

    public EcoreDiagramEditor() {
        super(true);
    }

    protected String getEditingDomainID() {
        return "org.eclipse.gmf.ecore.editor.EditingDomain";
    }

    protected TransactionalEditingDomain createEditingDomain() {
        TransactionalEditingDomain domain = super.createEditingDomain();
        domain.setID(this.getEditingDomainID());
        final NotificationFilter diagramResourceModifiedFilter = NotificationFilter.createNotifierFilter((Object)domain.getResourceSet()).and(NotificationFilter.createEventTypeFilter((int)3)).and(NotificationFilter.createFeatureFilter(ResourceSet.class, (int)0));
        domain.getResourceSet().eAdapters().add((Object)new Adapter(){
            private Notifier myTarger;

            public Notifier getTarget() {
                return this.myTarger;
            }

            public boolean isAdapterForType(Object type) {
                return false;
            }

            public void notifyChanged(Notification notification) {
                Object value;
                if (diagramResourceModifiedFilter.matches(notification) && (value = notification.getNewValue()) instanceof Resource) {
                    ((Resource)value).setTrackingModification(true);
                }
            }

            public void setTarget(Notifier newTarget) {
                this.myTarger = newTarget;
            }
        });
        return domain;
    }

    protected PaletteRoot createPaletteRoot(PaletteRoot existingPaletteRoot) {
        PaletteRoot root = super.createPaletteRoot(existingPaletteRoot);
        new EcorePaletteFactory().fillPalette(root);
        return root;
    }

    protected PreferencesHint getPreferencesHint() {
        return EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
    }

    public String getContributorId() {
        return "org.eclipse.gmf.ecore.editor";
    }

    protected void setDocumentProvider(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            this.setDocumentProvider((IDocumentProvider)new EcoreDocumentProvider(this.contentObjectURI));
        } else {
            this.setDocumentProvider((IDocumentProvider)new StorageDiagramDocumentProvider());
        }
    }

    public void doSetInput(IEditorInput input, boolean releaseEditorContents) throws CoreException {
        this.contentObjectURI = null;
        if (input instanceof IDiagramEditorInput) {
            Diagram diagram = ((IDiagramEditorInput)input).getDiagram();
            IFile diagramFile = WorkspaceSynchronizer.getFile((Resource)diagram.eResource());
            FileEditorInput newInput = new FileEditorInput(diagramFile);
            this.contentObjectURI = diagram.eResource().getURIFragment((EObject)diagram);
            super.doSetInput((IEditorInput)newInput, releaseEditorContents);
        } else {
            super.doSetInput(input, releaseEditorContents);
        }
    }

    public void gotoMarker(IMarker marker) {
        MarkerNavigationService.getInstance().gotoMarker((IEditorPart)this, marker);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        this.performSaveAs((IProgressMonitor)new NullProgressMonitor());
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        IFile original;
        Shell shell = this.getSite().getShell();
        IEditorInput input = this.getEditorInput();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
        if (original != null) {
            dialog.setOriginalFile(original);
        }
        dialog.create();
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return;
        }
        if (provider.isDeleted((Object)input) && original != null) {
            String message = NLS.bind((String)"The original file ''{0}'' has been deleted.", (Object)original.getName());
            dialog.setErrorMessage(null);
            dialog.setMessage(message, 2);
        }
        if (dialog.open() == 1) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return;
        }
        IPath filePath = dialog.getResult();
        if (filePath == null) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = workspaceRoot.getFile(filePath);
        FileEditorInput newInput = new FileEditorInput(file);
        IEditorMatchingStrategy matchingStrategy = this.getEditorDescriptor().getEditorMatchingStrategy();
        IEditorReference[] editorRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            if (matchingStrategy.matches(editorRefs[i], (IEditorInput)newInput)) {
                MessageDialog.openWarning((Shell)shell, (String)"Problem During Save As...", (String)"Save could not be completed. Target file is already open in another editor.");
                return;
            }
            ++i;
        }
        boolean success = false;
        try {
            try {
                provider.aboutToChange((Object)newInput);
                this.getDocumentProvider((IEditorInput)newInput).saveDocument(progressMonitor, (Object)newInput, this.getDocumentProvider().getDocument((Object)this.getEditorInput()), true);
                success = true;
            }
            catch (CoreException x) {
                IStatus status = x.getStatus();
                if (status == null || status.getSeverity() != 8) {
                    ErrorDialog.openError((Shell)shell, (String)"Save Problems", (String)"Could not save file.", (IStatus)x.getStatus());
                }
            }
        }
        finally {
            provider.changed((Object)newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.getDiagramGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new DropTargetListener((EditPartViewer)this.getDiagramGraphicalViewer(), (Transfer)LocalSelectionTransfer.getTransfer()){

            protected Object getJavaObject(TransferData data) {
                return LocalSelectionTransfer.getTransfer().nativeToJava(data);
            }
        });
        this.getDiagramGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new DropTargetListener((EditPartViewer)this.getDiagramGraphicalViewer(), (Transfer)LocalTransfer.getInstance()){

            protected Object getJavaObject(TransferData data) {
                return LocalTransfer.getInstance().nativeToJava(data);
            }
        });
    }

    private abstract class DropTargetListener
    extends DiagramDropTargetListener {
        public DropTargetListener(EditPartViewer viewer, Transfer xfer) {
            super(viewer, xfer);
        }

        protected List getObjectsBeingDropped() {
            TransferData data = this.getCurrentEvent().currentDataType;
            HashSet<URI> uris = new HashSet<URI>();
            Object transferedObject = this.getJavaObject(data);
            if (transferedObject instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)transferedObject;
                for (Object nextSelectedObject : selection) {
                    if (nextSelectedObject instanceof EcoreNavigatorItem) {
                        View view = ((EcoreNavigatorItem)nextSelectedObject).getView();
                        nextSelectedObject = view.getElement();
                    }
                    if (!(nextSelectedObject instanceof EObject)) continue;
                    EObject modelElement = (EObject)nextSelectedObject;
                    Resource modelElementResource = modelElement.eResource();
                    uris.add(modelElementResource.getURI().appendFragment(modelElementResource.getURIFragment(modelElement)));
                }
            }
            ArrayList<EObject> result = new ArrayList<EObject>();
            for (URI nextURI : uris) {
                EObject modelObject = EcoreDiagramEditor.this.getEditingDomain().getResourceSet().getEObject(nextURI, true);
                result.add(modelObject);
            }
            return result;
        }

        protected abstract Object getJavaObject(TransferData var1);
    }
}

