/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.properties.extended;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ExtendedComboBoxCellEditor
extends CellEditor {
    private final String[] items;
    private int selection;
    private CCombo comboBox;
    protected List list;
    private final String emptyItem;

    public static String[] createItems(List list, ILabelProvider labelProvider) {
        String[] result;
        if (list != null && list.size() > 0) {
            result = new String[list.size()];
            int i = 0;
            for (Object object : list) {
                result[i] = labelProvider.getText(object);
                ++i;
            }
        } else {
            result = new String[]{labelProvider.getText(null)};
        }
        return result;
    }

    public ExtendedComboBoxCellEditor(Composite parent, List list, ILabelProvider labelProvider, int style) {
        this(parent, ExtendedComboBoxCellEditor.createItems(list, labelProvider), null, style);
        this.list = list;
    }

    public ExtendedComboBoxCellEditor(Composite parent, String[] items, int style) {
        this(parent, items, null, style);
    }

    public ExtendedComboBoxCellEditor(Composite parent, String[] items, String emptyItem, int style) {
        super(parent, style);
        assert (items != null) : "list of items cannot be null";
        this.items = items;
        this.emptyItem = emptyItem;
        this.selection = 0;
        this.populateComboBoxItems();
    }

    void applyEditorValueAndDeactivate() {
        this.selection = this.comboBox.getSelectionIndex();
        Object newValue = this.doGetValue();
        this.markDirty();
        this.setValueValid(this.isCorrect(newValue));
        if (!this.isValueValid()) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), newValue));
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected Control createControl(Composite parent) {
        this.comboBox = new CCombo(parent, this.getStyle());
        this.comboBox.setFont(parent.getFont());
        this.comboBox.setBackground(parent.getBackground());
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ExtendedComboBoxCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                ExtendedComboBoxCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        if (this.emptyItem != null) {
            this.comboBox.setText(this.emptyItem);
        }
        return this.comboBox;
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        layoutData.minimumWidth = Math.max(30, layoutData.minimumWidth);
        return layoutData;
    }

    public Object doGetValue() {
        if (this.list != null && this.selection >= 0) {
            return this.selection < this.list.size() && this.selection >= 0 ? this.list.get(this.selection) : null;
        }
        if (this.getStyle() == 8 && this.selection >= 0) {
            return new Integer(this.selection);
        }
        if (this.selection < 0) {
            return this.comboBox.getText();
        }
        return this.comboBox.getItem(this.selection);
    }

    public void doSetValue(Object value) {
        if (this.list != null) {
            int index = this.list.indexOf(value);
            if (index != -1) {
                this.doSetValue1(new Integer(index));
            }
        } else {
            this.doSetValue1(value);
        }
    }

    private void doSetValue1(Object value) {
        assert (this.comboBox != null) : "comboBox cannot be null";
        if (value instanceof Integer) {
            this.selection = (Integer)value;
            this.comboBox.select(this.selection);
        }
        if (this.getStyle() != 8) {
            this.comboBox.setText(value.toString());
        }
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                this.comboBox.add(this.items[i], i);
                ++i;
            }
            this.setValueValid(true);
        }
    }
}

