/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions.internal;

import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.DiagramActionsDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.DiagramActionsPlugin;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.actions.CustomContributionItem;
import org.eclipse.gmf.runtime.diagram.ui.requests.ChangePropertyValueRequest;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.IWorkbenchPage;

public abstract class PropertyChangeContributionItem
extends CustomContributionItem {
    private String propertyId = null;
    private String propertyName = null;

    public PropertyChangeContributionItem(IWorkbenchPage workbenchPage, String id, String propertyId, String propertyName) {
        super(workbenchPage, id);
        Assert.isNotNull((Object)propertyId);
        Assert.isNotNull((Object)propertyName);
        this.setPropertyId(propertyId);
        this.setPropertyName(propertyName);
    }

    protected String getPropertyId() {
        return this.propertyId;
    }

    protected void setPropertyId(String propertyId) {
        this.propertyId = propertyId;
    }

    protected String getPropertyName() {
        return this.propertyName;
    }

    protected void setPropertyName(String string) {
        this.propertyName = string;
    }

    protected Request createTargetRequest() {
        return new ChangePropertyValueRequest(this.getPropertyName(), this.getPropertyId());
    }

    protected void updateTargetRequest() {
        ChangePropertyValueRequest request = (ChangePropertyValueRequest)this.getTargetRequest();
        request.setValue(this.getNewPropertyValue());
    }

    protected Object getOperationSetPropertyValue(String id) {
        List set = this.getOperationSet();
        if (!set.isEmpty()) {
            IGraphicalEditPart primaryEditPart = (IGraphicalEditPart)set.get(set.size() - 1);
            return this.getPropertyValue(primaryEditPart, id);
        }
        return null;
    }

    protected Object getOperationSetPropertyValue(String id, boolean useReadExeclusive) {
        List set = this.getOperationSet();
        if (!set.isEmpty()) {
            IGraphicalEditPart primaryEditPart = (IGraphicalEditPart)set.get(set.size() - 1);
            return this.getPropertyValue(primaryEditPart, id, useReadExeclusive);
        }
        return null;
    }

    protected Object getPropertyValue(final IGraphicalEditPart editPart, final String thePropertyId) {
        try {
            return editPart.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    ENamedElement element = PackageUtil.getElement((String)thePropertyId);
                    if (element instanceof EStructuralFeature) {
                        this.setResult(editPart.getStructuralFeatureValue((EStructuralFeature)element));
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramActionsPlugin.getInstance(), (String)DiagramActionsDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getPropertyValue", (Throwable)e);
            Log.error((Plugin)DiagramActionsPlugin.getInstance(), (int)9, (String)"getPropertyValue", (Throwable)e);
            return null;
        }
    }

    protected Object getPropertyValue(IGraphicalEditPart editPart, String thePropertyId, boolean useExclusiveRead) {
        if (useExclusiveRead) {
            return this.getPropertyValue(editPart, thePropertyId);
        }
        ENamedElement element = PackageUtil.getElement((String)thePropertyId);
        if (element instanceof EStructuralFeature) {
            return editPart.getStructuralFeatureValue((EStructuralFeature)element);
        }
        return null;
    }

    protected abstract Object getNewPropertyValue();

    protected boolean isSelectionListener() {
        return true;
    }
}

