/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.editparts;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.PageBreakNonResizableEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.PageBreaksFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.PageInfoHelper;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.jface.preference.IPreferenceStore;

public class PageBreakEditPart
extends AbstractGraphicalEditPart {
    private PageBreaksFigure pageOutlineFigure;
    private Rectangle diagramBounds = new Rectangle();

    public void set(Point location, Rectangle bounds) {
        if (bounds.x < location.x || bounds.y < location.y) {
            this.calculatePageBreakFigureBounds(true, bounds.getSize());
        } else {
            int width = Math.abs(bounds.right() - location.x);
            int height = Math.abs(bounds.bottom() - location.y);
            this.updatePageCount(width, height);
            this.getPageBreaksFigure().setLocation(location);
        }
    }

    private void updatePageCount(int width, int height) {
        Point printerPageSize = this.getPageSize();
        float numCols = (float)width / (float)printerPageSize.x;
        int cols = Math.max(1, (int)Math.ceil(numCols));
        float numRows = (float)height / (float)printerPageSize.y;
        int rows = Math.max(1, (int)Math.ceil(numRows));
        int xInc = printerPageSize.x * cols;
        int yInc = printerPageSize.y * rows;
        this.getPageBreaksFigure().setSize(new Dimension(xInc, yInc));
        this.getPageBreaksFigure().setPageCount(rows, cols);
    }

    public void calculatePageBreakFigureBounds(boolean center) {
        this.calculatePageBreakFigureBounds(center, this.diagramBounds.getSize());
    }

    public void calculatePageBreakFigureBounds() {
        this.calculatePageBreakFigureBounds(true, this.diagramBounds.getSize());
    }

    private void calculatePageBreakFigureBounds(boolean center, Dimension bounds) {
        this.updatePageCount(bounds.width, bounds.height);
        if (center) {
            this.centerPageBreaksFigure();
        }
    }

    protected IFigure createFigure() {
        this.pageOutlineFigure = new PageBreaksFigure(true);
        this.pageOutlineFigure.setCursor(Cursors.SIZEALL);
        return this.pageOutlineFigure;
    }

    private PageBreaksFigure getPageBreaksFigure() {
        if (this.pageOutlineFigure == null) {
            this.createFigure();
        }
        return this.pageOutlineFigure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new PageBreakNonResizableEditPolicy());
    }

    public Point getPageSize() {
        IPreferenceStore s = this.getPreferenceStoreForPageSetup();
        IMapMode mm = MapModeUtil.getMapMode();
        RootEditPart drEP = this.getRoot();
        if (drEP instanceof DiagramRootEditPart) {
            mm = ((DiagramRootEditPart)drEP).getMapMode();
        }
        return PageInfoHelper.getPageSize(s, mm);
    }

    private void centerPageBreaksFigure() {
        Rectangle pageBreakBounds = this.getPageBreaksFigure().getBounds();
        Rectangle r = this.diagramBounds;
        Point offset = new Point((pageBreakBounds.width - this.diagramBounds.width) / 2, (pageBreakBounds.height - this.diagramBounds.height) / 2);
        Rectangle centeredRec = new Rectangle(r.x - offset.x, r.y - offset.y, pageBreakBounds.width, pageBreakBounds.height);
        this.getPageBreaksFigure().setBounds(centeredRec);
    }

    public void resize(Rectangle newBounds) {
        Rectangle pageBreakBounds = this.getFigure().getBounds();
        Point pageSize = this.getPageSize();
        if (newBounds.x != this.diagramBounds.x || newBounds.width != this.diagramBounds.width) {
            int effectiveWidth;
            int xOffset;
            int requiredCols;
            float cols;
            if (newBounds.x < this.diagramBounds.x || newBounds.right() < this.diagramBounds.right()) {
                if (newBounds.x < pageBreakBounds.x) {
                    int effectivewidth = Math.abs(pageBreakBounds.right() - newBounds.right()) + newBounds.width;
                    cols = (float)effectivewidth / (float)pageSize.x;
                    requiredCols = (int)Math.ceil(Math.abs(cols));
                    xOffset = Math.round(requiredCols * pageSize.x);
                    this.getPageBreaksFigure().setCols(requiredCols);
                    pageBreakBounds = this.getPageBreaksFigure().getBounds();
                    this.getPageBreaksFigure().setBounds(new Rectangle(pageBreakBounds.right() - xOffset, pageBreakBounds.y, xOffset, pageBreakBounds.height));
                }
                pageBreakBounds = this.getPageBreaksFigure().getBounds();
                effectiveWidth = Math.abs(newBounds.x - pageBreakBounds.x) + newBounds.width;
                cols = (float)effectiveWidth / (float)pageSize.x;
                requiredCols = (int)Math.ceil(Math.abs(cols));
                xOffset = Math.round(requiredCols * pageSize.x);
                this.getPageBreaksFigure().setCols(requiredCols);
                this.getPageBreaksFigure().setBounds(new Rectangle(pageBreakBounds.x, pageBreakBounds.y, xOffset, pageBreakBounds.height));
            } else {
                if (newBounds.right() > pageBreakBounds.right()) {
                    effectiveWidth = Math.abs(newBounds.x - pageBreakBounds.x) + newBounds.width;
                    float x = (float)effectiveWidth / (float)pageSize.x;
                    int reqdCols = (int)Math.ceil(Math.abs(x));
                    xOffset = Math.round(reqdCols * pageSize.x);
                    this.getPageBreaksFigure().setCols(reqdCols);
                    pageBreakBounds = this.getFigure().getBounds();
                    this.getPageBreaksFigure().setBounds(new Rectangle(pageBreakBounds.x, pageBreakBounds.y, xOffset, pageBreakBounds.height));
                }
                pageBreakBounds = this.getPageBreaksFigure().getBounds();
                effectiveWidth = Math.abs(pageBreakBounds.right() - newBounds.right()) + newBounds.width;
                cols = (float)effectiveWidth / (float)pageSize.x;
                requiredCols = (int)Math.ceil(Math.abs(cols));
                xOffset = Math.round(requiredCols * pageSize.x);
                this.getPageBreaksFigure().setCols(requiredCols);
                this.getPageBreaksFigure().setBounds(new Rectangle(pageBreakBounds.right() - xOffset, pageBreakBounds.y, xOffset, pageBreakBounds.height));
            }
        }
        if (newBounds.y != this.diagramBounds.y || newBounds.height != this.diagramBounds.height) {
            int yOffset;
            int requiredRows;
            float rows;
            int effectiveHeight;
            if (newBounds.y < this.diagramBounds.y || newBounds.bottom() < this.diagramBounds.bottom()) {
                if (newBounds.y < pageBreakBounds.y) {
                    effectiveHeight = pageBreakBounds.bottom() - newBounds.bottom() + newBounds.height;
                    rows = (float)effectiveHeight / (float)pageSize.y;
                    requiredRows = (int)Math.ceil(Math.abs(rows));
                    yOffset = Math.round(requiredRows * pageSize.y);
                    this.getPageBreaksFigure().setRows(requiredRows);
                    pageBreakBounds = this.getFigure().getBounds();
                    this.getPageBreaksFigure().setBounds(new Rectangle(pageBreakBounds.x, pageBreakBounds.bottom() - yOffset, pageBreakBounds.width, yOffset));
                }
                pageBreakBounds = this.getPageBreaksFigure().getBounds();
                effectiveHeight = Math.abs(newBounds.y - pageBreakBounds.y) + newBounds.height;
                rows = (float)effectiveHeight / (float)pageSize.y;
                requiredRows = (int)Math.ceil(Math.abs(rows));
                yOffset = Math.round(requiredRows * pageSize.y);
                this.getPageBreaksFigure().setRows(requiredRows);
                pageBreakBounds = this.getFigure().getBounds();
                this.getPageBreaksFigure().setBounds(new Rectangle(pageBreakBounds.x, pageBreakBounds.y, pageBreakBounds.width, yOffset));
            } else {
                if (newBounds.bottom() > pageBreakBounds.bottom()) {
                    effectiveHeight = newBounds.y - pageBreakBounds.y + newBounds.height;
                    rows = (float)effectiveHeight / (float)pageSize.y;
                    requiredRows = (int)Math.ceil(Math.abs(rows));
                    yOffset = Math.round(requiredRows * pageSize.y);
                    this.getPageBreaksFigure().setRows(requiredRows);
                    pageBreakBounds = this.getFigure().getBounds();
                    this.getPageBreaksFigure().setBounds(new Rectangle(pageBreakBounds.x, pageBreakBounds.y, pageBreakBounds.width, yOffset));
                }
                pageBreakBounds = this.getPageBreaksFigure().getBounds();
                int effectiveheight = Math.abs(pageBreakBounds.bottom() - newBounds.bottom()) + newBounds.height;
                rows = (float)effectiveheight / (float)pageSize.y;
                requiredRows = (int)Math.ceil(Math.abs(rows));
                yOffset = Math.round(requiredRows * pageSize.y);
                this.getPageBreaksFigure().setRows(requiredRows);
                pageBreakBounds = this.getFigure().getBounds();
                this.getPageBreaksFigure().setBounds(new Rectangle(pageBreakBounds.x, pageBreakBounds.bottom() - yOffset, pageBreakBounds.width, yOffset));
            }
        }
        this.diagramBounds = newBounds;
    }

    public void updatePreferenceStore() {
        Rectangle r = this.getPageBreaksFigure().getBounds();
        IPreferenceStore s = ((DiagramGraphicalViewer)this.getRoot().getViewer()).getWorkspaceViewerPreferenceStore();
        if (s != null) {
            s.setValue("pagebreak.x", r.x);
            s.setValue("pagebreak.y", r.y);
        }
    }

    public DragTracker getDragTracker(Request req) {
        return new DragEditPartsTrackerEx((EditPart)this){

            protected boolean isMove() {
                return true;
            }
        };
    }

    private IPreferenceStore getPreferenceStoreForPageSetup() {
        IPreferenceStore workspaceStore = ((DiagramGraphicalViewer)this.getRoot().getViewer()).getWorkspaceViewerPreferenceStore();
        if (workspaceStore.getBoolean("print.useDiagramSettings")) {
            return workspaceStore;
        }
        if (this.getRoot() instanceof IDiagramPreferenceSupport) {
            return (IPreferenceStore)((IDiagramPreferenceSupport)this.getRoot()).getPreferencesHint().getPreferenceStore();
        }
        return (IPreferenceStore)PreferencesHint.USE_DEFAULTS.getPreferenceStore();
    }
}

