/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.common.core.internal.command;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.OneTimeCommand;

public class OneTimeCommandTest
extends TestCase {
    private IOperationHistory history;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        TestRunner.run((Test)OneTimeCommandTest.suite());
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.common.core.internal.command.OneTimeCommandTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz, "OneTimeCommand Test Suite");
    }

    public OneTimeCommandTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.history = OperationHistoryFactory.getOperationHistory();
    }

    public void test_historyNotFlushed_132371() throws Exception {
        UndoContext context = new UndoContext();
        IOperationHistoryListener historyListener = new IOperationHistoryListener((IUndoContext)context){
            private final /* synthetic */ IUndoContext val$context;
            {
                this.val$context = iUndoContext;
            }

            public void historyNotification(OperationHistoryEvent event) {
                switch (event.getEventType()) {
                    case 5: 
                    case 8: 
                    case 9: 
                    case 10: {
                        if (OneTimeCommandTest.this.history.canUndo(this.val$context)) break;
                        OneTimeCommandTest.this.history.dispose(this.val$context, true, false, false);
                    }
                }
            }
        };
        this.history.addOperationHistoryListener(historyListener);
        MarkerOperation marker = new MarkerOperation();
        marker.addContext((IUndoContext)context);
        this.history.execute((IUndoableOperation)marker, (IProgressMonitor)new NullProgressMonitor(), null);
        OneTimeCommandTest.assertTrue((String)"Marker operation must be undoable", (boolean)this.history.canUndo((IUndoContext)context));
        OneTimeCommand command = new OneTimeCommand("test_historyNotFlushed_132371"){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                return CommandResult.newOKCommandResult();
            }
        };
        command.addContext((IUndoContext)context);
        OneTimeCommandTest.assertFalse((String)"Unexpected undo context", (boolean)command.hasContext((IUndoContext)context));
        this.history.execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
        OneTimeCommandTest.assertTrue((String)"Undo history should not have been flushed", (boolean)this.history.canUndo((IUndoContext)context));
        OneTimeCommandTest.assertSame((String)"Marker operation should be on top of the undo history.", (Object)((Object)marker), (Object)this.history.getUndoOperation((IUndoContext)context));
    }

    static class MarkerOperation
    extends AbstractOperation {
        boolean wasExecuted;
        boolean wasUndone;
        boolean wasRedone;

        MarkerOperation() {
            super("Marker operation");
        }

        void reset() {
            this.wasExecuted = false;
            this.wasUndone = false;
            this.wasRedone = false;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.wasExecuted = true;
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.wasUndone = true;
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.wasRedone = true;
            return Status.OK_STATUS;
        }
    }
}

