/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.figures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.ArrowLocator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.RoutingAnimator;
import org.eclipse.draw2d.RoutingListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IPolygonAnchorableFigure;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.ConnectionLayerEx;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.DelegatingLayout;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class PolylineConnectionEx
extends PolylineConnection
implements IPolygonAnchorableFigure {
    private RotatableDecoration startDecoration;
    private RotatableDecoration endDecoration;
    private static Rectangle LINEBOUNDS = Rectangle.SINGLETON;
    private static int TOLERANCE = 3;
    public static final int SMOOTH_NONE = 0;
    public static final int SMOOTH_LESS = 16;
    public static final int SMOOTH_NORMAL = 32;
    public static final int SMOOTH_MORE = 64;
    public static final int JUMPLINK_FLAG_BELOW = 16384;
    public static final int JUMPLINK_FLAG_ABOVE = 32768;
    public static final int JUMPLINK_FLAG_ALL = 49152;
    private static final int SMOOTH_FACTOR_LESS = 15;
    private static final int SMOOTH_FACTOR_NORMAL = 30;
    private static final int SMOOTH_FACTOR_MORE = 50;
    private static final int ROUTE_AVOID_OBSTACLE = 256;
    private static final int ROUTE_CLOSEST_ROUTE = 512;
    private static final int ROUTE_JUMP_LINKS = 1024;
    private static final int JUMPLINK_FLAG_SMOOTH = 2048;
    private static final int JUMPLINK_FLAG_ANGLEIN = 4096;
    private static final int JUMPLINK_FLAG_ONBOTTOM = 8192;
    private static final int JUMPLINK_DEFAULT_SMOOTHNESS = 30;
    private long styleBits = 22528L;
    private JumpLinkSet jumpLinkSet;
    private Hashtable connectionAnchors;
    private static final String szAnchor = "";
    private static final Dimension dimCheck = new Dimension(100, 100);
    private static final int JUMPLINK_DEFAULT_WIDTH = 25;
    private static final int JUMPLINK_DEFAULT_HEIGHT = 10;
    private int[] dashes = null;
    private static final Cursor NO_COMMAND_SPECIAL_CURSOR = new Cursor((Device)Display.getDefault(), 0);

    private boolean isFeedbackLayer() {
        Dimension copied = dimCheck.getCopy();
        this.translateToRelative((Translatable)copied);
        return dimCheck.equals((Object)copied);
    }

    public PolylineConnectionEx() {
        this.setLayoutManager((LayoutManager)new DelegatingLayout());
        this.addRoutingListener((RoutingListener)RoutingAnimator.getDefault());
    }

    public void refreshLine() {
        this.dirtyJumpLinks();
        this.repaint();
    }

    public void addPoint(Point pt) {
        super.addPoint(pt);
        this.refreshLine();
    }

    private int calculateTolerance(boolean isFeedbackLayer) {
        Dimension absTol = new Dimension(TOLERANCE, 0);
        if (!isFeedbackLayer) {
            MapModeUtil.getMapMode((IFigure)this).DPtoLP((Translatable)absTol);
        }
        return absTol.width + this.lineWidth / 2;
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            if (this.getSmoothFactor() != 0) {
                this.bounds = this.getSmoothPoints().getBounds();
                this.bounds.expand(this.lineWidth / 2, this.lineWidth / 2);
                int i = 0;
                while (i < this.getChildren().size()) {
                    IFigure child = (IFigure)this.getChildren().get(i);
                    this.bounds.union(child.getBounds());
                    ++i;
                }
            } else {
                super.getBounds();
            }
            boolean isFeedbackLayer = this.isFeedbackLayer();
            int calculatedTolerance = this.calculateTolerance(isFeedbackLayer);
            Dimension jumpLinkSize = this.calculateJumpLinkSize(isFeedbackLayer);
            this.bounds.expand(jumpLinkSize.height + calculatedTolerance, jumpLinkSize.height + calculatedTolerance);
        }
        return this.bounds;
    }

    public Rectangle getSimpleBounds() {
        Point s = this.getStart();
        Point e = this.getEnd();
        Point start = new Point(Math.min(s.x, e.x), Math.min(s.y, e.y));
        Dimension d = new Dimension(Math.abs(s.x - e.x), Math.abs(s.y - e.y));
        return new Rectangle(start.x, start.y, d.width, d.height);
    }

    public boolean containsPoint(int x, int y) {
        boolean isFeedbackLayer = this.isFeedbackLayer();
        int calculatedTolerance = this.calculateTolerance(isFeedbackLayer);
        LINEBOUNDS.setBounds(this.getBounds());
        LINEBOUNDS.expand(calculatedTolerance, calculatedTolerance);
        if (!LINEBOUNDS.contains(x, y)) {
            return false;
        }
        int[] ints = this.getSmoothPoints().toIntArray();
        int index = 0;
        while (index < ints.length - 3) {
            if (this.lineContainsPoint(ints[index], ints[index + 1], ints[index + 2], ints[index + 3], x, y, isFeedbackLayer)) {
                return true;
            }
            index += 2;
        }
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (((IFigure)children.get(i)).containsPoint(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean lineContainsPoint(int x1, int y1, int x2, int y2, int px, int py, boolean isFeedbackLayer) {
        LINEBOUNDS.setSize(0, 0);
        LINEBOUNDS.setLocation(x1, y1);
        LINEBOUNDS.union(x2, y2);
        int calculatedTolerance = this.calculateTolerance(isFeedbackLayer);
        LINEBOUNDS.expand(calculatedTolerance, calculatedTolerance);
        if (!LINEBOUNDS.contains(px, py)) {
            return false;
        }
        double result = 0.0;
        if (x1 != x2 && y1 != y2) {
            double v1x = (double)x2 - (double)x1;
            double v1y = (double)y2 - (double)y1;
            double v2x = (double)px - (double)x1;
            double v2y = (double)py - (double)y1;
            double numerator = v2x * v1y - v1x * v2y;
            double denominator = v1x * v1x + v1y * v1y;
            result = numerator * numerator / denominator;
        }
        return result <= (double)(calculatedTolerance * calculatedTolerance);
    }

    public int findLineSegIndexOfPoint(int x, int y) {
        this.calculateTolerance(this.isFeedbackLayer());
        return PointListUtilities.findNearestLineSegIndexOfPoint(this.getPoints(), new Point(x, y));
    }

    public PointList getSmoothPoints() {
        if (this.getSmoothFactor() > 0) {
            return PointListUtilities.calcSmoothPolyline(this.getPoints(), this.getSmoothFactor(), 16);
        }
        return PointListUtilities.copyPoints(this.getPoints());
    }

    public void insertPoint(Point pt, int index) {
        super.insertPoint(pt, index);
        this.refreshLine();
    }

    protected void outlineShape(Graphics g) {
        PointList displayPoints = this.getSmoothPoints();
        int incline = this.calculateJumpLinkIncline(this.isFeedbackLayer());
        if (this.shouldJumpLinks()) {
            this.regenerateJumpLinks();
            JumpLinkSet pJumpLinkSet = this.getJumpLinkSet();
            if (pJumpLinkSet != null && pJumpLinkSet.m_pJumpLinks != null) {
                int nSmoothNess = 0;
                if (this.isJumpLinksSmooth()) {
                    nSmoothNess = 30;
                }
                boolean bOnBottom = this.isJumpLinksOnBottom();
                ListIterator linkIter = pJumpLinkSet.m_pJumpLinks.listIterator();
                while (linkIter.hasNext()) {
                    JumpLink pJumpLink = (JumpLink)linkIter.next();
                    PointList jumpLinkPoints = PointListUtilities.routeAroundPoint(displayPoints, pJumpLink.m_ptIntersect, pJumpLink.m_nHeight, pJumpLink.m_nWidth, nSmoothNess, incline, !bOnBottom);
                    if (jumpLinkPoints == null) continue;
                    displayPoints = jumpLinkPoints;
                }
            }
        }
        g.drawPolyline(displayPoints);
    }

    public void setLineWidth(int w) {
        this.bounds = null;
        super.setLineWidth(w);
    }

    public void setPoints(PointList points) {
        super.setPoints(points);
        this.dirtyAllJumpLinks();
        this.refreshLine();
    }

    private Dimension calculateJumpLinkSize(boolean isFeedbackLayer) {
        Dimension jumpDim = new Dimension(25, 10);
        if (!isFeedbackLayer) {
            MapModeUtil.getMapMode((IFigure)this).DPtoLP((Translatable)jumpDim);
        }
        return jumpDim;
    }

    private int calculateJumpLinkIncline(boolean isFeedbackLayer) {
        if (this.isJumpLinksAngledIn()) {
            return this.calculateJumpLinkSize((boolean)isFeedbackLayer).width / 5;
        }
        return 0;
    }

    public void dirtyAllJumpLinks() {
        IFigure pParent = this.getParent();
        if (pParent instanceof ConnectionLayerEx) {
            ((ConnectionLayerEx)pParent).dirtyJumpLinks(this.getBounds());
        }
    }

    private final int getSmoothFactor() {
        int smoothStyle = this.getSmoothness();
        if (smoothStyle == 16) {
            return 15;
        }
        if (smoothStyle == 32) {
            return 30;
        }
        if (smoothStyle == 64) {
            return 50;
        }
        return 0;
    }

    public final void setSmoothness(int smooth) {
        this.styleBits &= 0xFFFFFFFFFFFFFF8FL;
        if (smooth == 16 || smooth == 32 || smooth == 64) {
            this.styleBits |= (long)smooth;
        }
    }

    public final int getSmoothness() {
        if ((this.styleBits & 0x10L) != 0L) {
            return 16;
        }
        if ((this.styleBits & 0x20L) != 0L) {
            return 32;
        }
        if ((this.styleBits & 0x40L) != 0L) {
            return 64;
        }
        return 0;
    }

    public final boolean isClosestDistanceRouting() {
        return (this.styleBits & 0x200L) != 0L;
    }

    public final boolean isAvoidObstacleRouting() {
        return (this.styleBits & 0x100L) != 0L;
    }

    public void setRoutingStyles(boolean closestDistance, boolean avoidObstacles) {
        this.styleBits = closestDistance ? (this.styleBits |= 0x200L) : (this.styleBits &= 0xFFFFFFFFFFFFFDFFL);
        if (avoidObstacles) {
            if (!closestDistance) {
                this.styleBits |= 0x200L;
            }
            this.styleBits |= 0x100L;
        } else {
            this.styleBits &= 0xFFFFFFFFFFFFFEFFL;
        }
    }

    public final boolean shouldJumpLinks() {
        if ((this.styleBits & 0x400L) != 0L) {
            IFigure pParent = this.getParent();
            if (pParent instanceof ConnectionLayerEx) {
                return ConnectionLayerEx.shouldJumpLinks();
            }
            return true;
        }
        return false;
    }

    public void setJumpLinks(boolean on) {
        this.styleBits = on ? (this.styleBits |= 0x400L) : (this.styleBits &= 0xFFFFFFFFFFFFFBFFL);
    }

    public void setJumpLinksStyles(int jumpType, boolean curved, boolean angleIn, boolean onBottom) {
        this.styleBits &= 0xFFFFFFFFFFFF3FFFL;
        this.styleBits |= (long)jumpType;
        this.styleBits = curved ? (this.styleBits |= 0x800L) : (this.styleBits &= 0xFFFFFFFFFFFFF7FFL);
        this.styleBits = angleIn ? (this.styleBits |= 0x1000L) : (this.styleBits &= 0xFFFFFFFFFFFFEFFFL);
        this.styleBits = onBottom ? (this.styleBits |= 0x2000L) : (this.styleBits &= 0xFFFFFFFFFFFFDFFFL);
        this.dirtyJumpLinks();
    }

    public final boolean isJumpLinksSmooth() {
        return (this.styleBits & 0x800L) != 0L;
    }

    public final boolean isJumpLinksAngledIn() {
        return (this.styleBits & 0x1000L) != 0L;
    }

    public final boolean isJumpLinksOnBottom() {
        return (this.styleBits & 0x2000L) != 0L;
    }

    void dirtyJumpLinks() {
        JumpLinkSet pJumpLinkSet = this.getJumpLinkSet();
        if (pJumpLinkSet != null) {
            pJumpLinkSet.dirtyJumpLinks();
        }
    }

    private boolean regenerateJumpLinks() {
        JumpLinkSet pJumpLinkSet = this.getJumpLinkSet();
        if (pJumpLinkSet != null) {
            return pJumpLinkSet.regenerateJumpLinks((Connection)this);
        }
        return false;
    }

    private JumpLinkSet getJumpLinkSet() {
        if (this.shouldJumpLinks()) {
            if (this.jumpLinkSet == null) {
                this.jumpLinkSet = new JumpLinkSet();
            }
        } else {
            this.jumpLinkSet = null;
        }
        return this.jumpLinkSet;
    }

    public PointList getPolygonPoints() {
        return this.getSmoothPoints();
    }

    public ConnectionAnchor getConnectionAnchor(String terminal) {
        ConnectionAnchor connectAnchor = (ConnectionAnchor)this.getConnectionAnchors().get(terminal);
        if (connectAnchor == null) {
            if (terminal.equals(szAnchor)) {
                connectAnchor = this.createDefaultAnchor();
                this.getConnectionAnchors().put(terminal, connectAnchor);
            } else {
                connectAnchor = this.createAnchor(BaseSlidableAnchor.parseTerminalString(terminal));
            }
        }
        return connectAnchor;
    }

    public String getConnectionAnchorTerminal(ConnectionAnchor c) {
        if (c instanceof BaseSlidableAnchor) {
            return ((BaseSlidableAnchor)c).getTerminal();
        }
        if (this.getConnectionAnchors().containsValue(c)) {
            for (String key : this.getConnectionAnchors().keySet()) {
                if (!this.getConnectionAnchors().get(key).equals(c)) continue;
                return key;
            }
        }
        this.getConnectionAnchor(szAnchor);
        return szAnchor;
    }

    public ConnectionAnchor getSourceConnectionAnchorAt(Point p) {
        return this.createConnectionAnchor(p);
    }

    public ConnectionAnchor getTargetConnectionAnchorAt(Point p) {
        return this.createConnectionAnchor(p);
    }

    protected ConnectionAnchor createDefaultAnchor() {
        return new BaseSlidableAnchor((IFigure)this);
    }

    protected ConnectionAnchor createAnchor(PrecisionPoint p) {
        if (p == null) {
            return this.createDefaultAnchor();
        }
        return new BaseSlidableAnchor((IFigure)this, p);
    }

    protected ConnectionAnchor createConnectionAnchor(Point p) {
        if (p == null) {
            return this.getConnectionAnchor(szAnchor);
        }
        Point temp = p.getCopy();
        this.translateToRelative((Translatable)temp);
        PrecisionPoint pt = BaseSlidableAnchor.getAnchorRelativeLocation(temp, this.getBounds());
        return this.createAnchor(pt);
    }

    protected boolean isDefaultAnchorArea(PrecisionPoint p) {
        return p.preciseX >= this.getSlidableAnchorArea() / 2.0 && p.preciseX <= 1.0 - this.getSlidableAnchorArea() / 2.0 && p.preciseY >= this.getSlidableAnchorArea() / 2.0 && p.preciseY <= 1.0 - this.getSlidableAnchorArea() / 2.0;
    }

    protected Hashtable getConnectionAnchors() {
        if (this.connectionAnchors == null) {
            this.connectionAnchors = new Hashtable(1);
        }
        return this.connectionAnchors;
    }

    protected double getSlidableAnchorArea() {
        return 0.25;
    }

    public void setForegroundColor(Color fg) {
        super.setForegroundColor(fg);
        if (this.getTargetDecoration() != null) {
            this.getTargetDecoration().setForegroundColor(fg);
        }
        if (this.getSourceDecoration() != null) {
            this.getSourceDecoration().setForegroundColor(fg);
        }
    }

    public void setSourceDecoration(RotatableDecoration dec, ConnectionLocator locator) {
        if (this.getSourceDecoration() != null) {
            this.remove((IFigure)this.getSourceDecoration());
        }
        this.startDecoration = dec;
        if (dec != null) {
            this.add((IFigure)dec, locator);
        }
    }

    public void setTargetDecoration(RotatableDecoration dec, ConnectionLocator locator) {
        if (this.getTargetDecoration() != null) {
            this.remove((IFigure)this.getTargetDecoration());
        }
        this.endDecoration = dec;
        if (dec != null) {
            this.add((IFigure)dec, locator);
        }
    }

    protected RotatableDecoration getTargetDecoration() {
        return this.endDecoration;
    }

    protected RotatableDecoration getSourceDecoration() {
        return this.startDecoration;
    }

    public void setTargetDecoration(RotatableDecoration dec) {
        if (this.getTargetDecoration() != null) {
            this.remove((IFigure)this.getTargetDecoration());
        }
        this.endDecoration = dec;
        if (dec != null) {
            this.add((IFigure)dec, new ArrowLocator((Connection)this, 3));
        }
    }

    public void setSourceDecoration(RotatableDecoration dec) {
        if (this.getSourceDecoration() != null) {
            this.remove((IFigure)this.getSourceDecoration());
        }
        this.startDecoration = dec;
        if (dec != null) {
            this.add((IFigure)dec, new ArrowLocator((Connection)this, 2));
        }
    }

    public void setLineDash(int[] dashes) {
        if (dashes != null) {
            this.dashes = new int[dashes.length];
            int i = 0;
            while (i < dashes.length) {
                int dash = dashes[i];
                if (dash <= 0) {
                    SWT.error((int)5);
                }
                this.dashes[i] = dash;
                ++i;
            }
        } else {
            this.dashes = null;
        }
    }

    public void paintFigure(Graphics graphics) {
        graphics.pushState();
        if (this.dashes != null && this.getLineStyle() == 6) {
            graphics.setLineDash(this.dashes);
        }
        super.paintFigure(graphics);
        graphics.popState();
    }

    public Cursor getCursor() {
        if (this.isAvoidObstacleRouting()) {
            return NO_COMMAND_SPECIAL_CURSOR;
        }
        return super.getCursor();
    }

    protected class JumpLink {
        public Point m_ptIntersect;
        public int m_nWidth;
        public int m_nHeight;
        public int m_nDistance;

        protected JumpLink() {
        }
    }

    protected class JumpLinkSet {
        private boolean m_bDirty = true;
        private List m_pJumpLinks = null;

        public boolean isDirty() {
            return this.m_bDirty;
        }

        protected void cleanJumpLinks(Connection connect) {
            this.m_bDirty = false;
            IFigure pParent = connect.getParent();
            if (pParent instanceof ConnectionLayerEx) {
                ((ConnectionLayerEx)pParent).cleanJumpLinks();
            }
        }

        public void dirtyJumpLinks() {
            this.m_bDirty = true;
        }

        public boolean regenerateJumpLinks(Connection connect) {
            if (this.isDirty()) {
                this.calculateIntersections(connect);
                this.cleanJumpLinks(connect);
                return true;
            }
            return false;
        }

        private void sortByDistance() {
            Object[] jumpArray = this.m_pJumpLinks.toArray();
            Arrays.sort(jumpArray, new CompareDistance());
            int i = 0;
            while (i < this.m_pJumpLinks.size()) {
                this.m_pJumpLinks.set(i, jumpArray[i]);
                ++i;
            }
        }

        private void calculateIntersections(Connection connect) {
            IFigure pParent = connect.getParent();
            if (this.m_pJumpLinks != null) {
                this.m_pJumpLinks = null;
            }
            PointList tmpLine = PolylineConnectionEx.this.getSmoothPoints();
            long jumpType = PolylineConnectionEx.this.styleBits & 0xC000L;
            List children = pParent.getChildren();
            int nIndex = children.indexOf(connect);
            ListIterator childIter = children.listIterator();
            boolean bForwards = true;
            if (jumpType != 49152L) {
                childIter = children.listIterator(nIndex);
                if (jumpType == 16384L) {
                    bForwards = false;
                }
            }
            boolean isFeedbackLayer = PolylineConnectionEx.this.isFeedbackLayer();
            Dimension jumpLinkSize = PolylineConnectionEx.this.calculateJumpLinkSize(isFeedbackLayer);
            while (!(bForwards ? !childIter.hasNext() : !childIter.hasPrevious())) {
                IFigure figure = (IFigure)(bForwards ? childIter.next() : childIter.previous());
                PointList checkLine = null;
                if (figure == connect) continue;
                if (figure instanceof PolylineConnectionEx) {
                    checkLine = ((PolylineConnectionEx)figure).getSmoothPoints();
                } else if (figure instanceof Connection) {
                    checkLine = PointListUtilities.copyPoints(((Connection)figure).getPoints());
                }
                if (checkLine == null) continue;
                PointList intersections = new PointList();
                PointList distances = new PointList();
                if (this.m_pJumpLinks == null) {
                    this.m_pJumpLinks = new ArrayList(intersections.size());
                }
                if (!PointListUtilities.findIntersections(tmpLine, checkLine, intersections, distances)) continue;
                int i = 0;
                while (i < intersections.size()) {
                    double dist1 = intersections.getPoint(i).getDistance(tmpLine.getFirstPoint());
                    double dist2 = intersections.getPoint(i).getDistance(tmpLine.getLastPoint());
                    double dist3 = intersections.getPoint(i).getDistance(checkLine.getFirstPoint());
                    double dist4 = intersections.getPoint(i).getDistance(checkLine.getLastPoint());
                    double minDist = Math.min(Math.min(dist1, dist2), Math.min(dist3, dist4));
                    if (minDist > (double)(jumpLinkSize.width / 2)) {
                        this.addJumpLink(intersections.getPoint(i), distances.getPoint((int)i).x, isFeedbackLayer);
                    }
                    ++i;
                }
            }
            this.combineCloseLinks(tmpLine);
        }

        private void addJumpLink(Point ptIntersect, int nDistance, boolean isFeedbackLayer) {
            JumpLink pNewJumpLink = new JumpLink();
            pNewJumpLink.m_ptIntersect = new Point(ptIntersect);
            Dimension jumpLinkSize = PolylineConnectionEx.this.calculateJumpLinkSize(isFeedbackLayer);
            pNewJumpLink.m_nWidth = jumpLinkSize.width;
            pNewJumpLink.m_nHeight = jumpLinkSize.height;
            pNewJumpLink.m_nDistance = nDistance;
            this.m_pJumpLinks.add(pNewJumpLink);
        }

        private void combineCloseLinks(PointList tmpLine) {
            if (this.m_pJumpLinks == null || this.m_pJumpLinks.size() < 2) {
                return;
            }
            Dimension jumpLinkSize = PolylineConnectionEx.this.calculateJumpLinkSize(PolylineConnectionEx.this.isFeedbackLayer());
            int nCurrentWidth = jumpLinkSize.width;
            ArrayList jumpLinks = new ArrayList(this.m_pJumpLinks.size());
            this.sortByDistance();
            jumpLinks.addAll(this.m_pJumpLinks);
            this.m_pJumpLinks.clear();
            ListIterator linkIter = jumpLinks.listIterator();
            JumpLink pLastJumpLink = (JumpLink)linkIter.next();
            JumpLink pPrevJumpLink = null;
            int nDeltaMin = jumpLinkSize.width * 4 / 3;
            while (pLastJumpLink != null) {
                JumpLink pJumpLink = null;
                int nDelta = 0;
                if (linkIter.hasNext()) {
                    pJumpLink = (JumpLink)linkIter.next();
                    nDelta = pJumpLink.m_nDistance - pLastJumpLink.m_nDistance;
                }
                if (nDelta > nDeltaMin || pJumpLink == null) {
                    JumpLink pNewJumpLink = new JumpLink();
                    pNewJumpLink.m_nHeight = jumpLinkSize.height;
                    pNewJumpLink.m_nWidth = nCurrentWidth;
                    pNewJumpLink.m_nDistance = 0;
                    pNewJumpLink.m_ptIntersect = new Point(pLastJumpLink.m_ptIntersect);
                    if (pPrevJumpLink != null) {
                        long nNewDistance = pPrevJumpLink.m_nDistance + (pLastJumpLink.m_nDistance - pPrevJumpLink.m_nDistance) / 2;
                        pNewJumpLink.m_ptIntersect = new Point();
                        PointListUtilities.pointOn(tmpLine, nNewDistance, LineSeg.KeyPoint.ORIGIN, pNewJumpLink.m_ptIntersect);
                    }
                    this.m_pJumpLinks.add(pNewJumpLink);
                    nCurrentWidth = jumpLinkSize.width;
                    pPrevJumpLink = null;
                } else {
                    if (pPrevJumpLink == null) {
                        pPrevJumpLink = pLastJumpLink;
                    }
                    nCurrentWidth += jumpLinkSize.width - (nDeltaMin - nDelta);
                }
                pLastJumpLink = pJumpLink;
            }
        }

        private class CompareDistance
        implements Comparator {
            private CompareDistance() {
            }

            public int compare(Object obj1, Object obj2) {
                JumpLink j1 = (JumpLink)obj1;
                JumpLink j2 = (JumpLink)obj2;
                if (j1.m_nDistance < j2.m_nDistance) {
                    return -1;
                }
                if (j1.m_nDistance > j2.m_nDistance) {
                    return 1;
                }
                return 0;
            }
        }
    }
}

