/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.build;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.internal.xpand.Activator;
import org.eclipse.gmf.internal.xpand.model.XpandResource;
import org.eclipse.gmf.internal.xpand.util.ParserException;
import org.eclipse.gmf.internal.xpand.util.ResourceManagerImpl;
import org.eclipse.gmf.internal.xpand.util.StreamConverter;
import org.eclipse.gmf.internal.xpand.xtend.ast.XtendResource;
import org.osgi.framework.Bundle;

public class WorkspaceResourceManager
extends ResourceManagerImpl {
    private final IProject contextProject;
    private final IPath[] myConfiguredRoots;

    public WorkspaceResourceManager(IProject context, IPath[] configuredRoots) {
        this.contextProject = context;
        this.myConfiguredRoots = configuredRoots;
    }

    public XtendResource loadXtendResource(IFile file) throws CoreException, IOException, ParserException {
        String fullyQualifiedName;
        if (file == null || (fullyQualifiedName = this.toFullyQualifiedName(file)) == null) {
            return null;
        }
        Reader r = new StreamConverter().toContentsReader(file);
        this.loadXtendResources(new Reader[]{r}, fullyQualifiedName);
        try {
            return this.loadXtendThroughCache(fullyQualifiedName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public XpandResource loadXpandResource(IFile file) throws CoreException, IOException, ParserException {
        String fullyQualifiedName;
        if (file == null || (fullyQualifiedName = this.toFullyQualifiedName(file)) == null) {
            return null;
        }
        Reader r = new StreamConverter().toContentsReader(file);
        this.loadXpandResources(new Reader[]{r}, fullyQualifiedName);
        fullyQualifiedName = this.getNonAspectsTemplateName(fullyQualifiedName);
        try {
            return this.loadXpandThroughCache(fullyQualifiedName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    protected void handleParserException(ParserException ex) {
        Activator.logWarn(String.valueOf(ex.getClass().getSimpleName()) + ":" + ex.getResourceName());
    }

    protected boolean shouldCache() {
        return false;
    }

    public void forget(IFile resource) {
    }

    protected Reader[] resolveMultiple(String fqn, String ext) throws IOException {
        IPath fp = new Path(fqn.replaceAll("::", "/")).addFileExtension(ext);
        IPath[] resolutions = this.getResolutions(fp);
        ArrayList<Reader> result = new ArrayList<Reader>(resolutions.length);
        IPath[] iPathArray = this.getResolutions(fp);
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath p = iPathArray[n2];
            Reader nextReader = this.getReader(p);
            if (nextReader != null) {
                result.add(nextReader);
            }
            ++n2;
        }
        if (result.isEmpty()) {
            throw new FileNotFoundException(fp.toString());
        }
        return result.toArray(new Reader[result.size()]);
    }

    private Reader getReader(IPath p) throws IOException {
        if (p.isAbsolute()) {
            URL url;
            assert (p.segmentCount() > 1);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(p.segment(0));
            if (project.isAccessible()) {
                return this.getWorkspaceFileReader(project, p.removeFirstSegments(1));
            }
            Bundle platformBundle = Platform.getBundle((String)p.segment(0));
            if (platformBundle != null && (url = platformBundle.getEntry(p.removeFirstSegments(1).toString())) != null) {
                InputStream is = url.openStream();
                return new InputStreamReader(is, Charset.forName("ISO-8859-1"));
            }
        } else {
            return this.getWorkspaceFileReader(this.contextProject, p);
        }
        return null;
    }

    private Reader getWorkspaceFileReader(IProject project, IPath path) throws IOException {
        IResource r = project.findMember(path);
        if (r instanceof IFile) {
            try {
                return new StreamConverter().toContentsReader((IFile)r);
            }
            catch (CoreException ex) {
                IOException wrap = new IOException(ex.getStatus().getMessage());
                wrap.initCause(ex);
                throw wrap;
            }
        }
        return null;
    }

    private IPath[] getResolutions(IPath p) {
        IPath[] rv = new IPath[this.myConfiguredRoots.length];
        int i = 0;
        while (i < this.myConfiguredRoots.length) {
            rv[i] = this.myConfiguredRoots[i].append(p);
            ++i;
        }
        return rv;
    }

    private String toFullyQualifiedName(IFile file) {
        IPath[] iPathArray = this.myConfiguredRoots;
        int n = this.myConfiguredRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IPath nextRoot = iPathArray[n2];
            if (!nextRoot.isAbsolute()) {
                if (file.getProject().equals((Object)this.contextProject) && nextRoot.isPrefixOf(file.getProjectRelativePath())) {
                    return WorkspaceResourceManager.toFullyQualifiedName(file.getProjectRelativePath().removeFirstSegments(nextRoot.segmentCount()));
                }
            } else if (nextRoot.isPrefixOf(file.getFullPath())) {
                return WorkspaceResourceManager.toFullyQualifiedName(file.getFullPath().removeFirstSegments(nextRoot.segmentCount()));
            }
            ++n2;
        }
        return null;
    }

    private static String toFullyQualifiedName(IPath filePath) {
        return filePath.removeFileExtension().toString().replace("/", "::");
    }
}

