/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GenAuditContainer;
import org.eclipse.gmf.codegen.gmfgen.GenAuditRule;
import org.eclipse.gmf.codegen.gmfgen.GenAuditable;
import org.eclipse.gmf.codegen.gmfgen.GenDiagramElementTarget;
import org.eclipse.gmf.codegen.gmfgen.GenDomainElementTarget;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenNotationElementTarget;
import org.eclipse.gmf.codegen.gmfgen.GenRuleTarget;
import org.eclipse.gmf.tests.ConfiguredTestCase;
import org.eclipse.jdt.core.JavaConventions;

public class AuditHandcodedTest
extends ConfiguredTestCase {
    private List allAudits;
    private List containers;
    private GenAuditContainer root;
    private GenAuditContainer child1;
    private GenAuditContainer child2;
    private GenAuditRule rule0;
    private GenAuditRule rule1;
    private GenAuditRule rule2;

    public AuditHandcodedTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.allAudits = new ArrayList();
        this.containers = new ArrayList();
        this.root = GMFGenFactory.eINSTANCE.createGenAuditContainer();
        this.containers.add(this.root);
        this.rule0 = GMFGenFactory.eINSTANCE.createGenAuditRule();
        this.allAudits.add(this.rule0);
        this.root.getAudits().add((Object)this.rule0);
        this.child1 = GMFGenFactory.eINSTANCE.createGenAuditContainer();
        this.containers.add(this.child1);
        this.root.getChildContainers().add((Object)this.child1);
        this.rule1 = GMFGenFactory.eINSTANCE.createGenAuditRule();
        this.allAudits.add(this.rule1);
        this.child1.getAudits().add((Object)this.rule1);
        this.child2 = GMFGenFactory.eINSTANCE.createGenAuditContainer();
        this.containers.add(this.child2);
        this.rule2 = GMFGenFactory.eINSTANCE.createGenAuditRule();
        this.allAudits.add(this.rule2);
        this.child2.getAudits().add((Object)this.rule2);
        this.child1.getChildContainers().add((Object)this.child2);
    }

    public void testPath() throws Exception {
        AuditHandcodedTest.assertEquals((int)this.root.getPath().size(), (int)1);
        AuditHandcodedTest.assertEquals((Object)this.root.getPath().get(0), (Object)this.root);
        AuditHandcodedTest.assertEquals((int)this.child1.getPath().size(), (int)2);
        AuditHandcodedTest.assertEquals((Object)this.child1.getPath().get(0), (Object)this.root);
        AuditHandcodedTest.assertEquals((Object)this.child1.getPath().get(1), (Object)this.child1);
    }

    public void testGetAllAudits() throws Exception {
        AuditHandcodedTest.assertEquals((Object)this.allAudits, (Object)this.root.getAllAuditRules());
    }

    public void testGetAllContainers() throws Exception {
        AuditHandcodedTest.assertEquals((Object)this.containers, (Object)this.root.getAllAuditContainers());
    }

    public void testEditorReference() throws Exception {
        GenEditorGenerator editorGenerator = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        editorGenerator.setAudits(this.root);
        EList audits = this.root.getAllAuditContainers();
        AuditHandcodedTest.assertTrue((String)"at least 2 level container nesting required", (audits.size() > 1 ? 1 : 0) != 0);
        Iterator it = audits.iterator();
        while (it.hasNext()) {
            GenAuditContainer auditContainer = (GenAuditContainer)it.next();
            AuditHandcodedTest.assertSame((Object)editorGenerator, (Object)auditContainer.getEditor());
        }
    }

    public void testRulesToContextMap() {
        GenDiagramElementTarget diagramElementTarget1 = GMFGenFactory.eINSTANCE.createGenDiagramElementTarget();
        diagramElementTarget1.getElement().add((Object)this.getSetup().getGenModel().getNodeA());
        GenDiagramElementTarget diagramElementTarget2 = GMFGenFactory.eINSTANCE.createGenDiagramElementTarget();
        diagramElementTarget2.getElement().add((Object)this.getSetup().getGenModel().getLinkC());
        GenDomainElementTarget domainElementTarget = GMFGenFactory.eINSTANCE.createGenDomainElementTarget();
        domainElementTarget.setElement(this.getSetup().getGenModel().getNodeA().getDomainMetaClass());
        GenNotationElementTarget notationElementTarget = GMFGenFactory.eINSTANCE.createGenNotationElementTarget();
        notationElementTarget.setElement(this.getSetup().getGenModel().getLinkC().getDiagramRunTimeClass());
        GenRuleTarget[] targets = new GenRuleTarget[]{diagramElementTarget1, diagramElementTarget2, domainElementTarget, notationElementTarget};
        int expectedCtxCount = targets.length - 1;
        int numberOfAuditsToAdd = expectedCtxCount * 2 - this.root.getAllAuditRules().size();
        int i = 0;
        while (i < numberOfAuditsToAdd) {
            this.root.getAudits().add((Object)GMFGenFactory.eINSTANCE.createGenAuditRule());
            ++i;
        }
        HashSet<String> IDs = new HashSet<String>();
        int i2 = 0;
        Iterator it = this.root.getAllAuditRules().iterator();
        while (it.hasNext()) {
            GenAuditRule audit = (GenAuditRule)it.next();
            audit.setTarget((GenAuditable)EcoreUtil.copy((EObject)targets[i2 % targets.length]));
            IStatus s = JavaConventions.validateIdentifier((String)audit.getContextSelectorLocalClassName());
            AuditHandcodedTest.assertTrue((String)"Context selectorClassLocalName must valid java name", (s.getSeverity() != 4 ? 1 : 0) != 0);
            String ctxID = audit.getTarget().getClientContextID();
            s = JavaConventions.validateIdentifier((String)ctxID);
            AuditHandcodedTest.assertTrue((String)"Context ID must be a valid java identifier", (s.getSeverity() != 4 ? 1 : 0) != 0);
            IDs.add(ctxID);
            ++i2;
        }
        Map ctxMap = this.root.getAllRulesToTargetContextMap();
        AuditHandcodedTest.assertNotNull((Object)ctxMap);
        AuditHandcodedTest.assertEquals((String)"All target types should be in context map", IDs, ctxMap.keySet());
        AuditHandcodedTest.assertEquals((String)"Expected context count differs from resulting context map", (int)expectedCtxCount, (int)ctxMap.size());
        int assignedAuditCount = 0;
        Iterator it2 = ctxMap.values().iterator();
        while (it2.hasNext()) {
            Object element = it2.next();
            AuditHandcodedTest.assertTrue((boolean)(element instanceof EList));
            EList values = (EList)element;
            AuditHandcodedTest.assertFalse((boolean)values.isEmpty());
            AuditHandcodedTest.assertTrue((boolean)(values.get(0) instanceof GenAuditRule));
            assignedAuditCount += values.size();
        }
        AuditHandcodedTest.assertEquals((int)this.root.getAllAuditRules().size(), (int)assignedAuditCount);
        AuditHandcodedTest.assertTrue((String)"Diagram rule should be found", (boolean)this.root.hasDiagramElementRule());
        this.assertTargetedModels(targets);
    }

    public void testModelConstraintAdapters() throws Exception {
        LinkedHashSet<String> adapterClassNames = new LinkedHashSet<String>();
        Iterator it = this.allAudits.iterator();
        while (it.hasNext()) {
            GenAuditRule nextAudit = (GenAuditRule)it.next();
            adapterClassNames.add(nextAudit.getConstraintAdapterLocalClassName());
        }
        AuditHandcodedTest.assertEquals((String)"Constraint adapter classnames should be unique for audits", (int)this.allAudits.size(), (int)adapterClassNames.size());
        AuditHandcodedTest.assertEquals((String)"Adapter1", (String)this.rule0.getConstraintAdapterLocalClassName());
        AuditHandcodedTest.assertEquals((String)"Adapter11", (String)this.rule1.getConstraintAdapterLocalClassName());
        AuditHandcodedTest.assertEquals((String)"Adapter111", (String)this.rule2.getConstraintAdapterLocalClassName());
        GenAuditContainer container12 = GMFGenFactory.eINSTANCE.createGenAuditContainer();
        this.child1.getChildContainers().add((Object)container12);
        GenAuditRule child123 = GMFGenFactory.eINSTANCE.createGenAuditRule();
        container12.getAudits().add((Object)GMFGenFactory.eINSTANCE.createGenAuditRule());
        container12.getAudits().add((Object)GMFGenFactory.eINSTANCE.createGenAuditRule());
        container12.getAudits().add((Object)child123);
        AuditHandcodedTest.assertEquals((String)"Adapter123", (String)child123.getConstraintAdapterLocalClassName());
    }

    private void assertTargetedModels(GenRuleTarget[] targets) {
        EList packageList = this.root.getAllTargetedModelPackages();
        AuditHandcodedTest.assertFalse((boolean)packageList.isEmpty());
        HashSet collectedPackages = new HashSet();
        Iterator it = packageList.iterator();
        while (it.hasNext()) {
            collectedPackages.add(it.next());
        }
        int i = 0;
        while (i < targets.length) {
            AuditHandcodedTest.assertTrue((String)"Package must be found targeted packages", (boolean)collectedPackages.contains(targets[i].getContext().getGenPackage()));
            ++i;
        }
    }
}

