/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.util.LinkedList;
import org.eclipse.gmf.codegen.gmfgen.DynamicModelAccess;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.internal.bridge.genmodel.InnerClassViewmapProducer;
import org.eclipse.gmf.internal.bridge.genmodel.ViewmapProducer;
import org.eclipse.gmf.tests.gen.CompilationTest;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.eclipse.gmf.tests.setup.RuntimeBasedGeneratorConfiguration;
import org.eclipse.gmf.tests.setup.annotated.GenASetup;
import org.eclipse.gmf.tests.setup.annotated.MapDefASetup;

public class RuntimeCompilationTest
extends CompilationTest {
    public RuntimeCompilationTest(String name) {
        super(name);
    }

    public void testCompilePureDesignDiagram() throws Exception {
        MapDefASetup mmSource = this.getLibraryMap();
        mmSource.detachFromDomainModel();
        GenASetup gmfGenSource = new GenASetup(mmSource.getMapping(), this.getViewmapProducer(), false);
        gmfGenSource.getGenDiagram().getEditorGen().setPackageNamePrefix("org.eclipse.gmf.examples.library.diagram");
        this.generateAndCompile(gmfGenSource, NO_MUTATORS);
    }

    public void testCompileDynamicDomainModel() throws Exception {
        DiaGenSource s = this.getLibraryGen(false);
        GenEditorGenerator editorGen = s.getGenDiagram().getEditorGen();
        RuntimeCompilationTest.assertNull((String)"prereq", (Object)editorGen.getModelAccess());
        DynamicModelAccess dma = GMFGenFactory.eINSTANCE.createDynamicModelAccess();
        editorGen.setModelAccess(dma);
        LinkedList<CompilationTest.IGenDiagramMutator> m = new LinkedList<CompilationTest.IGenDiagramMutator>();
        m.add(new CompilationTest.IGenDiagramMutator(){

            public void doMutation(GenDiagram d) {
            }

            public void undoMutation(GenDiagram d) {
            }
        });
        m.add(new CompilationTest.IGenDiagramMutator(){

            public void doMutation(GenDiagram d) {
                DynamicModelAccess modelAccess = d.getEditorGen().getModelAccess();
                modelAccess.setClassName("NonDefaultDynamicAccessorName");
            }

            public void undoMutation(GenDiagram d) {
                DynamicModelAccess modelAccess = d.getEditorGen().getModelAccess();
                modelAccess.setClassName(null);
            }
        });
        this.generateAndCompile(s, m);
    }

    protected GeneratorConfiguration getGeneratorConfiguration() {
        return new RuntimeBasedGeneratorConfiguration();
    }

    protected ViewmapProducer getViewmapProducer() {
        return new InnerClassViewmapProducer();
    }
}

