/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.internal.common.codegen.GeneratorBase;
import org.eclipse.gmf.tests.CompileUtil;
import org.eclipse.gmf.tests.Plugin;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.eclipse.gmf.tests.setup.RuntimeWorkspaceSetup;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenProjectBaseSetup {
    private final Set<String> projectsToInit = new LinkedHashSet<String>();
    private CompileUtil compileUtil;
    private GeneratorConfiguration myGeneratorFactory;
    private static final String INTERFACE_TEMPLATE = "{0} public interface {1} '{ }'";

    public GenProjectBaseSetup(GeneratorConfiguration generatorFactory) {
        this.myGeneratorFactory = generatorFactory;
    }

    public void generateAndCompile(DiaGenSource diaGenSource) throws Exception {
        this.projectsToInit.clear();
        this.compileUtil = new CompileUtil();
        GenDiagram d = diaGenSource.getGenDiagram();
        this.generateDiagramPrerequisites(d);
        this.generateDiagramPlugin(d);
        for (String pluginID : this.projectsToInit) {
            IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(pluginID);
            this.hookProjectBuild(p);
        }
        this.compileUtil = null;
    }

    protected void generateDiagramPrerequisites(GenDiagram d) throws Exception {
        GenModel domainGenModel = d.getEditorGen().getDomainGenModel();
        if (domainGenModel != null) {
            this.generateEMFCode(domainGenModel);
            this.projectsToInit.add(domainGenModel.getModelPluginID());
            this.projectsToInit.add(domainGenModel.getEditPluginID());
        }
    }

    protected void generateDiagramPlugin(GenDiagram d) throws Exception {
        GeneratorBase generator = this.myGeneratorFactory.createGenerator(d);
        generator.run();
        this.hookGeneratorStatus(generator.getRunStatus());
        String gmfEditorId = d.getEditorGen().getPlugin().getID();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(gmfEditorId);
        RuntimeWorkspaceSetup.get().getReadyToStartAsBundle(project);
        this.projectsToInit.add(gmfEditorId);
        this.hookJDTStatus(ResourcesPlugin.getWorkspace().getRoot().getProject(gmfEditorId));
    }

    private void generateEMFCode(GenModel domainGenModel) {
        domainGenModel.setCanGenerate(true);
        Generator gen = new Generator();
        gen.setInput((Object)domainGenModel);
        gen.generate((Object)domainGenModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", (Monitor)new BasicMonitor());
        gen.generate((Object)domainGenModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", (Monitor)new BasicMonitor());
        this.fixInstanceClasses(domainGenModel);
        RuntimeWorkspaceSetup.get().getReadyToStartAsBundle(ResourcesPlugin.getWorkspace().getRoot().getProject(domainGenModel.getModelPluginID()));
        if (!domainGenModel.getModelPluginID().equals(domainGenModel.getEditPluginID())) {
            RuntimeWorkspaceSetup.get().getReadyToStartAsBundle(ResourcesPlugin.getWorkspace().getRoot().getProject(domainGenModel.getEditPluginID()));
        }
    }

    private void fixInstanceClasses(GenModel domainGenModel) {
        HashSet<String> allInstanceClassNames = new HashSet<String>();
        for (GenPackage nextPackage : domainGenModel.getGenPackages()) {
            for (GenClassifier nextGenClassifier : nextPackage.getGenClassifiers()) {
                if (!nextGenClassifier.getEcoreClassifier().eIsSet((EStructuralFeature)EcorePackage.Literals.ECLASSIFIER__INSTANCE_CLASS_NAME)) continue;
                allInstanceClassNames.add(nextGenClassifier.getEcoreClassifier().getInstanceClassName());
            }
        }
        if (allInstanceClassNames.isEmpty()) {
            return;
        }
        IPackageFragmentRoot theRoot = null;
        IFile manifestFile = null;
        try {
            String pluginID = domainGenModel.getModelPluginID();
            IProject pluginProject = ResourcesPlugin.getWorkspace().getRoot().getProject(pluginID);
            IJavaProject javaProject = JavaCore.create((IProject)pluginProject);
            Assert.assertNotNull((String)"Generated EMF model project is not a java project", (Object)javaProject);
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length && theRoot == null) {
                if (!roots[i].isReadOnly()) {
                    theRoot = roots[i];
                }
                ++i;
            }
            manifestFile = pluginProject.getFile("META-INF/MANIFEST.MF");
            Assert.assertNotNull((String)"Writable project root not found in the generated project", theRoot);
            Assert.assertTrue((String)"Manifest was not generated", (manifestFile != null && manifestFile.exists() ? 1 : 0) != 0);
            Manifest manifest = new Manifest(manifestFile.getContents());
            Attributes attributes = manifest.getMainAttributes();
            StringBuffer exportedPackages = new StringBuffer(attributes.getValue("Export-Package"));
            for (String instanceClassName : allInstanceClassNames) {
                this.generateUserInterface(instanceClassName, theRoot, exportedPackages);
            }
            attributes.putValue("Export-Package", exportedPackages.toString());
            ByteArrayOutputStream contents = new ByteArrayOutputStream();
            manifest.write(contents);
            manifestFile.setContents((InputStream)new ByteArrayInputStream(contents.toByteArray()), true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void generateUserInterface(String fqClassName, IPackageFragmentRoot projectRoot, StringBuffer exportedPackages) {
        String className = CodeGenUtil.getSimpleClassName((String)fqClassName);
        String packageName = CodeGenUtil.getPackageName((String)fqClassName);
        if (packageName == null) {
            packageName = "";
        }
        String packagePrefix = packageName;
        try {
            IPackageFragment pkgFragment = projectRoot.createPackageFragment(packageName, true, (IProgressMonitor)new NullProgressMonitor());
            if (packagePrefix.length() > 0) {
                packagePrefix = "package " + packagePrefix + ";";
            }
            pkgFragment.createCompilationUnit(String.valueOf(className) + ".java", MessageFormat.format(INTERFACE_TEMPLATE, packagePrefix, className), true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            Assert.fail((String)e.getMessage());
        }
        if (packageName.length() > 0 && exportedPackages.indexOf(packageName) == -1) {
            exportedPackages.append(",");
            exportedPackages.append(packageName);
        }
    }

    public List<String> getGeneratedProjectNames() {
        return Collections.unmodifiableList(new LinkedList<String>(this.projectsToInit));
    }

    protected void hookProjectBuild(IProject p) throws Exception {
        IStatus s = this.compileUtil.build(p);
        if (!s.isOK()) {
            Plugin.getInstance().getLog().log(s);
            if (s.getException() != null) {
                s.getException().printStackTrace(System.err);
            } else {
                System.err.println("hookProjectBuild failed without exception:" + s);
                LinkedList ch = new LinkedList(Arrays.asList(s.getChildren()));
                while (!ch.isEmpty()) {
                    IStatus f = (IStatus)ch.removeFirst();
                    if (f.getException() != null) {
                        System.err.println("============> Nested exception in the status:");
                        f.getException().printStackTrace(System.err);
                    }
                    ch.addAll(Arrays.asList(f.getChildren()));
                }
            }
            Assert.fail((String)s.getMessage());
        }
    }

    protected void hookJDTStatus(IProject p) throws Exception {
    }

    protected void hookGeneratorStatus(IStatus generatorStatus) {
        if (!generatorStatus.isOK()) {
            Plugin.getInstance().getLog().log(generatorStatus);
        }
        if (generatorStatus.getSeverity() == 4) {
            Assert.fail((String)("GMF editor generation produced errors:" + generatorStatus.toString()));
        }
    }
}

