/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import junit.framework.TestCase;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Ellipse;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.FigureHandle;
import org.eclipse.gmf.gmfgraph.FigureMarker;
import org.eclipse.gmf.gmfgraph.FigureRef;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.PolylineConnection;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.internal.bridge.Knowledge;

public class HandcodedGraphDefTest
extends TestCase {
    private FigureGallery myGallery;
    private Rectangle myFigureWithLabel;
    private Node myNode;
    private Connection myConnection;

    public HandcodedGraphDefTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.myGallery = GMFGraphFactory.eINSTANCE.createFigureGallery();
        this.myGallery.setName("g1");
        this.myFigureWithLabel = GMFGraphFactory.eINSTANCE.createRectangle();
        this.myFigureWithLabel.setName("RF");
        Label child = GMFGraphFactory.eINSTANCE.createLabel();
        child.setName("CHLF");
        this.myFigureWithLabel.getChildren().add((Object)child);
        this.myGallery.getFigures().add((Object)this.myFigureWithLabel);
        this.myNode = GMFGraphFactory.eINSTANCE.createNode();
        this.myNode.setName("N1");
        this.myNode.setFigure((FigureHandle)this.myFigureWithLabel);
        this.myConnection = GMFGraphFactory.eINSTANCE.createConnection();
        this.myConnection.setName("C1");
        PolylineConnection c1 = GMFGraphFactory.eINSTANCE.createPolylineConnection();
        c1.setName("c1fig");
        this.myGallery.getFigures().add((Object)c1);
        this.myConnection.setFigure((FigureHandle)c1);
    }

    public void testDerivedNodeFigure() {
        HandcodedGraphDefTest.assertNotNull((Object)this.myNode.getFigure());
        HandcodedGraphDefTest.assertNotNull((Object)this.myNode.getNodeFigure());
        HandcodedGraphDefTest.assertEquals((Object)this.myNode.getFigure(), (Object)this.myNode.getNodeFigure());
    }

    public void testDerivedConnectionFigure() {
        HandcodedGraphDefTest.assertNotNull((Object)this.myConnection.getFigure());
        HandcodedGraphDefTest.assertNotNull((Object)this.myConnection.getConnectionFigure());
        HandcodedGraphDefTest.assertEquals((Object)this.myConnection.getFigure(), (Object)this.myConnection.getConnectionFigure());
    }

    public void testIsLabelExternalLogic() {
        DiagramLabel l = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        Label figure = GMFGraphFactory.eINSTANCE.createLabel();
        l.setFigure((FigureHandle)figure);
        l.setName("L");
        figure.setName("LF");
        HandcodedGraphDefTest.assertTrue((String)"Label out from figure hierarchy should be treated as external", (boolean)HandcodedGraphDefTest.dgmtSnippetIsExternal(l));
        l.setFigure((FigureHandle)((Figure)this.myFigureWithLabel.getChildren().get(0)));
        HandcodedGraphDefTest.assertFalse((String)"Label from figures hierarchy should be treated as internal", (boolean)HandcodedGraphDefTest.dgmtSnippetIsExternal(l));
    }

    private static boolean dgmtSnippetIsExternal(DiagramLabel element) {
        return Knowledge.isExternal((DiagramLabel)element);
    }

    public void testFigureRefParent() {
        HandcodedGraphDefTest.assertParentOfFirstChild((Figure)this.myFigureWithLabel);
        Ellipse figWithRef = GMFGraphFactory.eINSTANCE.createEllipse();
        figWithRef.setName("EF");
        FigureRef fr = GMFGraphFactory.eINSTANCE.createFigureRef();
        fr.setFigure((Figure)this.myFigureWithLabel.getChildren().get(0));
        figWithRef.getChildren().add((Object)fr);
        HandcodedGraphDefTest.assertParentOfFirstChild((Figure)figWithRef);
    }

    private static void assertParentOfFirstChild(Figure figure) {
        FigureMarker child = (FigureMarker)figure.getChildren().get(0);
        HandcodedGraphDefTest.assertNotNull((Object)child.getParent());
        HandcodedGraphDefTest.assertEquals((Object)figure, (Object)child.getParent());
    }
}

