/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.codeassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.ResourceMarker;
import org.eclipse.gmf.internal.xpand.codeassist.LazyVar;
import org.eclipse.gmf.internal.xpand.codeassist.StackElement;
import org.eclipse.gmf.internal.xpand.codeassist.XpandPartition;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ExpressionFacade;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.model.XpandAdvice;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;
import org.eclipse.gmf.internal.xpand.model.XpandResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastAnalyzer {
    private static final Pattern PARAM_PATTERN = Pattern.compile("([\\[\\]:\\w]+)\\s+([\\w]+)");
    private static final Pattern IMPORT_PATTERN = Pattern.compile("\u00ab\\s*IMPORT\\s+\"([^\"]+)\"\\s*\u00bb");
    private static final Pattern EXTENSION_PATTERN = Pattern.compile("\u00ab\\s*EXTENSION\\s+([\\w\\:]+)\\s*\u00bb");
    private static final Pattern INCOMPLETE_IMPORT_PATTERN = Pattern.compile("\u00ab\\s*IMPORT\\s+[\\w\\:]*\\z");
    private static final Pattern INCOMPLETE_EXTENSION_PATTERN = Pattern.compile("\u00ab\\s*EXTENSION\\s+[\\w\\:]*\\z");
    private static final Pattern DEFINE_PATTERN = Pattern.compile("(DEFINE|AROUND)\\s*(([\\w\\*:]+)\\s*(\\(([\\[\\]:\\w\\s\\,]*)\\*?\\s*\\))?\\s*FOR\\s*([\\[\\]:\\w\\s]+))");
    private static final Pattern BLOCK_PATTERN = Pattern.compile(FastAnalyzer.getBlockPattern());
    private static final Pattern FOREACH_PATTERN = Pattern.compile("FOREACH\\s+(.+)\\s+AS\\s+(\\w+)(\\s+ITERATOR\\s+(\\w+))?");
    private static final Pattern EXPAND_PATTERN = Pattern.compile("EXPAND\\s+([\\w:]*)\\z");
    private static final Pattern LET_PATTERN = Pattern.compile("LET\\s+(.+)\\s+AS\\s+(\\w+)");
    private static final Pattern TYPEDECL_DEFINE_PATTERN1 = Pattern.compile("(DEFINE|AROUND)\\s*[\\w\\*:]+\\s*\\(([^\\)]*)\\z");
    private static final Pattern TYPEDECL_DEFINE_PATTERN2 = Pattern.compile("(DEFINE|AROUND)\\s*[\\w\\*:]+\\s*(\\([\\[\\]:\\w\\s\\,]*\\*?\\s*\\))?\\s*FOR\\s+[^\u00bb\\s]*\\z");
    private static final Pattern TYPEDECL_PARAM_PATTERN = Pattern.compile("(,|\\(|\\A)\\s*[\\[\\]:\\w]*\\z");
    private static final Pattern TYPEDECL_TYPESELECT_PATTERN = Pattern.compile("typeSelect\\(\\s*[\\[\\]:\\w]*\\z");
    private static final Pattern IN_TAG_PATTERN = Pattern.compile("\u00ab([^\u00bb]*)\\z");

    private FastAnalyzer() {
    }

    public static boolean isInExpand(String str) {
        return EXPAND_PATTERN.matcher(str).find();
    }

    public static boolean isInComment(String str) {
        int index = str.lastIndexOf("\u00abREM\u00bb");
        if (index >= 0) {
            int index2 = str.lastIndexOf("\u00abENDREM\u00bb");
            if (index2 == -1) {
                return true;
            }
            return index2 < index;
        }
        return false;
    }

    public static boolean isInDefine(String str) {
        return !FastAnalyzer.computeStack(str).isEmpty();
    }

    public static boolean isInTypeDecl(String str) {
        Matcher m = IN_TAG_PATTERN.matcher(str);
        if (!m.find()) {
            return false;
        }
        String tag = m.group(1);
        if ((m = TYPEDECL_DEFINE_PATTERN1.matcher(tag)).find()) {
            m = TYPEDECL_PARAM_PATTERN.matcher(m.group(2));
            return m.find();
        }
        m = TYPEDECL_DEFINE_PATTERN2.matcher(tag);
        if (m.find()) {
            return true;
        }
        m = TYPEDECL_TYPESELECT_PATTERN.matcher(tag);
        return m.find();
    }

    private static String getBlockPattern() {
        String[] parts = new String[]{"DEFINE", "AROUND", "FOREACH", "LET", "IF", "FILE", "PROTECT"};
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < parts.length) {
            String part = parts[i];
            buff.append("\u00ab").append("\\s*").append(part);
            buff.append("|");
            buff.append("\u00ab").append("\\s*").append("END").append(part);
            if (i < parts.length - 1) {
                buff.append("|");
            }
            ++i;
        }
        return buff.toString();
    }

    public static final List<String> findImports(String template) {
        Matcher m = IMPORT_PATTERN.matcher(template);
        ArrayList<String> result = new ArrayList<String>();
        while (m.find()) {
            result.add(m.group(1));
        }
        return result;
    }

    public static final List<String> findExtensions(String template) {
        Matcher m = EXTENSION_PATTERN.matcher(template);
        ArrayList<String> result = new ArrayList<String>();
        while (m.find()) {
            result.add(m.group(1));
        }
        return result;
    }

    public static final Stack<StackElement> computeStack(String templatePart) {
        int start = templatePart.lastIndexOf("ENDDEFINE");
        int start1 = templatePart.lastIndexOf("ENDAROUND");
        if (start1 > start) {
            start = start1;
        }
        if (start > 0) {
            templatePart = templatePart.substring(start);
        }
        Stack<StackElement> stack = new Stack<StackElement>();
        Matcher matcher = BLOCK_PATTERN.matcher(templatePart);
        while (matcher.find()) {
            LazyVar ctx;
            Matcher m;
            StackElement se;
            String txt = matcher.group();
            if (txt.endsWith("ENDFOREACH")) {
                stack.pop();
                continue;
            }
            if (txt.endsWith("ENDLET")) {
                stack.pop();
                continue;
            }
            if (txt.endsWith("ENDIF")) {
                stack.pop();
                continue;
            }
            if (txt.endsWith("ENDPROTECT")) {
                stack.pop();
                continue;
            }
            if (txt.endsWith("ENDFILE")) {
                stack.pop();
                continue;
            }
            if (txt.endsWith("ENDDEFINE")) {
                stack.pop();
                continue;
            }
            if (txt.endsWith("ENDAROUND")) {
                stack.pop();
                continue;
            }
            if (txt.endsWith("DEFINE") || txt.endsWith("AROUND")) {
                se = new StackElement();
                se.block = txt.endsWith("AROUND") ? "AROUND" : "DEFINE";
                m = DEFINE_PATTERN.matcher(templatePart.substring(matcher.start()));
                if (!m.find()) continue;
                ctx = new LazyVar();
                ctx.typeName = m.group(6).trim();
                ctx.name = "this";
                se.variables.put(ctx.name, ctx);
                String params = m.group(5);
                if (params != null && !"".equals(params.trim())) {
                    StringTokenizer st = new StringTokenizer(params, ",");
                    while (st.hasMoreTokens()) {
                        String param = st.nextToken();
                        m = PARAM_PATTERN.matcher(param);
                        m.find();
                        ctx = new LazyVar();
                        ctx.typeName = m.group(1).trim();
                        ctx.name = m.group(2).trim();
                        se.variables.put(ctx.name, ctx);
                    }
                }
                if (se.block.equals("AROUND")) {
                    ctx = new LazyVar();
                    ctx.typeName = BuiltinMetaModel.DEFINITION_TYPE.getName();
                    ctx.name = "targetDef";
                    se.variables.put(ctx.name, ctx);
                }
                stack.push(se);
                continue;
            }
            if (txt.endsWith("FOREACH")) {
                se = new StackElement();
                se.block = "FOREACH";
                m = FOREACH_PATTERN.matcher(templatePart.substring(matcher.start()));
                if (!m.find()) continue;
                ctx = new LazyVar();
                ctx.expression = m.group(1);
                ctx.name = m.group(2);
                ctx.forEach = true;
                se.variables.put(ctx.name, ctx);
                stack.push(se);
                if (m.group(3) == null) continue;
                ctx = new LazyVar();
                ctx.typeName = BuiltinMetaModel.ITERATOR_TYPE.getName();
                ctx.name = m.group(4);
                se.variables.put(ctx.name, ctx);
                continue;
            }
            if (txt.endsWith("LET")) {
                se = new StackElement();
                se.block = "LET";
                m = LET_PATTERN.matcher(templatePart.substring(matcher.start()));
                if (!m.find()) continue;
                ctx = new LazyVar();
                ctx.expression = m.group(1);
                ctx.name = m.group(2);
                se.variables.put(ctx.name, ctx);
                stack.push(se);
                continue;
            }
            if (txt.endsWith("IF")) {
                se = new StackElement();
                se.block = "IF";
                stack.push(se);
                continue;
            }
            if (txt.endsWith("PROTECT")) {
                se = new StackElement();
                se.block = "PROTECT";
                stack.push(se);
                continue;
            }
            if (!txt.endsWith("FILE")) continue;
            se = new StackElement();
            se.block = "FILE";
            stack.push(se);
        }
        return stack;
    }

    protected static boolean isInExtensionImport(String s) {
        Matcher m = INCOMPLETE_EXTENSION_PATTERN.matcher(s);
        return m.find();
    }

    protected static boolean isInImport(String s) {
        Matcher m = INCOMPLETE_IMPORT_PATTERN.matcher(s);
        return m.find();
    }

    public static final XpandPartition computePartition(String str) {
        if (!FastAnalyzer.isInTag(str)) {
            return XpandPartition.DEFAULT;
        }
        if (FastAnalyzer.isInComment(str)) {
            return XpandPartition.COMMENT;
        }
        if (FastAnalyzer.isInExpand(str)) {
            return XpandPartition.EXPAND_STATEMENT;
        }
        if (FastAnalyzer.isInImport(str)) {
            return XpandPartition.NAMESPACE_IMPORT;
        }
        if (FastAnalyzer.isInExtensionImport(str)) {
            return XpandPartition.EXTENSION_IMPORT;
        }
        if (FastAnalyzer.isInTypeDecl(str)) {
            return XpandPartition.TYPE_DECLARATION;
        }
        return XpandPartition.EXPRESSION;
    }

    public static final XpandExecutionContext computeExecutionContext(String str, XpandExecutionContext ctx) {
        XpandPartition p = FastAnalyzer.computePartition(str);
        if (p != XpandPartition.TYPE_DECLARATION && p != XpandPartition.EXPRESSION) {
            return ctx;
        }
        final List<String> imports = FastAnalyzer.findImports(str);
        final List<String> extensions = FastAnalyzer.findExtensions(str);
        XpandResource tpl = new XpandResource(){

            public XpandDefinition[] getDefinitions() {
                Exception e = new Exception("This code was refactored to return no definitions every time invoked, instead of definitions obtained from last saved state from resource subsystem");
                e.fillInStackTrace();
                e.printStackTrace();
                return new XpandDefinition[0];
            }

            public String getFullyQualifiedName() {
                throw new UnsupportedOperationException();
            }

            public String[] getImportedNamespaces() {
                return imports.toArray(new String[imports.size()]);
            }

            public String[] getImportedExtensions() {
                return extensions.toArray(new String[extensions.size()]);
            }

            public void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
                Exception ex = new Exception("ANALYZE!!!");
                ex.fillInStackTrace();
                ex.printStackTrace();
            }

            public XpandAdvice[] getAdvices() {
                return new XpandAdvice[0];
            }
        };
        ctx = (XpandExecutionContext)ctx.cloneWithResource((ResourceMarker)tpl);
        Stack<StackElement> s = FastAnalyzer.computeStack(str);
        for (StackElement element : s) {
            Collection<LazyVar> vars = element.variables.values();
            for (LazyVar v : vars) {
                Object vType = null;
                if (v.typeName != null) {
                    vType = ctx.getTypeForName(v.typeName);
                } else {
                    vType = new ExpressionFacade((ExecutionContext)ctx).analyze(v.expression, new HashSet());
                    if (v.forEach) {
                        vType = BuiltinMetaModel.isParameterizedType((EClassifier)vType) ? BuiltinMetaModel.getInnerType((EClassifier)vType) : null;
                    }
                }
                ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable[]{new Variable(v.name, vType)});
            }
        }
        return ctx;
    }

    public static boolean isInTag(String str) {
        return IN_TAG_PATTERN.matcher(str).find();
    }
}

