/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration.ui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildPropertiesManager {
    private static final String BUILD_PROPERTIES = "build.properties";
    private static final String PROPERTY_JAR_ORDER = "jars.compile.order";
    private static final String DEFAULT_JAR_NAME = ".";
    private static final String DEFAULT_LIBRARY_ENTRY = "source..";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private IProject project;
    private List<IFolder> sourceFolders = new ArrayList<IFolder>();
    private List<IResource> binInclude = new ArrayList<IResource>();
    private IFile buildPropertiesFile;

    private static String createWritableName(String source) {
        if (source.indexOf(32) >= 0) {
            StringBuffer writableName = new StringBuffer();
            int i = 0;
            while (i < source.length()) {
                char c = source.charAt(i);
                if (c == ' ') {
                    writableName.append("\\ ");
                } else {
                    writableName.append(c);
                }
                ++i;
            }
            source = writableName.toString();
        }
        return BuildPropertiesManager.createEscapedValue(source);
    }

    public static String createEscapedValue(String value) {
        StringBuffer buf = new StringBuffer(value.length() * 2);
        int i = 0;
        while (i < value.length()) {
            char character = value.charAt(i);
            if (character == '\\' || character == '\t' || character == '\r' || character == '\n' || character == '\f') {
                buf.append('\\');
                buf.append(character);
            } else if (character < ' ' || character > '~') {
                buf.append('\\');
                buf.append('u');
                buf.append(HEX[character >> 12 & 0xF]);
                buf.append(HEX[character >> 8 & 0xF]);
                buf.append(HEX[character >> 4 & 0xF]);
                buf.append(HEX[character & 0xF]);
            } else {
                buf.append(character);
            }
            ++i;
        }
        return buf.toString();
    }

    public static int getInsertOffset(IDocument doc) {
        int offset = doc.getLength();
        int i = doc.getNumberOfLines() - 1;
        while (i >= 0) {
            try {
                if (doc.get(doc.getLineOffset(i), doc.getLineLength(i)).trim().length() > 0) break;
                offset = doc.getLineOffset(i);
            }
            catch (BadLocationException badLocationException) {}
            --i;
        }
        return offset;
    }

    private static CoreException createCoreException(Throwable th) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.gmf.xpand.migration", "Exception during migration", th));
    }

    private static CoreException createCoreException(String message) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.gmf.xpand.migration", message));
    }

    private static IProgressMonitor createSubProgressMonitor(IProgressMonitor monitor, String taskName, int numberOfTicks) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException("Process was canceled");
        }
        SubProgressMonitor spm = new SubProgressMonitor(monitor, numberOfTicks);
        if (taskName != null) {
            spm.setTaskName(taskName);
        }
        return spm;
    }

    public BuildPropertiesManager(IProject project) {
        this.project = project;
    }

    public void addSourceFolder(IFolder sourceFolder) {
        this.sourceFolders.add(sourceFolder);
    }

    public void addBinInclude(IResource resource) {
        this.binInclude.add(resource);
    }

    public void save(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (this.sourceFolders.isEmpty() && this.binInclude.isEmpty()) {
            monitor.done();
            return;
        }
        monitor.beginTask("Saving modified build.properties file", 6);
        Properties buildProperties = this.loadBuildProperties();
        monitor.worked(1);
        IDocument document = this.loadDocument(this.getBuildPropertiesFile());
        String lf = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        monitor.worked(1);
        MultiTextEdit edit = new MultiTextEdit();
        this.addSourceFolders(edit, document, buildProperties, lf);
        monitor.worked(1);
        this.addBinIncludes(edit, document, buildProperties, lf);
        monitor.worked(1);
        try {
            edit.apply(document);
        }
        catch (MalformedTreeException e) {
            BuildPropertiesManager.createCoreException(e);
        }
        catch (BadLocationException e) {
            BuildPropertiesManager.createCoreException(e);
        }
        monitor.worked(1);
        this.saveDocument(document, this.getBuildPropertiesFile(), BuildPropertiesManager.createSubProgressMonitor(monitor, "Saving modified build.properties file", 1));
    }

    private void addBinIncludes(MultiTextEdit edit, IDocument document, Properties buildProperties, String lf) throws CoreException {
        List<String> binIncludes = this.getValues(buildProperties, "bin.includes");
        for (IResource resource : this.binInclude) {
            IPath projectRelativePath = resource.getProjectRelativePath();
            if (resource instanceof IFolder) {
                projectRelativePath = projectRelativePath.addTrailingSeparator();
            }
            binIncludes.add(projectRelativePath.toString());
        }
        this.modifyKey("bin.includes", binIncludes, edit, document, buildProperties, lf);
    }

    private void addSourceFolders(MultiTextEdit edit, IDocument document, Properties buildProperties, String lf) throws CoreException {
        List<String> jarOrderValues = this.getValues(buildProperties, PROPERTY_JAR_ORDER);
        if (!jarOrderValues.contains(DEFAULT_JAR_NAME)) {
            jarOrderValues.add(DEFAULT_JAR_NAME);
            this.modifyKey(PROPERTY_JAR_ORDER, jarOrderValues, edit, document, buildProperties, lf);
        }
        List<String> defaultLibraryFolders = this.getValues(buildProperties, DEFAULT_LIBRARY_ENTRY);
        for (IFolder nextFolder : this.sourceFolders) {
            defaultLibraryFolders.add(nextFolder.getProjectRelativePath().addTrailingSeparator().toString());
        }
        this.modifyKey(DEFAULT_LIBRARY_ENTRY, defaultLibraryFolders, edit, document, buildProperties, lf);
    }

    private void modifyKey(String key, List<String> values, MultiTextEdit edit, IDocument document, Properties buildProperties, String lf) throws CoreException {
        String text = this.serialize(values, key, lf);
        if (buildProperties.containsKey(key)) {
            int offset = this.getKeyOffset(document, key);
            int length = this.getKeyLength(document, key, offset);
            edit.addChild((TextEdit)new ReplaceEdit(offset, length, text));
        } else {
            edit.addChild((TextEdit)new InsertEdit(BuildPropertiesManager.getInsertOffset(document), text));
        }
    }

    private int getKeyLength(IDocument document, String key, int keyOffset) {
        int lines = document.getNumberOfLines();
        try {
            int i = 0;
            while (i < lines) {
                int offset = document.getLineOffset(i);
                if (offset >= keyOffset) {
                    int length = document.getLineLength(i);
                    String line = document.get(offset, length);
                    if (line.startsWith("#") | line.startsWith("!")) {
                        return offset - 1 - keyOffset;
                    }
                    if ((line = line.trim()).length() == 0) {
                        return offset - 1 - keyOffset;
                    }
                    if (!line.endsWith("\\")) {
                        return offset + document.getLineLength(i) - keyOffset;
                    }
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        return document.getLength() - keyOffset;
    }

    private int getKeyOffset(IDocument document, String key) throws CoreException {
        try {
            int lines = document.getNumberOfLines();
            int i = 0;
            while (i < lines) {
                int index;
                int length;
                int offset = document.getLineOffset(i);
                String line = document.get(offset, length = document.getLineLength(i));
                if (!(line.startsWith("#") | line.startsWith("!")) && (index = (line = line.trim()).indexOf(61)) != -1) {
                    String name = line.substring(0, index).trim();
                    if (BuildPropertiesManager.createEscapedValue(key).equals(name)) {
                        while (Character.isSpaceChar(document.getChar(offset))) {
                            ++offset;
                        }
                        return offset;
                    }
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        assert (false);
        throw BuildPropertiesManager.createCoreException("Property: " + key + " was not found in " + BUILD_PROPERTIES + " file");
    }

    private String serialize(List<String> values, String propertyName, String lf) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(BuildPropertiesManager.createWritableName(propertyName));
        buffer.append(" = ");
        int indentLength = propertyName.length() + 3;
        int i = 0;
        while (i < values.size()) {
            buffer.append(BuildPropertiesManager.createEscapedValue(values.get(i)));
            if (i < values.size() - 1) {
                buffer.append(",\\");
                buffer.append(lf);
                int j = 0;
                while (j < indentLength) {
                    buffer.append(" ");
                    ++j;
                }
            }
            ++i;
        }
        buffer.append(lf);
        return buffer.toString();
    }

    private List<String> getValues(Properties buildProperties, String key) {
        ArrayList<String> values = new ArrayList<String>();
        if (!buildProperties.containsKey(key)) {
            return values;
        }
        StringTokenizer stok = new StringTokenizer(buildProperties.getProperty(key).toString(), ",");
        while (stok.hasMoreTokens()) {
            values.add(stok.nextToken().trim());
        }
        return values;
    }

    private IDocument loadDocument(IFile file) throws CoreException {
        if (!file.exists()) {
            return new Document();
        }
        try {
            InputStreamReader reader = new InputStreamReader(this.buildPropertiesFile.getContents(), file.getCharset());
            StringBuilder currentLine = new StringBuilder();
            char nextChar = (char)((Reader)reader).read();
            while (nextChar != '\uffff') {
                currentLine.append(nextChar);
                nextChar = (char)((Reader)reader).read();
            }
            return new Document(currentLine.toString());
        }
        catch (IOException e) {
            throw BuildPropertiesManager.createCoreException(e);
        }
    }

    private void saveDocument(IDocument document, IFile file, IProgressMonitor monitor) throws CoreException {
        String charset = file.exists() ? file.getCharset() : "ISO-8859-1";
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(document.get().getBytes(charset));
            if (this.buildPropertiesFile.exists()) {
                this.buildPropertiesFile.setContents((InputStream)inputStream, 3, monitor);
            } else {
                this.buildPropertiesFile.create((InputStream)inputStream, true, monitor);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw BuildPropertiesManager.createCoreException(e);
        }
    }

    private Properties loadBuildProperties() throws CoreException {
        Properties result = new Properties();
        if (this.getBuildPropertiesFile().exists()) {
            try {
                result.load(this.getBuildPropertiesFile().getContents());
            }
            catch (IOException e) {
                throw BuildPropertiesManager.createCoreException(e);
            }
        }
        return result;
    }

    private IFile getBuildPropertiesFile() {
        if (this.buildPropertiesFile == null) {
            this.buildPropertiesFile = this.project.getFile(BUILD_PROPERTIES);
        }
        return this.buildPropertiesFile;
    }
}

