/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.migration.Activator;
import org.eclipse.gmf.internal.xpand.util.ParserException;

public class OawMarkerManager {
    public static void addMarkers(IFile file, AnalysationIssue ... issues) {
        MarkerData[] data = new MarkerData[issues.length];
        int i = 0;
        AnalysationIssue[] analysationIssueArray = issues;
        int n = issues.length;
        int n2 = 0;
        while (n2 < n) {
            AnalysationIssue issue = analysationIssueArray[n2];
            data[i++] = OawMarkerManager.createMarkerData(issue);
            ++n2;
        }
        OawMarkerManager.internalAddMarker(file, data);
    }

    public static void addMarkers(IFile file, ParserException.ErrorLocationInfo ... issues) {
        MarkerData[] data = new MarkerData[issues.length];
        int i = 0;
        ParserException.ErrorLocationInfo[] errorLocationInfoArray = issues;
        int n = issues.length;
        int n2 = 0;
        while (n2 < n) {
            ParserException.ErrorLocationInfo issue = errorLocationInfoArray[n2];
            int start = issue.startLine == issue.endLine ? issue.startColumn : -1;
            int end = issue.startLine == issue.endLine ? issue.endColumn : -1;
            data[i++] = new MarkerData(issue.message, 2, start, end, issue.startLine);
            ++n2;
        }
        OawMarkerManager.internalAddMarker(file, data);
    }

    public static void addErrorMarker(IFile file, String message, int start, int end) {
        OawMarkerManager.internalAddMarker(file, new MarkerData(message, 2, start, end));
    }

    private static MarkerData createMarkerData(AnalysationIssue issue) {
        int start = -1;
        int end = -1;
        int line = -1;
        if (issue.getElement() != null) {
            start = issue.getElement().getStart() - 1;
            end = issue.getElement().getEnd() - 1;
            line = issue.getElement().getLine();
        }
        int severity = issue.isWarningNotError() ? 1 : 2;
        return new MarkerData(issue.getMessage(), severity, start, end, line);
    }

    private static final String getMARKER_TYPE() {
        return "org.eclipse.gmf.xpand.problem";
    }

    private static final void internalAddMarker(final IFile file, final MarkerData ... markerData) {
        try {
            file.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    MarkerData[] markerDataArray = markerData;
                    int n = markerData.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MarkerData d = markerDataArray[n2];
                        this.createMarker(d);
                        ++n2;
                    }
                }

                private void createMarker(MarkerData data) throws CoreException {
                    IMarker marker = file.createMarker(OawMarkerManager.getMARKER_TYPE());
                    marker.setAttribute("message", (Object)data.message);
                    marker.setAttribute("severity", data.severity);
                    if (data.line != -1) {
                        marker.setAttribute("lineNumber", data.line);
                        marker.setAttribute("location", (Object)this.toLocationString(data));
                    } else if (data.start != -1 && data.end != -1) {
                        marker.setAttribute("charStart", data.start);
                        marker.setAttribute("charEnd", data.end);
                        marker.setAttribute("location", (Object)this.toLocationString(data));
                    }
                }

                private String toLocationString(MarkerData data) {
                    StringBuilder sb = new StringBuilder();
                    if (data.line != -1) {
                        sb.append("line: ");
                        sb.append(data.line);
                    }
                    if (data.start != -1 && data.end != -1) {
                        boolean theOnlyData;
                        boolean bl = theOnlyData = sb.length() == 0;
                        if (!theOnlyData) {
                            sb.append(" (");
                        }
                        sb.append(data.start);
                        sb.append(" .. ");
                        sb.append(data.end);
                        if (!theOnlyData) {
                            sb.append(")");
                        }
                    }
                    return sb.toString();
                }
            }, file.getWorkspace().getRuleFactory().markerRule((IResource)file), 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
        }
    }

    public static void deleteMarkers(final IResource file) {
        try {
            if (!file.exists()) {
                return;
            }
            file.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    file.deleteMarkers(OawMarkerManager.getMARKER_TYPE(), true, 2);
                }
            }, file.getWorkspace().getRuleFactory().markerRule(file), 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            Activator.log(ce.getStatus());
        }
    }

    private static class MarkerData {
        final String message;
        final int severity;
        final int start;
        final int end;
        final int line;

        MarkerData(String message, int severity, int start, int end) {
            this(message, severity, start, end, -1);
        }

        MarkerData(String message, int severity, int start, int end, int line) {
            this.message = message;
            this.severity = severity;
            this.start = start;
            this.end = end;
            this.line = line;
        }
    }
}

