/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfException;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtilPlugin;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.EmfMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.EmfMmUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.Messages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetamodelRegistry {
    public static final String MM_POINT_ID = "metamodelProvider";
    private static final MetamodelRegistry ourInstance = new MetamodelRegistry();
    private List<IMetamodelProvider> myMetamodelProviders;
    private final Map<String, IMetamodelDesc> myMetamodelDescs;

    private MetamodelRegistry() {
        this.myMetamodelProviders = MetamodelRegistry.getMetamodelProviders();
        if (this.myMetamodelProviders.isEmpty()) {
            Logger.getLogger().log(Logger.SEVERE, "No metamodel provider extensions, point=org.eclipse.m2m.qvt.oml.emf.util.metamodelProvider");
        }
        this.myMetamodelDescs = MetamodelRegistry.getMetamodelDescs(this.myMetamodelProviders);
    }

    public MetamodelRegistry(IMetamodelProvider metamodelProvider) {
        this.myMetamodelProviders = Collections.singletonList(metamodelProvider);
        this.myMetamodelDescs = new HashMap<String, IMetamodelDesc>(MetamodelRegistry.ourInstance.myMetamodelDescs);
        this.myMetamodelDescs.putAll(MetamodelRegistry.getMetamodelDescs(Collections.singletonList(metamodelProvider)));
    }

    public static MetamodelRegistry getInstance() {
        return ourInstance;
    }

    public String[] getMetamodelIds() {
        ArrayList<String> ids = new ArrayList<String>(this.myMetamodelDescs.size());
        ids.addAll(this.myMetamodelDescs.keySet());
        return ids.toArray(new String[ids.size()]);
    }

    public IMetamodelDesc getMetamodelDesc(String id) throws EmfException {
        return this.getMetamodelDesc(id, null);
    }

    /*
     * Unable to fully structure code
     */
    public IMetamodelDesc getMetamodelDesc(String id, ResourceSet resolutionRS) throws EmfException {
        block4: {
            desc = this.myMetamodelDescs.get(id);
            if (desc != null || id == null) break block4;
            for (IMetamodelDesc d : this.myMetamodelDescs.values()) {
                pack = d.getModel();
                if (pack == null) continue;
                if (!id.equals(pack.getNsURI())) ** GOTO lbl10
                desc = d;
                break;
lbl-1000:
                // 1 sources

                {
                    pack = pack.getESuperPackage();
lbl10:
                    // 2 sources

                    ** while (pack.getESuperPackage() != null)
                }
lbl11:
                // 1 sources

                if (!id.equals(pack.getNsURI())) continue;
                desc = new EmfMetamodelDesc(pack, pack.getNsURI(), d.getNamespace());
                this.myMetamodelDescs.put(id, desc);
                break;
            }
        }
        if (desc == null && id != null && (uri = URI.createURI((String)id)).isPlatform()) {
            desc = MetamodelRegistry.createUndeclaredMetamodel(uri, id, (ResourceSet)(resolutionRS != null ? resolutionRS : new ResourceSetImpl()));
        }
        if (desc == null) {
            throw new EmfException(NLS.bind((String)Messages.MetamodelRegistry_0, (Object)id, this.myMetamodelDescs.values()));
        }
        return desc;
    }

    public static final IMetamodelDesc createUndeclaredMetamodel(String id, ResourceSet rs) throws EmfException {
        URI uri = URI.createURI((String)id);
        return MetamodelRegistry.createUndeclaredMetamodel(uri, id, rs);
    }

    public static final IMetamodelDesc createUndeclaredMetamodel(URI uri, String id, ResourceSet rs) throws EmfException {
        try {
            int initialResourceCount = rs.getResources().size();
            Resource resource = rs.getResource(uri, true);
            if (resource != null) {
                EObject metamodel = (EObject)resource.getContents().get(0);
                if (metamodel instanceof EPackage) {
                    return new EmfMetamodelDesc((EPackage)metamodel, id, null);
                }
                int i = rs.getResources().size() - 1;
                while (i >= initialResourceCount) {
                    Resource loadedResource = (Resource)rs.getResources().get(i);
                    loadedResource.unload();
                    --i;
                }
            }
        }
        catch (Exception e) {
            throw new EmfException(e);
        }
        return null;
    }

    public IMetamodelDesc[] getMetamodelDesc(List<String> packageName) throws EmfException {
        UniqueEList metamodels = new UniqueEList(1);
        for (IMetamodelDesc d : this.myMetamodelDescs.values()) {
            EPackage lookupPackage;
            EPackage pack = d.getModel();
            if (pack == null || pack.getESuperPackage() != null || (lookupPackage = EmfMmUtil.lookupPackage(pack, packageName)) == null) continue;
            metamodels.add(lookupPackage);
        }
        if (metamodels.isEmpty()) {
            throw new EmfException(NLS.bind((String)Messages.MetamodelRegistry_0, packageName, this.myMetamodelDescs.values()));
        }
        IMetamodelDesc[] result = new IMetamodelDesc[metamodels.size()];
        int pos = 0;
        for (final EPackage nextMetamodel : metamodels) {
            result[pos++] = new IMetamodelDesc(){

                public String getId() {
                    return nextMetamodel.getNsURI();
                }

                public IStatus getLoadStatus() {
                    return Status.OK_STATUS;
                }

                public EPackage getModel() {
                    return nextMetamodel;
                }

                public String getNamespace() {
                    return null;
                }

                public boolean isLoaded() {
                    return true;
                }
            };
        }
        return result;
    }

    private static List<IMetamodelProvider> getMetamodelProviders() {
        ArrayList<IMetamodelProvider> metamodelProviders = new ArrayList<IMetamodelProvider>();
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EmfUtilPlugin.getDefault().getBundle().getSymbolicName(), MM_POINT_ID);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement extension = extensions[i];
            try {
                Object provider = extension.createExecutableExtension("class");
                if (provider instanceof IMetamodelProvider) {
                    metamodelProviders.add((IMetamodelProvider)provider);
                }
            }
            catch (Exception e) {
                Logger.getLogger().log(Logger.WARNING, "Failed to instantiate " + extension.getAttribute("class") + " from " + extension.getNamespaceIdentifier(), e);
            }
            ++i;
        }
        return metamodelProviders;
    }

    private static Map<String, IMetamodelDesc> getMetamodelDescs(List<IMetamodelProvider> providers) {
        HashMap<String, IMetamodelDesc> metamodelDescs = new HashMap<String, IMetamodelDesc>();
        for (IMetamodelProvider provider : providers) {
            IMetamodelDesc[] models;
            try {
                models = provider.getMetamodels();
            }
            catch (Exception e) {
                Logger.getLogger().log(Logger.SEVERE, "Failed to get metamodels from " + provider, e);
                continue;
            }
            int i = 0;
            while (i < models.length) {
                if (models[i].getId() != null) {
                    metamodelDescs.put(models[i].getId(), models[i]);
                }
                ++i;
            }
        }
        return metamodelDescs;
    }
}

