/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks;

import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.cst.LocalPropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ModulePropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.PatternPropertyExpCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.CSTHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.HyperlinkUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.IHyperlinkDetectorHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.MetamodelElementHyperlink;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.QvtFileHyperlink;
import org.eclipse.m2m.internal.qvt.oml.expressions.AssignExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.LocalProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.Property;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.FeatureCallExpCS;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.cst.VariableExpCS;
import org.eclipse.ocl.ecore.TupleType;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.utilities.ASTNode;

public class ObjectPropertyHyperlinkDetector
implements IHyperlinkDetectorHelper {
    public IHyperlink detectHyperlink(IHyperlinkDetectorHelper.IDetectionContext context) {
        CSTNode syntaxElement = context.getSyntaxElement();
        EStructuralFeature referredFeature = ObjectPropertyHyperlinkDetector.findDefinition(syntaxElement);
        if (referredFeature != null) {
            ModulePropertyCS propertyCS;
            Property prop = ObjectPropertyHyperlinkDetector.getASTProperty(referredFeature);
            if (prop != null && (propertyCS = (ModulePropertyCS)ASTBindingHelper.resolveCSTNode((ASTNode)prop, ModulePropertyCS.class)) != null) {
                CFile sourceFile = CSTHelper.getSourceFile((CSTNode)propertyCS);
                ModulePropertyCS destNodeCS = propertyCS.getSimpleNameCS() != null ? propertyCS.getSimpleNameCS() : propertyCS;
                IRegion destRegion = HyperlinkUtil.createRegion((CSTNode)destNodeCS);
                return new QvtFileHyperlink(HyperlinkUtil.createRegion(syntaxElement), sourceFile, destRegion, destRegion);
            }
            return new MetamodelElementHyperlink(HyperlinkUtil.createRegion(syntaxElement), (EModelElement)referredFeature);
        }
        return null;
    }

    public static EStructuralFeature findDefinition(CSTNode syntaxElement) {
        if (syntaxElement instanceof SimpleNameCS) {
            EStructuralFeature result = ObjectPropertyHyperlinkDetector.findDefinition((SimpleNameCS)syntaxElement);
            if (result instanceof TupleType) {
                return null;
            }
            return result;
        }
        return null;
    }

    public static Property getASTProperty(EStructuralFeature feature) {
        Property localProp;
        if (feature instanceof Property) {
            return (Property)feature;
        }
        EStructuralFeature originalFeature = feature;
        if (originalFeature.eContainer() instanceof Module && (localProp = QvtOperationalParserUtil.getLocalPropertyAST((EStructuralFeature)feature)) != null) {
            return localProp;
        }
        return null;
    }

    private static EStructuralFeature findDefinition(SimpleNameCS nameCS) {
        if (nameCS.eContainer() instanceof PatternPropertyExpCS) {
            AssignExp assignExp;
            PropertyCallExp pcall;
            ASTNode astNode = ASTBindingHelper.resolveASTNode((CSTNode)((PatternPropertyExpCS)nameCS.eContainer()));
            if (astNode instanceof AssignExp && (pcall = (PropertyCallExp)(assignExp = (AssignExp)astNode).getLeft()) instanceof PropertyCallExp) {
                return (EStructuralFeature)pcall.getReferredProperty();
            }
        } else if (nameCS.eContainer() instanceof FeatureCallExpCS) {
            FeatureCallExpCS featureCallExpCS = (FeatureCallExpCS)nameCS.eContainer();
            ASTNode featureASTNode = ASTBindingHelper.resolveASTNode((CSTNode)featureCallExpCS);
            if (featureASTNode instanceof PropertyCallExp) {
                PropertyCallExp propertyCallExp = (PropertyCallExp)featureASTNode;
                return (EStructuralFeature)propertyCallExp.getReferredProperty();
            }
        } else if (nameCS.eContainer() instanceof VariableExpCS) {
            ASTNode astVarExpNode = ASTBindingHelper.resolveASTNode((CSTNode)nameCS);
            if (astVarExpNode != null && astVarExpNode instanceof PropertyCallExp) {
                PropertyCallExp pcall = (PropertyCallExp)astVarExpNode;
                return (EStructuralFeature)pcall.getReferredProperty();
            }
        } else if (nameCS.eContainer() instanceof LocalPropertyCS) {
            LocalPropertyCS localPropertyCS = (LocalPropertyCS)nameCS.eContainer();
            return (EStructuralFeature)ASTBindingHelper.resolveASTNode((CSTNode)localPropertyCS, LocalProperty.class);
        }
        return null;
    }
}

