/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.binding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.IModuleSourceInfo;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.util.LineNumberProvider;
import org.eclipse.m2m.internal.qvt.oml.common.util.StringLineNumberProvider;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.utilities.ASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTBindingHelper {
    public static void createModuleSourceBinding(EObject target, String fileName, String contents) {
        target.eAdapters().add((Object)new ModuleSourceAdapter(fileName, contents));
    }

    public static IModuleSourceInfo getModuleSourceBinding(Module astModule) {
        return (IModuleSourceInfo)EcoreUtil.getExistingAdapter((Notifier)astModule, ModuleSourceAdapter.class);
    }

    public static void createModuleBinding(MappingModuleCS cstModule, Module astModule, EcoreEnvironment env, CFile moduleFile) {
        ModuleASTAdapter astAdapter = new ModuleASTAdapter((CSTNode)cstModule, astModule, env, moduleFile);
        astModule.eAdapters().add((Object)astAdapter);
        cstModule.eAdapters().add((Object)astAdapter);
    }

    public static CFile resolveModuleFile(EObject cstModule) {
        ModuleASTAdapter moduleASTAdapter = ASTBindingHelper.getModuleASTAdapter(cstModule);
        if (moduleASTAdapter != null) {
            return moduleASTAdapter.getModuleFile();
        }
        return null;
    }

    public static EcoreEnvironment resolveEnvironment(MappingModuleCS cstModule) {
        ModuleASTAdapter moduleASTAdapter = ASTBindingHelper.getModuleASTAdapter((EObject)cstModule);
        if (moduleASTAdapter != null) {
            return moduleASTAdapter.getEnvironment();
        }
        return null;
    }

    public static void createCST2ASTBinding(CSTNode cstNode, ASTNode astNode) {
        ASTBindingHelper.createCST2ASTBinding(cstNode, astNode, null);
    }

    public static void createCST2ASTBinding(CSTNode cstNode, ASTNode astNode, Environment env) {
        ASTAdapter astAdapter = new ASTAdapter(cstNode, astNode, (EcoreEnvironment)env);
        astNode.eAdapters().add((Object)astAdapter);
        cstNode.eAdapters().add((Object)astAdapter);
    }

    public static ASTNode resolveASTNode(CSTNode cstNode) {
        return ASTBindingHelper.resolveASTNode(cstNode, ASTNode.class);
    }

    public static <T extends ASTNode> T resolveASTNode(CSTNode cstNode, Class<T> type) {
        return ASTBindingHelper.firstASTNodeOfType(ASTBindingHelper.getASTBindings((EObject)cstNode), type);
    }

    public static final ASTNode resolveEnclosingASTNode(CSTNode cstNode) {
        while (cstNode != null) {
            ASTNode astNode = ASTBindingHelper.resolveASTNode(cstNode);
            if (astNode != null) {
                return astNode;
            }
            cstNode = (CSTNode)cstNode.eContainer();
        }
        return null;
    }

    public static <T extends CSTNode> T resolveCSTNode(ASTNode astNode, Class<T> cstType) {
        return ASTBindingHelper.firstCSTNodeOfType(ASTBindingHelper.getASTBindings((EObject)astNode), cstType);
    }

    public static CSTNode resolveCSTNode(ASTNode astNode) {
        return ASTBindingHelper.resolveCSTNode(astNode, CSTNode.class);
    }

    public static EcoreEnvironment resolveEnvironment(ASTNode astNode) {
        ASTNode processedNode = astNode;
        EcoreEnvironment env = ASTBindingHelper.localResolveEnvironment(processedNode);
        while (env == null && processedNode.eContainer() instanceof ASTNode) {
            processedNode = (ASTNode)processedNode.eContainer();
            env = ASTBindingHelper.localResolveEnvironment(processedNode);
        }
        return env;
    }

    private static EcoreEnvironment localResolveEnvironment(ASTNode astNode) {
        List<ASTAdapter> adapters = ASTBindingHelper.getASTBindings((EObject)astNode);
        for (ASTAdapter nextAdapter : adapters) {
            if (nextAdapter.getEnvironment() == null) continue;
            return nextAdapter.getEnvironment();
        }
        return null;
    }

    private static <T extends ASTNode> T firstASTNodeOfType(List<ASTAdapter> objects, Class<T> type) {
        for (ASTAdapter nextAST : objects) {
            if (!type.isInstance(nextAST.getASTNode())) continue;
            return (T)((ASTNode)type.cast(nextAST.getASTNode()));
        }
        return null;
    }

    private static <T extends CSTNode> T firstCSTNodeOfType(List<ASTAdapter> objects, Class<T> type) {
        for (ASTAdapter nextCST : objects) {
            if (!type.isInstance(nextCST.getCSTNode())) continue;
            return (T)((CSTNode)type.cast(nextCST.getCSTNode()));
        }
        return null;
    }

    private static ModuleASTAdapter getModuleASTAdapter(EObject target) {
        List<ModuleASTAdapter> adapters = ASTBindingHelper.getASTBindings(target, ModuleASTAdapter.class);
        if (!adapters.isEmpty()) {
            ModuleASTAdapter moduleAdapter = adapters.get(0);
            return moduleAdapter;
        }
        return null;
    }

    static List<ASTAdapter> getASTBindings(EObject target) {
        return ASTBindingHelper.getASTBindings(target, ASTAdapter.class);
    }

    static <T extends ASTAdapter> List<T> getASTBindings(EObject target, Class<T> adapterType) {
        List result = Collections.emptyList();
        for (Adapter nextAdapter : target.eAdapters()) {
            if (!adapterType.isInstance(nextAdapter)) continue;
            if (result.isEmpty()) {
                result = new ArrayList(3);
            }
            result.add((ASTAdapter)((Object)adapterType.cast(nextAdapter)));
        }
        return result;
    }

    private static class ASTAdapter
    extends AdapterImpl {
        private ASTNode fAstNode;
        private CSTNode fCstNode;
        private EcoreEnvironment fEnv;

        ASTAdapter(CSTNode cstNode, ASTNode astNode, EcoreEnvironment env) {
            if (astNode == null || cstNode == null) {
                throw new IllegalArgumentException();
            }
            this.fAstNode = astNode;
            this.fCstNode = cstNode;
            this.fEnv = env;
        }

        public ASTNode getASTNode() {
            return this.fAstNode;
        }

        public CSTNode getCSTNode() {
            return this.fCstNode;
        }

        public EcoreEnvironment getEnvironment() {
            return this.fEnv;
        }
    }

    private static class ModuleASTAdapter
    extends ASTAdapter {
        private CFile file;

        protected ModuleASTAdapter(CSTNode cstNode, ASTNode astNode, EcoreEnvironment env, CFile moduleFile) {
            super(cstNode, astNode, env);
            this.file = moduleFile;
        }

        public CFile getModuleFile() {
            return this.file;
        }
    }

    private static class ModuleSourceAdapter
    extends AdapterImpl
    implements IModuleSourceInfo {
        private String fFileName;
        private String fContents;
        private LineNumberProvider lineNumberProvider;

        protected ModuleSourceAdapter(String fileName, String contents) {
            if (fileName == null || contents == null) {
                throw new IllegalArgumentException();
            }
            this.fFileName = fileName;
            this.fContents = contents;
        }

        public String getFileName() {
            return this.fFileName;
        }

        public String getContents() {
            return this.fContents;
        }

        public LineNumberProvider getLineNumberProvider() {
            if (this.lineNumberProvider == null) {
                this.lineNumberProvider = new StringLineNumberProvider(this.fContents);
            }
            return this.lineNumberProvider;
        }

        public boolean isAdapterForType(Object type) {
            return type == ModuleSourceAdapter.class;
        }
    }
}

