/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.expressions.ExpressionsFactory;
import org.eclipse.m2m.internal.qvt.oml.expressions.ExpressionsPackage;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.impl.ModuleImpl;
import org.eclipse.m2m.internal.qvt.oml.library.IContext;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractContextualOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractQVTStdlib;
import org.eclipse.m2m.internal.qvt.oml.stdlib.ElementOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.IntegerOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.ModelOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.OclAnyOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.RealOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.StdlibModuleOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.StringOperations;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.utilities.TypedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalStdLibrary
extends AbstractQVTStdlib {
    public static final String OUT_PRINT_WRITER = "@out_print_writer";
    public static final String QVT_STDLIB_MODULE_NAME = "Stdlib";
    public static final QvtOperationalStdLibrary INSTANCE = QvtOperationalStdLibrary.createLibrary();
    private EClassifier ELEMENT;
    private EClass MODEL;
    private final Module fStdlibModule = ExpressionsFactory.eINSTANCE.createModule();
    private final QvtOperationalEnv fEnv;
    private final Map<String, EClassifier> fTypeAliasMap;
    private final ModelOperations modelOperations;
    private final OclAnyOperations anyOperations;

    private QvtOperationalStdLibrary() {
        this.fStdlibModule.setName(QVT_STDLIB_MODULE_NAME);
        this.fEnv = QvtOperationalEnvFactory.INSTANCE.createModuleEnvironment(this.fStdlibModule);
        if (this.fEnv.getInternalParent() == null) {
            Variable variable = org.eclipse.ocl.expressions.ExpressionsFactory.eINSTANCE.createVariable();
            variable.setName(String.valueOf(this.fStdlibModule.getName()) + ".this");
            variable.setType((Object)this.fStdlibModule);
            this.fEnv.addElement(variable.getName(), variable, false);
        }
        this.ELEMENT = this.createClass("Element", true);
        this.MODEL = this.createClass("Model", true);
        this.fTypeAliasMap = QvtOperationalStdLibrary.createTypeAliasMap(this.fEnv);
        ((ModuleImpl)this.fStdlibModule).freeze();
        this.modelOperations = new ModelOperations(this);
        this.anyOperations = new OclAnyOperations(this);
    }

    protected void defineStandardOperations() {
        this.define(new StringOperations(this));
        this.define(this.modelOperations);
        this.define(this.anyOperations);
        this.define(new ElementOperations(this));
        this.define(new StdlibModuleOperations(this));
        this.define(new IntegerOperations(this));
        this.define(new RealOperations(this));
    }

    @Override
    public EcoreEnvironment getEnvironment() {
        return this.fEnv;
    }

    public List<EOperation> getOperations(EClassifier classifier) {
        List<EOperation> result = this.fEnv.getAdditionalOperations(classifier);
        return result != null ? result : Collections.emptyList();
    }

    public void importTo(QvtOperationalEnv env) {
        env.addSibling(this.fEnv);
    }

    public Module getStdLibModule() {
        return this.fStdlibModule;
    }

    public boolean isStdLibClassifier(EClassifier classifier) {
        return classifier == this.getElementType() || classifier == this.fStdlibModule.getEClassifier(classifier.getName());
    }

    public EClass getModelClass() {
        return this.MODEL;
    }

    @Override
    public EClass getModuleType() {
        return ExpressionsPackage.eINSTANCE.getModule();
    }

    @Override
    public EClassifier getElementType() {
        return this.ELEMENT;
    }

    @Override
    public Module getLibaryModule() {
        return this.fStdlibModule;
    }

    public EClassifier lookupClassifier(List<String> nameElements) {
        int size = nameElements.size();
        if (size == 0 || size > 2) {
            return null;
        }
        if (size == 2 && !QVT_STDLIB_MODULE_NAME.equals(nameElements.get(0))) {
            return null;
        }
        String typeName = nameElements.get(size - 1);
        EClassifier aliasedType = this.getTypeAlias(typeName);
        return aliasedType != null ? aliasedType : this.fStdlibModule.getEClassifier(typeName);
    }

    public EClassifier lookupPackage(List<String> nameElements) {
        if (nameElements.size() == 1 && QVT_STDLIB_MODULE_NAME.equals(nameElements.get(0))) {
            return this.fStdlibModule;
        }
        return null;
    }

    public EOperation resolveGenericOperationsIfNeeded(QvtOperationalEnv env, EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) {
        if ("allInstances".equals(name) && args.size() == 1) {
            EClassifier resultType = (EClassifier)args.get(0).getType();
            if (resultType instanceof TypeType) {
                TypeType typeType = (TypeType)resultType;
                resultType = (EClassifier)typeType.getReferredType();
            }
            if (resultType != null) {
                return (EOperation)env.getTypeResolver().resolveAdditionalOperation((Object)owner, (Object)this.anyOperations.defineNonStdAllInstances(env, resultType));
            }
        } else if ("objectsOfType".equals(name) && args.size() == 1) {
            EClassifier resultType = (EClassifier)args.get(0).getType();
            if (resultType instanceof TypeType) {
                TypeType typeType = (TypeType)resultType;
                resultType = (EClassifier)typeType.getReferredType();
            }
            if (resultType != null) {
                return (EOperation)env.getTypeResolver().resolveAdditionalOperation((Object)owner, (Object)this.modelOperations.defineGenericObjectsOfType(env, resultType));
            }
        }
        return null;
    }

    public static PrintWriter getLogger(IContext context) {
        Object loggerObject = context.get(OUT_PRINT_WRITER);
        if (!(loggerObject instanceof PrintWriter)) {
            return null;
        }
        return (PrintWriter)loggerObject;
    }

    private void define(AbstractContextualOperations typeOperations) {
        typeOperations.define(this.fEnv);
    }

    private EClass createClass(String name, boolean isAbstract) {
        assert (this.fStdlibModule != null);
        assert (name != null);
        EClass result = EcoreFactory.eINSTANCE.createEClass();
        result.setName(name);
        result.setAbstract(true);
        this.fStdlibModule.getEClassifiers().add((Object)result);
        return result;
    }

    private static QvtOperationalStdLibrary createLibrary() {
        QvtOperationalStdLibrary lib = new QvtOperationalStdLibrary();
        lib.defineStandardOperations();
        return lib;
    }

    private EClassifier getTypeAlias(String typeName) {
        return this.fTypeAliasMap.get(typeName);
    }

    private static Map<String, EClassifier> createTypeAliasMap(QvtOperationalEnv env) {
        HashMap<String, EClassifier> result = new HashMap<String, EClassifier>();
        result.put("Any", (EClassifier)env.getOCLStandardLibrary().getOclAny());
        result.put("Void", (EClassifier)env.getOCLStandardLibrary().getOclVoid());
        return result;
    }
}

