/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.newfile.example;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.wizards.newfile.example.IAcceleoExampleStrategy;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoExampleStrategyUtils {
    private static List<IAcceleoExampleStrategy> exampleStrategies;

    private AcceleoExampleStrategyUtils() {
    }

    public static List<IAcceleoExampleStrategy> getExampleStrategies() {
        if (exampleStrategies == null) {
            exampleStrategies = new ArrayList<IAcceleoExampleStrategy>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.acceleo.ide.ui.example");
            if (extensionPoint != null && extensionPoint.getExtensions().length > 0) {
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    IConfigurationElement[] members = extension.getConfigurationElements();
                    int j = 0;
                    while (j < members.length) {
                        IConfigurationElement member = members[j];
                        String strategyClass = member.getAttribute("class");
                        if (strategyClass != null) {
                            Status status;
                            try {
                                Bundle bundle = Platform.getBundle((String)member.getNamespaceIdentifier());
                                Class c = bundle.loadClass(strategyClass);
                                IAcceleoExampleStrategy exampleStrategy = (IAcceleoExampleStrategy)c.newInstance();
                                exampleStrategies.add(exampleStrategy);
                            }
                            catch (ClassNotFoundException e) {
                                status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
                                AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
                            }
                            catch (InstantiationException e) {
                                status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
                                AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
                            }
                            catch (IllegalAccessException e) {
                                status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
                                AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
                            }
                        } else {
                            Status status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, AcceleoUIMessages.getString("AcceleoNewTemplatesWizard.MissingStrategyClass", "org.eclipse.acceleo.ide.ui.example"), null);
                            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return exampleStrategies;
    }
}

