/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.cst;

import org.eclipse.acceleo.common.IAcceleoConstants;
import org.eclipse.acceleo.internal.parser.AcceleoParserMessages;
import org.eclipse.acceleo.internal.parser.IAcceleoParserProblemsConstants;
import org.eclipse.acceleo.internal.parser.cst.CSTParser;
import org.eclipse.acceleo.internal.parser.cst.utils.ISequence;
import org.eclipse.acceleo.internal.parser.cst.utils.ParserUtils;
import org.eclipse.acceleo.internal.parser.cst.utils.Region;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;
import org.eclipse.acceleo.internal.parser.cst.utils.SequenceBlock;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.eclipse.acceleo.parser.cst.Block;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.Comment;
import org.eclipse.acceleo.parser.cst.CstFactory;
import org.eclipse.acceleo.parser.cst.CstPackage;
import org.eclipse.acceleo.parser.cst.FileBlock;
import org.eclipse.acceleo.parser.cst.ForBlock;
import org.eclipse.acceleo.parser.cst.IfBlock;
import org.eclipse.acceleo.parser.cst.LetBlock;
import org.eclipse.acceleo.parser.cst.ModelExpression;
import org.eclipse.acceleo.parser.cst.OpenModeKind;
import org.eclipse.acceleo.parser.cst.ProtectedAreaBlock;
import org.eclipse.acceleo.parser.cst.TextExpression;
import org.eclipse.acceleo.parser.cst.TraceBlock;
import org.eclipse.acceleo.parser.cst.Variable;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CSTParserBlock {
    private static final String INVALID_BLOCK_HEADER = "CSTParserBlock.InvalidBlockHeader";
    private static final String INVALID_BLOCK = "CSTParser.InvalidBlock";
    protected CSTParser pAcceleo;
    protected SequenceBlock pTrace;
    protected SequenceBlock pFile;
    protected SequenceBlock pFor;
    protected SequenceBlock pIf;
    protected SequenceBlock pElseIf;
    protected Sequence pElse;
    protected SequenceBlock pLet;
    protected SequenceBlock pElseLet;
    protected SequenceBlock pProtectedArea;
    protected SequenceBlock pExpression;
    protected AcceleoSourceBuffer source;

    public CSTParserBlock(CSTParser pAcceleo) {
        this.pAcceleo = pAcceleo;
        this.source = pAcceleo.source;
        this.pTrace = ParserUtils.createAcceleoSequenceBlock(false, "trace", false, new SequenceBlock[]{pAcceleo.pLiteral}, new SequenceBlock[]{pAcceleo.pComment});
        this.pFile = ParserUtils.createAcceleoSequenceBlock(false, "file", true, new SequenceBlock[]{pAcceleo.pLiteral}, new SequenceBlock[]{pAcceleo.pComment});
        this.pFor = ParserUtils.createAcceleoSequenceBlock(false, "for", true, new SequenceBlock[]{pAcceleo.pLiteral, pAcceleo.pParenthesis}, new SequenceBlock[]{pAcceleo.pComment});
        this.pIf = ParserUtils.createAcceleoSequenceBlock(false, "if", true, new SequenceBlock[]{pAcceleo.pLiteral}, new SequenceBlock[]{pAcceleo.pComment});
        Sequence pElseIfBeginHeader = new Sequence("[", "elseif");
        Sequence pElseIfEndHeader = new Sequence("]");
        this.pElseIf = new SequenceBlock(pElseIfBeginHeader, pElseIfEndHeader, null, false, new SequenceBlock[]{pAcceleo.pLiteral});
        this.pElse = new Sequence("[", "else", "]");
        this.pLet = ParserUtils.createAcceleoSequenceBlock(false, "let", true, new SequenceBlock[]{pAcceleo.pLiteral}, new SequenceBlock[]{pAcceleo.pComment});
        Sequence pElseLetBeginHeader = new Sequence("[", "elselet");
        Sequence pElseLetEndHeader = new Sequence("]");
        this.pElseLet = new SequenceBlock(pElseLetBeginHeader, pElseLetEndHeader, null, false, new SequenceBlock[]{pAcceleo.pLiteral});
        this.pProtectedArea = ParserUtils.createAcceleoSequenceBlock(false, "protected", false, new SequenceBlock[]{pAcceleo.pLiteral}, new SequenceBlock[]{pAcceleo.pComment});
        Sequence pBegin = new Sequence("[");
        Sequence pEnd = new Sequence("]");
        SequenceBlock pBeginEnd = new SequenceBlock(pBegin, pEnd, null, true, new SequenceBlock[]{pAcceleo.pLiteral});
        this.pExpression = new SequenceBlock(new Sequence("["), new Sequence(IAcceleoConstants.INVOCATION_END), null, false, new SequenceBlock[]{pAcceleo.pLiteral, pBeginEnd});
    }

    private void setPositions(CSTNode eCSTNode, int posBegin, int posEnd) {
        this.pAcceleo.setPositions(eCSTNode, posBegin, posEnd);
    }

    public void parse(int posBegin, int posEnd, Block eBlock) {
        ISequence[] pBlockElements = new SequenceBlock[]{this.pAcceleo.pComment, this.pFile, this.pFor, this.pIf, this.pLet, this.pTrace, this.pProtectedArea, this.pExpression};
        int currentPosBegin = posBegin;
        Region[] positions = Region.createPositions(pBlockElements.length);
        while (currentPosBegin > -1 && currentPosBegin < posEnd) {
            int i = ParserUtils.getNextSequence(this.source.getBuffer(), currentPosBegin, posEnd, pBlockElements, positions);
            if (i == -1) {
                this.parseText(currentPosBegin, posEnd, eBlock);
                currentPosBegin = -1;
                continue;
            }
            ISequence pBlockElement = pBlockElements[i];
            Region bH = positions[i];
            this.parseText(currentPosBegin, bH.b(), eBlock);
            currentPosBegin = pBlockElement == this.pAcceleo.pComment ? this.parseCommentEnding(bH, posEnd, eBlock) : (pBlockElement == this.pFile ? this.parseFileEnding(bH, posEnd, eBlock) : (pBlockElement == this.pFor ? this.parseForEnding(bH, posEnd, eBlock) : (pBlockElement == this.pIf ? this.parseIfEnding(bH, posEnd, eBlock) : (pBlockElement == this.pLet ? this.parseLetEnding(bH, posEnd, eBlock) : (pBlockElement == this.pTrace ? this.parseTraceEnding(bH, posEnd, eBlock) : (pBlockElement == this.pProtectedArea ? this.parseProtectedAreaEnding(bH, posEnd, eBlock) : (pBlockElement == this.pExpression ? this.parseExpressionEnding(bH, posEnd, eBlock) : -1)))))));
        }
    }

    private int parseCommentEnding(Region beginHeader, int posEnd, Block eBlock) {
        int posBegin;
        Region eH = this.pAcceleo.pComment.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, posEnd);
        if (eH.b() == -1) {
            this.log(AcceleoParserMessages.getString(INVALID_BLOCK_HEADER, "comment"), beginHeader.b(), beginHeader.e());
            posBegin = -1;
        } else if (eH.getSequence() == this.pAcceleo.pComment.getEndHeaderBody()) {
            Comment eComment = CstFactory.eINSTANCE.createComment();
            this.setPositions(eComment, beginHeader.b(), eH.e());
            eComment.setBody(this.source.getBuffer().substring(beginHeader.e(), eH.b()));
            eBlock.getBody().add((Object)eComment);
            posBegin = eH.e();
        } else {
            Region eB = this.pAcceleo.pComment.searchEndBodyAtEndHeader(this.source.getBuffer(), eH, posEnd);
            if (eB.b() == -1) {
                this.log(AcceleoParserMessages.getString(INVALID_BLOCK, "comment"), beginHeader.b(), beginHeader.e());
                posBegin = -1;
            } else {
                Comment eComment = CstFactory.eINSTANCE.createComment();
                this.setPositions(eComment, beginHeader.b(), eB.e());
                eComment.setBody(this.source.getBuffer().substring(eH.e(), eB.b()));
                eBlock.getBody().add((Object)eComment);
                posBegin = eB.e();
            }
        }
        return posBegin;
    }

    private int parseFileEnding(Region beginHeader, int posEnd, Block eBlock) {
        int posBegin;
        Region eH = this.pFile.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, posEnd);
        if (eH.b() == -1) {
            this.log(AcceleoParserMessages.getString(INVALID_BLOCK_HEADER, "file"), beginHeader.b(), beginHeader.e());
            posBegin = -1;
        } else if (eH.getSequence() == this.pFile.getEndHeaderBody()) {
            posBegin = eH.e();
            FileBlock eFile = CstFactory.eINSTANCE.createFileBlock();
            this.setPositions(eFile, beginHeader.b(), eH.e());
            eBlock.getBody().add((Object)eFile);
            this.parseFileHeader(beginHeader.e(), eH.b(), eFile);
        } else {
            Region eB = this.pFile.searchEndBodyAtEndHeader(this.source.getBuffer(), eH, posEnd);
            if (eB.b() == -1) {
                this.log(AcceleoParserMessages.getString(INVALID_BLOCK, "file"), beginHeader.b(), beginHeader.e());
                posBegin = -1;
            } else {
                posBegin = eB.e();
                FileBlock eFile = CstFactory.eINSTANCE.createFileBlock();
                this.setPositions(eFile, beginHeader.b(), eB.e());
                eBlock.getBody().add((Object)eFile);
                this.parseFileHeader(beginHeader.e(), eH.b(), eFile);
                this.parseFileBody(eH.e(), eB.b(), eFile);
            }
        }
        return posBegin;
    }

    public void parseFileHeader(int posBegin, int posEnd, FileBlock eFile) {
        if (ParserUtils.shiftKeyword(this.source.getBuffer(), posBegin, posEnd, "(", false) == posBegin) {
            this.log(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_ARE_REQUIRED, posBegin, posEnd);
        } else {
            Region bH = this.pAcceleo.pParenthesis.searchBeginHeader(this.source.getBuffer(), posBegin, posEnd);
            Region eH = this.pAcceleo.pParenthesis.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bH, posEnd);
            if (eH.b() == -1) {
                this.log(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_NOT_TERMINATED, bH.b(), bH.e());
            } else {
                this.parseFileHeaderParenthesis(bH, eH, eFile);
            }
        }
    }

    private void parseFileHeaderParenthesis(Region bH, Region eH, FileBlock eFile) {
        int b = bH.e();
        Region comma = this.pAcceleo.pComma.search(this.source.getBuffer(), b, eH.b(), null, new SequenceBlock[]{this.pAcceleo.pParenthesis, this.pAcceleo.pComment, this.pAcceleo.pLiteral});
        int e = comma.b() == -1 ? eH.b() : comma.b();
        ModelExpression eFileURL = CstFactory.eINSTANCE.createModelExpression();
        this.setPositions(eFileURL, b, e);
        eFile.setFileUrl(eFileURL);
        this.parseExpressionHeader(b, e, eFileURL);
        if (comma.b() != -1) {
            boolean openModeFound = false;
            b = ParserUtils.shiftKeyword(this.source.getBuffer(), comma.e(), eH.b(), "true", true);
            if (b != comma.e()) {
                eFile.setOpenMode(OpenModeKind.APPEND);
                openModeFound = true;
            } else {
                b = ParserUtils.shiftKeyword(this.source.getBuffer(), comma.e(), eH.b(), "false", true);
                if (b != comma.e()) {
                    eFile.setOpenMode(OpenModeKind.OVER_WRITE);
                    openModeFound = true;
                }
            }
            if (!openModeFound) {
                this.log(AcceleoParserMessages.getString("CSTParserBlock.MissingFileMode"), comma.b(), eH.b());
            } else {
                int eComma = ParserUtils.shiftKeyword(this.source.getBuffer(), b, eH.b(), ",", false);
                if (eComma != b) {
                    b = eComma;
                    ModelExpression eUniqueId = CstFactory.eINSTANCE.createModelExpression();
                    this.setPositions(eUniqueId, b, eH.b());
                    eFile.setUniqId(eUniqueId);
                    this.parseExpressionHeader(b, eH.b(), eUniqueId);
                } else if (this.source.getBuffer().substring(b, eH.b()).trim().length() > 0) {
                    this.log(AcceleoParserMessages.getString("Parser.MissingCharacter", ","), b, eH.b());
                }
            }
        } else {
            this.log(AcceleoParserMessages.getString("Parser.MissingCharacter", ","), eH.b(), eH.b());
        }
    }

    public void parseFileBody(int posBegin, int posEnd, FileBlock eFile) {
        this.parse(posBegin, posEnd, eFile);
    }

    private int parseForEnding(Region beginHeader, int posEnd, Block eBlock) {
        int posBegin;
        Region eH = this.pFor.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, posEnd);
        if (eH.b() == -1) {
            this.log(AcceleoParserMessages.getString(INVALID_BLOCK_HEADER, "for"), beginHeader.b(), beginHeader.e());
            posBegin = -1;
        } else if (eH.getSequence() == this.pFor.getEndHeaderBody()) {
            posBegin = eH.e();
            ForBlock eFor = CstFactory.eINSTANCE.createForBlock();
            this.setPositions(eFor, beginHeader.b(), eH.e());
            eBlock.getBody().add((Object)eFor);
            this.parseForHeader(beginHeader.e(), eH.b(), eFor);
        } else {
            Region eB = this.pFor.searchEndBodyAtEndHeader(this.source.getBuffer(), eH, posEnd);
            if (eB.b() == -1) {
                this.log(AcceleoParserMessages.getString(INVALID_BLOCK, "for"), beginHeader.b(), beginHeader.e());
                posBegin = -1;
            } else {
                posBegin = eB.e();
                ForBlock eFor = CstFactory.eINSTANCE.createForBlock();
                this.setPositions(eFor, beginHeader.b(), eB.e());
                eBlock.getBody().add((Object)eFor);
                this.parseForHeader(beginHeader.e(), eH.b(), eFor);
                this.parseForBody(eH.e(), eB.b(), eFor);
            }
        }
        return posBegin;
    }

    public void parseForHeader(int posBegin, int posEnd, ForBlock eFor) {
        if (ParserUtils.shiftKeyword(this.source.getBuffer(), posBegin, posEnd, "(", false) == posBegin) {
            this.log(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_ARE_REQUIRED, posBegin, posEnd);
        } else {
            Region bH = this.pAcceleo.pParenthesis.searchBeginHeader(this.source.getBuffer(), posBegin, posEnd);
            Region eH = this.pAcceleo.pParenthesis.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bH, posEnd);
            if (eH.b() == -1) {
                this.log(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_NOT_TERMINATED, bH.b(), bH.e());
            } else {
                int b = bH.e();
                int e = eH.b();
                Region pipe = this.pAcceleo.pPipe.search(this.source.getBuffer(), b, eH.b());
                if (pipe.b() != -1) {
                    Variable eVariable = this.pAcceleo.createVariable(b, pipe.b(), this.pAcceleo.getModule(eFor));
                    eFor.setLoopVariable(eVariable);
                    b = pipe.e();
                }
                ModelExpression eIterSet = CstFactory.eINSTANCE.createModelExpression();
                this.setPositions(eIterSet, b, e);
                eFor.setIterSet(eIterSet);
                this.parseExpressionHeader(b, e, eIterSet);
                int currentPosBegin = eH.e();
                currentPosBegin = this.shiftPrefixedOCLExpression(currentPosBegin, posEnd, "before", true, eFor, (EStructuralFeature)CstPackage.eINSTANCE.getForBlock_Before());
                currentPosBegin = this.shiftPrefixedOCLExpression(currentPosBegin, posEnd, "separator", true, eFor, (EStructuralFeature)CstPackage.eINSTANCE.getForBlock_Each());
                currentPosBegin = this.shiftPrefixedOCLExpression(currentPosBegin, posEnd, "after", true, eFor, (EStructuralFeature)CstPackage.eINSTANCE.getForBlock_After());
                currentPosBegin = this.shiftPrefixedOCLExpression(currentPosBegin, posEnd, "?", false, eFor, (EStructuralFeature)CstPackage.eINSTANCE.getForBlock_Guard());
                currentPosBegin = this.pAcceleo.shiftInitSectionBody(currentPosBegin, posEnd, eFor);
                if (this.source.getBuffer().substring(currentPosBegin, posEnd).trim().length() > 0) {
                    this.log(IAcceleoParserProblemsConstants.SYNTAX_TEXT_NOT_VALID, currentPosBegin, posEnd);
                }
            }
        }
    }

    private int shiftPrefixedOCLExpression(int posBegin, int posEnd, String prefix, boolean wholeWord, CSTNode eCSTNode, EStructuralFeature eStructuralFeature) {
        int currentPos = posBegin;
        int b = ParserUtils.shiftKeyword(this.source.getBuffer(), currentPos, posEnd, prefix, wholeWord);
        if (b != currentPos) {
            currentPos = b;
            if (ParserUtils.shiftKeyword(this.source.getBuffer(), currentPos, posEnd, "(", false) == currentPos) {
                this.log(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_ARE_REQUIRED, currentPos, posEnd);
                currentPos = posEnd;
            } else {
                Region bHParenthesis = this.pAcceleo.pParenthesis.searchBeginHeader(this.source.getBuffer(), currentPos, posEnd);
                Region eHParenthesis = this.pAcceleo.pParenthesis.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bHParenthesis, posEnd);
                if (eHParenthesis.b() == -1) {
                    this.log(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_NOT_TERMINATED, bHParenthesis.b(), bHParenthesis.e());
                    currentPos = posEnd;
                } else {
                    ModelExpression eModelExpression = CstFactory.eINSTANCE.createModelExpression();
                    this.setPositions(eModelExpression, bHParenthesis.e(), eHParenthesis.b());
                    eCSTNode.eSet(eStructuralFeature, eModelExpression);
                    this.parseExpressionHeader(bHParenthesis.e(), eHParenthesis.b(), eModelExpression);
                    currentPos = eHParenthesis.e();
                }
            }
        }
        return currentPos;
    }

    public void parseForBody(int posBegin, int posEnd, ForBlock eFor) {
        this.parse(posBegin, posEnd, eFor);
    }

    private int parseIfEnding(Region beginHeader, int posEnd, Block eBlock) {
        int posBegin;
        Region eH = this.pIf.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, posEnd);
        if (eH.b() == -1) {
            this.log(AcceleoParserMessages.getString(INVALID_BLOCK_HEADER, "if"), beginHeader.b(), beginHeader.e());
            posBegin = -1;
        } else if (eH.getSequence() == this.pIf.getEndHeaderBody()) {
            posBegin = eH.e();
            IfBlock eIf = CstFactory.eINSTANCE.createIfBlock();
            this.setPositions(eIf, beginHeader.b(), eH.e());
            eBlock.getBody().add((Object)eIf);
            this.parseIfHeader(beginHeader.e(), eH.b(), eIf);
        } else {
            Region eB = this.pIf.searchEndBodyAtEndHeader(this.source.getBuffer(), eH, posEnd);
            if (eB.b() == -1) {
                this.log(AcceleoParserMessages.getString(INVALID_BLOCK, "if"), beginHeader.b(), beginHeader.e());
                posBegin = -1;
            } else {
                posBegin = eB.e();
                IfBlock eIf = CstFactory.eINSTANCE.createIfBlock();
                this.setPositions(eIf, beginHeader.b(), eB.e());
                eBlock.getBody().add((Object)eIf);
                this.parseIfHeader(beginHeader.e(), eH.b(), eIf);
                this.parseIfBody(eH.e(), eB.b(), eIf);
            }
        }
        return posBegin;
    }

    public void parseIfHeader(int posBegin, int posEnd, IfBlock eIf) {
        ModelExpression eModelExpression = CstFactory.eINSTANCE.createModelExpression();
        this.setPositions(eModelExpression, posBegin, posEnd);
        eIf.setIfExpr(eModelExpression);
        this.parseExpressionHeader(posBegin, posEnd, eModelExpression);
    }

    public void parseIfBody(int posBegin, int posEnd, IfBlock eIf) {
        ISequence[] pElements = new ISequence[]{this.pElseIf, this.pElse};
        SequenceBlock[] pInhibs = new SequenceBlock[]{this.pAcceleo.pComment, this.pIf};
        Region[] pElementsPositions = Region.createPositions(pElements.length);
        Region[] pInhibsPositions = Region.createPositions(pInhibs.length);
        int i = ParserUtils.getNextSequence(this.source.getBuffer(), posBegin, posEnd, pElements, pElementsPositions, pInhibs, pInhibsPositions);
        int eThen = i == -1 ? posEnd : pElementsPositions[i].b();
        this.parse(posBegin, eThen, eIf);
        while (i != -1) {
            ISequence pElement = pElements[i];
            if (pElement == this.pElse) {
                Block eElse = CstFactory.eINSTANCE.createBlock();
                this.setPositions(eElse, pElementsPositions[i].b(), posEnd);
                eIf.setElse(eElse);
                this.parse(pElementsPositions[i].e(), posEnd, eElse);
                i = -1;
                continue;
            }
            if (pElement == this.pElseIf) {
                Region eH = this.pElseIf.searchEndHeaderAtBeginHeader(this.source.getBuffer(), pElementsPositions[i], posEnd);
                if (eH.b() == -1) {
                    this.log(AcceleoParserMessages.getString(INVALID_BLOCK_HEADER, "elseif"), pElementsPositions[i].b(), pElementsPositions[i].e());
                    i = -1;
                    continue;
                }
                int bElseIf = pElementsPositions[i].b();
                IfBlock eElseIfBlock = CstFactory.eINSTANCE.createIfBlock();
                eIf.getElseIf().add((Object)eElseIfBlock);
                this.parseIfHeader(pElementsPositions[i].e(), eH.b(), eElseIfBlock);
                i = ParserUtils.getNextSequence(this.source.getBuffer(), eH.e(), posEnd, pElements, pElementsPositions, pInhibs, pInhibsPositions);
                int eElseIf = i == -1 ? posEnd : pElementsPositions[i].b();
                this.setPositions(eElseIfBlock, bElseIf, eElseIf);
                this.parseIfBody(eH.e(), eElseIf, eElseIfBlock);
                continue;
            }
            i = -1;
        }
    }

    private int parseLetEnding(Region beginHeader, int posEnd, Block eBlock) {
        int posBegin;
        Region eH = this.pLet.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, posEnd);
        if (eH.b() == -1) {
            this.log(AcceleoParserMessages.getString(INVALID_BLOCK_HEADER, "let"), beginHeader.b(), beginHeader.e());
            posBegin = -1;
        } else if (eH.getSequence() == this.pLet.getEndHeaderBody()) {
            posBegin = eH.e();
            LetBlock eLet = CstFactory.eINSTANCE.createLetBlock();
            this.setPositions(eLet, beginHeader.b(), eH.e());
            eBlock.getBody().add((Object)eLet);
            this.parseLetHeader(beginHeader.e(), eH.b(), eLet);
        } else {
            Region eB = this.pLet.searchEndBodyAtEndHeader(this.source.getBuffer(), eH, posEnd);
            if (eB.b() == -1) {
                this.log(AcceleoParserMessages.getString(INVALID_BLOCK, "let"), beginHeader.b(), beginHeader.e());
                posBegin = -1;
            } else {
                posBegin = eB.e();
                LetBlock eLet = CstFactory.eINSTANCE.createLetBlock();
                this.setPositions(eLet, beginHeader.b(), eB.e());
                eBlock.getBody().add((Object)eLet);
                this.parseLetHeader(beginHeader.e(), eH.b(), eLet);
                this.parseLetBody(eH.e(), eB.b(), eLet);
            }
        }
        return posBegin;
    }

    public void parseLetHeader(int posBegin, int posEnd, LetBlock eLet) {
        Variable eVariable = this.pAcceleo.createVariable(posBegin, posEnd, this.pAcceleo.getModule(eLet));
        if (eVariable != null) {
            eLet.setLetVariable(eVariable);
        }
    }

    public void parseLetBody(int posBegin, int posEnd, LetBlock eLet) {
        ISequence[] pElements = new ISequence[]{this.pElseLet, this.pElse};
        SequenceBlock[] pInhibs = new SequenceBlock[]{this.pAcceleo.pComment, this.pLet};
        Region[] pElementsPositions = Region.createPositions(pElements.length);
        Region[] pInhibsPositions = Region.createPositions(pInhibs.length);
        int i = ParserUtils.getNextSequence(this.source.getBuffer(), posBegin, posEnd, pElements, pElementsPositions, pInhibs, pInhibsPositions);
        int eThen = i == -1 ? posEnd : pElementsPositions[i].b();
        this.parse(posBegin, eThen, eLet);
        while (i != -1) {
            ISequence pElement = pElements[i];
            if (pElement == this.pElse) {
                Block eElse = CstFactory.eINSTANCE.createBlock();
                this.setPositions(eElse, pElementsPositions[i].b(), posEnd);
                eLet.setElse(eElse);
                this.parse(pElementsPositions[i].e(), posEnd, eElse);
                i = -1;
                continue;
            }
            if (pElement == this.pElseLet) {
                Region eH = this.pElseLet.searchEndHeaderAtBeginHeader(this.source.getBuffer(), pElementsPositions[i], posEnd);
                if (eH.b() == -1) {
                    this.log(AcceleoParserMessages.getString(INVALID_BLOCK_HEADER, "elselet"), pElementsPositions[i].b(), pElementsPositions[i].e());
                    i = -1;
                    continue;
                }
                int bElseLet = pElementsPositions[i].b();
                LetBlock eElseLetBlock = CstFactory.eINSTANCE.createLetBlock();
                eLet.getElseLet().add((Object)eElseLetBlock);
                this.parseLetHeader(pElementsPositions[i].e(), eH.b(), eElseLetBlock);
                i = ParserUtils.getNextSequence(this.source.getBuffer(), eH.e(), posEnd, pElements, pElementsPositions, pInhibs, pInhibsPositions);
                int eElseLet = i == -1 ? posEnd : pElementsPositions[i].b();
                this.setPositions(eElseLetBlock, bElseLet, eElseLet);
                this.parseLetBody(eH.e(), eElseLet, eElseLetBlock);
                continue;
            }
            i = -1;
        }
    }

    private int parseTraceEnding(Region beginHeader, int posEnd, Block eBlock) {
        int posBegin;
        Region eH = this.pTrace.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, posEnd);
        if (eH.b() == -1) {
            this.log(AcceleoParserMessages.getString(INVALID_BLOCK_HEADER, "trace"), beginHeader.b(), beginHeader.e());
            posBegin = -1;
        } else if (eH.getSequence() == this.pTrace.getEndHeaderBody()) {
            posBegin = eH.e();
            TraceBlock eTrace = CstFactory.eINSTANCE.createTraceBlock();
            this.setPositions(eTrace, beginHeader.b(), eH.e());
            eBlock.getBody().add((Object)eTrace);
            this.parseTraceHeader(beginHeader.e(), eH.b(), eTrace);
        } else {
            Region eB = this.pTrace.searchEndBodyAtEndHeader(this.source.getBuffer(), eH, posEnd);
            if (eB.b() == -1) {
                this.log(AcceleoParserMessages.getString(INVALID_BLOCK, "trace"), beginHeader.b(), beginHeader.e());
                posBegin = -1;
            } else {
                posBegin = eB.e();
                TraceBlock eTrace = CstFactory.eINSTANCE.createTraceBlock();
                this.setPositions(eTrace, beginHeader.b(), eB.e());
                eBlock.getBody().add((Object)eTrace);
                this.parseTraceHeader(beginHeader.e(), eH.b(), eTrace);
                this.parseTraceBody(eH.e(), eB.b(), eTrace);
            }
        }
        return posBegin;
    }

    public void parseTraceHeader(int posBegin, int posEnd, TraceBlock eTrace) {
        ModelExpression eModelExpression = CstFactory.eINSTANCE.createModelExpression();
        this.setPositions(eModelExpression, posBegin, posEnd);
        eTrace.setModelElement(eModelExpression);
        this.parseExpressionHeader(posBegin, posEnd, eModelExpression);
    }

    public void parseTraceBody(int posBegin, int posEnd, TraceBlock eTrace) {
        this.parse(posBegin, posEnd, eTrace);
    }

    private int parseProtectedAreaEnding(Region beginHeader, int posEnd, Block eBlock) {
        int posBegin;
        Region eH = this.pProtectedArea.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, posEnd);
        if (eH.b() == -1) {
            this.log(AcceleoParserMessages.getString(INVALID_BLOCK_HEADER, "protected"), beginHeader.b(), beginHeader.e());
            posBegin = -1;
        } else if (eH.getSequence() == this.pProtectedArea.getEndHeaderBody()) {
            posBegin = eH.e();
            ProtectedAreaBlock eProtectedArea = CstFactory.eINSTANCE.createProtectedAreaBlock();
            this.setPositions(eProtectedArea, beginHeader.b(), eH.e());
            eBlock.getBody().add((Object)eProtectedArea);
            this.parseProtectedAreaHeader(beginHeader.e(), eH.b(), eProtectedArea);
        } else {
            Region eB = this.pProtectedArea.searchEndBodyAtEndHeader(this.source.getBuffer(), eH, posEnd);
            if (eB.b() == -1) {
                this.log(AcceleoParserMessages.getString(INVALID_BLOCK, "protected"), beginHeader.b(), beginHeader.e());
                posBegin = -1;
            } else {
                posBegin = eB.e();
                ProtectedAreaBlock eProtectedArea = CstFactory.eINSTANCE.createProtectedAreaBlock();
                this.setPositions(eProtectedArea, beginHeader.b(), eB.e());
                eBlock.getBody().add((Object)eProtectedArea);
                this.parseProtectedAreaHeader(beginHeader.e(), eH.b(), eProtectedArea);
                this.parseProtectedAreaBody(eH.e(), eB.b(), eProtectedArea);
            }
        }
        return posBegin;
    }

    public void parseProtectedAreaHeader(int posBegin, int posEnd, ProtectedAreaBlock eProtectedArea) {
        if (ParserUtils.shiftKeyword(this.source.getBuffer(), posBegin, posEnd, "(", false) == posBegin) {
            this.log(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_ARE_REQUIRED, posBegin, posEnd);
        } else {
            Region bH = this.pAcceleo.pParenthesis.searchBeginHeader(this.source.getBuffer(), posBegin, posEnd);
            Region eH = this.pAcceleo.pParenthesis.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bH, posEnd);
            if (eH.b() == -1) {
                this.log(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_NOT_TERMINATED, bH.b(), bH.e());
            } else {
                ModelExpression eModelExpression = CstFactory.eINSTANCE.createModelExpression();
                this.setPositions(eModelExpression, bH.e(), eH.b());
                eProtectedArea.setMarker(eModelExpression);
                this.parseExpressionHeader(bH.e(), eH.b(), eModelExpression);
                if (this.source.getBuffer().substring(eH.e(), posEnd).trim().length() > 0) {
                    this.log(IAcceleoParserProblemsConstants.SYNTAX_TEXT_NOT_VALID, eH.e(), posEnd);
                }
            }
        }
    }

    public void parseProtectedAreaBody(int posBegin, int posEnd, ProtectedAreaBlock eProtectedArea) {
        this.parse(posBegin, posEnd, eProtectedArea);
    }

    private int parseExpressionEnding(Region beginHeader, int posEnd, Block eBlock) {
        int posBegin;
        Region eH = this.pExpression.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, posEnd);
        if (eH.b() == -1) {
            this.log(AcceleoParserMessages.getString("CSTParserBlock.InvalidInvocation"), beginHeader.b(), beginHeader.e());
            posBegin = -1;
        } else {
            posBegin = eH.e();
            ModelExpression eModelExpression = CstFactory.eINSTANCE.createModelExpression();
            this.setPositions(eModelExpression, beginHeader.e(), eH.b());
            eBlock.getBody().add((Object)eModelExpression);
            this.parseExpressionHeader(beginHeader.e(), eH.b(), eModelExpression);
        }
        return posBegin;
    }

    public void parseExpressionHeader(int posBegin, int posEnd, ModelExpression eModelExpression) {
        Sequence pBefore = new Sequence("before", "(");
        Sequence pEach = new Sequence("separator", "(");
        Sequence pAfter = new Sequence("after", "(");
        ISequence[] pElements = new Sequence[]{pBefore, pEach, pAfter};
        Region[] pElementsPositions = Region.createPositions(pElements.length);
        SequenceBlock[] pInhibs = new SequenceBlock[]{this.pAcceleo.pLiteral, this.pAcceleo.pParenthesis};
        Region[] pInhibsPositions = Region.createPositions(pInhibs.length);
        int i = ParserUtils.getNextSequence(this.source.getBuffer(), posBegin, posEnd, pElements, pElementsPositions, pInhibs, pInhibsPositions);
        int bBeforeEachAfter = i != -1 && pElementsPositions[i].b() != -1 ? pElementsPositions[i].b() : posEnd;
        eModelExpression.setBody(this.source.getBuffer().substring(posBegin, bBeforeEachAfter).trim());
        if (bBeforeEachAfter < posEnd) {
            int currentPosBegin = bBeforeEachAfter;
            currentPosBegin = this.shiftPrefixedOCLExpression(currentPosBegin, posEnd, "before", true, eModelExpression, (EStructuralFeature)CstPackage.eINSTANCE.getModelExpression_Before());
            currentPosBegin = this.shiftPrefixedOCLExpression(currentPosBegin, posEnd, "separator", true, eModelExpression, (EStructuralFeature)CstPackage.eINSTANCE.getModelExpression_Each());
            currentPosBegin = this.shiftPrefixedOCLExpression(currentPosBegin, posEnd, "after", true, eModelExpression, (EStructuralFeature)CstPackage.eINSTANCE.getModelExpression_After());
            if (this.source.getBuffer().substring(currentPosBegin, posEnd).trim().length() > 0) {
                this.log(IAcceleoParserProblemsConstants.SYNTAX_TEXT_NOT_VALID, currentPosBegin, posEnd);
            }
        }
    }

    private void parseText(int posBegin, int posEnd, Block eBlock) {
        if (this.source.getBuffer().substring(posBegin, posEnd).length() > 0) {
            TextExpression eText = CstFactory.eINSTANCE.createTextExpression();
            this.setPositions(eText, posBegin, posEnd);
            eText.setValue(this.source.getBuffer().substring(posBegin, posEnd));
            eBlock.getBody().add((Object)eText);
        }
    }

    private void log(String message, int posBegin, int posEnd) {
        this.source.log(message, posBegin, posEnd);
    }
}

