/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.cst.utils;

import org.eclipse.acceleo.internal.parser.cst.utils.ISequence;
import org.eclipse.acceleo.internal.parser.cst.utils.Region;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;

public class SequenceBlock
implements ISequence {
    private Sequence beginHeader;
    private Sequence endHeaderOnly;
    private Sequence endHeaderBody;
    private Sequence specHeader;
    private boolean recursiveHeader;
    private SequenceBlock[] inhibsHeader;
    private Sequence endBody;
    private Sequence specBody;
    private boolean recursiveBody;
    private SequenceBlock[] inhibsBody;

    public SequenceBlock(Sequence beginHeader, Sequence endHeaderBody, Sequence specHeader, boolean recursiveHeader, SequenceBlock[] inhibsHeader) {
        this.beginHeader = beginHeader;
        this.endHeaderOnly = null;
        this.endHeaderBody = endHeaderBody;
        this.specHeader = specHeader;
        this.recursiveHeader = recursiveHeader;
        this.inhibsHeader = inhibsHeader;
        this.endBody = null;
        this.specBody = null;
        this.recursiveBody = false;
        this.inhibsBody = null;
    }

    public SequenceBlock(Sequence beginHeader, Sequence endHeaderOnly, Sequence endHeaderBody, SequenceBlock[] inhibsHeader, Sequence endBody, Sequence specBody, SequenceBlock[] inhibsBody) {
        this.beginHeader = beginHeader;
        this.endHeaderOnly = endHeaderOnly;
        this.endHeaderBody = endHeaderBody;
        this.specHeader = null;
        this.recursiveHeader = false;
        this.inhibsHeader = inhibsHeader;
        this.endBody = endBody;
        this.specBody = specBody;
        this.recursiveBody = true;
        this.inhibsBody = inhibsBody;
    }

    public Sequence getEndHeaderOnly() {
        return this.endHeaderOnly;
    }

    public Sequence getEndHeaderBody() {
        return this.endHeaderBody;
    }

    public Region search(StringBuffer buffer, int posBegin, int posEnd) {
        return this.searchBeginHeader(buffer, posBegin, posEnd);
    }

    public Region search(StringBuffer buffer, int posBegin, int posEnd, Sequence spec, SequenceBlock[] inhibs) {
        if (this.beginHeader == null) {
            return Region.NOT_FOUND;
        }
        return this.beginHeader.search(buffer, posBegin, posEnd, spec, inhibs);
    }

    public Region searchBeginHeader(StringBuffer buffer, int posBegin, int posEnd) {
        if (this.beginHeader == null) {
            return Region.NOT_FOUND;
        }
        return this.beginHeader.search(buffer, posBegin, posEnd);
    }

    public Region searchEndBodyAtBeginHeader(StringBuffer buffer, Region indexOfBeginHeaderFound, int posEnd) {
        Region endHeader;
        Region result = Region.NOT_FOUND;
        if (indexOfBeginHeaderFound.b() != -1 && (endHeader = this.searchEndHeaderAtBeginHeader(buffer, indexOfBeginHeaderFound, posEnd)).b() != -1) {
            if (endHeader.getSequence() == this.endHeaderBody) {
                result = endHeader;
            } else if (endHeader.getSequence() == this.endHeaderOnly) {
                result = this.searchEndBodyAtEndHeader(buffer, endHeader, posEnd);
            }
        }
        return result;
    }

    public Region searchEndHeaderAtBeginHeader(StringBuffer buffer, Region indexOfBeginHeaderFound, int posEnd) {
        Region result;
        if (indexOfBeginHeaderFound.b() == -1) {
            result = Region.NOT_FOUND;
        } else if (this.endHeaderOnly == null && this.endHeaderBody == null) {
            result = indexOfBeginHeaderFound;
        } else {
            result = null;
            int nbBeginTagOuvert = 1;
            int pos = indexOfBeginHeaderFound.e();
            int inhibsLength = 0;
            if (this.inhibsHeader != null) {
                inhibsLength = this.inhibsHeader.length;
            }
            Region[] positions = Region.createPositions(4 + inhibsLength);
            while (result == null && pos > -1 && pos < posEnd) {
                int iPositionMin = this.getOrCreateIndexOfHeaderNextPosition(positions, buffer, pos, posEnd);
                if (iPositionMin == -1) {
                    result = Region.NOT_FOUND;
                    continue;
                }
                if (iPositionMin == 0) {
                    pos = positions[iPositionMin].e();
                    continue;
                }
                if (!this.recursiveHeader && iPositionMin == 1) {
                    result = positions[iPositionMin];
                    continue;
                }
                if (nbBeginTagOuvert == 1 && iPositionMin == 1) {
                    result = positions[iPositionMin];
                    continue;
                }
                if (iPositionMin == 1) {
                    --nbBeginTagOuvert;
                    pos = positions[iPositionMin].e();
                    continue;
                }
                if (!this.recursiveHeader && iPositionMin == 2) {
                    result = positions[iPositionMin];
                    continue;
                }
                if (nbBeginTagOuvert == 1 && iPositionMin == 2) {
                    result = positions[iPositionMin];
                    continue;
                }
                if (iPositionMin == 2) {
                    --nbBeginTagOuvert;
                    pos = positions[iPositionMin].e();
                    continue;
                }
                if (iPositionMin == 3) {
                    ++nbBeginTagOuvert;
                    pos = positions[iPositionMin].e();
                    continue;
                }
                if (iPositionMin < 4) continue;
                pos = this.inhibsHeader[iPositionMin - 4].searchEndBodyAtBeginHeader(buffer, positions[iPositionMin], posEnd).e();
            }
            if (result == null) {
                result = Region.NOT_FOUND;
            }
        }
        return result;
    }

    private int getOrCreateIndexOfHeaderNextPosition(Region[] positions, StringBuffer buffer, int pos, int posEnd) {
        if (positions[0].b() != -1 && this.specHeader != null && pos > positions[0].b()) {
            positions[0] = this.specHeader.search(buffer, pos, posEnd);
        }
        if (positions[1].b() != -1 && this.endHeaderOnly != null && pos > positions[1].b()) {
            positions[1] = this.endHeaderOnly.search(buffer, pos, posEnd);
        }
        if (positions[2].b() != -1 && this.endHeaderBody != null && pos > positions[2].b()) {
            positions[2] = this.endHeaderBody.search(buffer, pos, posEnd);
        }
        if (positions[3].b() != -1 && this.beginHeader != null && this.recursiveHeader && pos > positions[3].b()) {
            positions[3] = this.beginHeader.search(buffer, pos, posEnd);
        }
        int i = 4;
        while (i < positions.length) {
            if (positions[i].b() != -1 && pos > positions[i].b()) {
                positions[i] = this.inhibsHeader[i - 4].searchBeginHeader(buffer, pos, posEnd);
            }
            ++i;
        }
        int positionMin = posEnd;
        int iPositionMin = -1;
        int i2 = 0;
        while (i2 < positions.length) {
            if (positions[i2].b() > -1 && positions[i2].b() < positionMin) {
                iPositionMin = i2;
                positionMin = positions[i2].b();
            }
            ++i2;
        }
        return iPositionMin;
    }

    public Region searchEndBodyAtEndHeader(StringBuffer buffer, Region indexOfEndHeaderFound, int posEnd) {
        Region result;
        if (indexOfEndHeaderFound.b() == -1) {
            result = Region.NOT_FOUND;
        } else if (this.endBody == null) {
            result = indexOfEndHeaderFound;
        } else {
            result = null;
            int nbBeginTagOuvert = 1;
            int pos = indexOfEndHeaderFound.e();
            int inhibsLength = 0;
            if (this.inhibsBody != null) {
                inhibsLength = this.inhibsBody.length;
            }
            Region[] positions = Region.createPositions(3 + inhibsLength);
            while (result == null && pos > -1 && pos < posEnd) {
                int iPositionMin = this.getOrCreateIndexOfBodyNextPosition(positions, buffer, pos, posEnd);
                if (iPositionMin == -1) {
                    result = Region.NOT_FOUND;
                    continue;
                }
                if (iPositionMin == 0) {
                    pos = positions[iPositionMin].e();
                    continue;
                }
                if (!this.recursiveBody && iPositionMin == 1) {
                    result = positions[iPositionMin];
                    continue;
                }
                if (nbBeginTagOuvert == 1 && iPositionMin == 1) {
                    result = positions[iPositionMin];
                    continue;
                }
                if (iPositionMin == 1) {
                    --nbBeginTagOuvert;
                    pos = positions[iPositionMin].e();
                    continue;
                }
                if (iPositionMin == 2) {
                    ++nbBeginTagOuvert;
                    pos = positions[iPositionMin].e();
                    continue;
                }
                if (iPositionMin < 3) continue;
                pos = this.inhibsBody[iPositionMin - 3].searchEndBodyAtBeginHeader(buffer, positions[iPositionMin], posEnd).e();
            }
            if (result == null) {
                result = Region.NOT_FOUND;
            }
        }
        return result;
    }

    private int getOrCreateIndexOfBodyNextPosition(Region[] positions, StringBuffer buffer, int pos, int posEnd) {
        if (positions[0].b() != -1 && this.specBody != null && pos > positions[0].b()) {
            positions[0] = this.specBody.search(buffer, pos, posEnd);
        }
        if (positions[1].b() != -1 && this.endBody != null && pos > positions[1].b()) {
            positions[1] = this.endBody.search(buffer, pos, posEnd);
        }
        if (positions[2].b() != -1 && this.beginHeader != null && this.recursiveBody && pos > positions[2].b()) {
            positions[2] = this.beginHeader.search(buffer, pos, posEnd);
        }
        int i = 3;
        while (i < positions.length) {
            if (positions[i].b() != -1 && pos > positions[i].b()) {
                positions[i] = this.inhibsBody[i - 3].searchBeginHeader(buffer, pos, posEnd);
            }
            ++i;
        }
        int positionMin = posEnd;
        int iPositionMin = -1;
        int i2 = 0;
        while (i2 < positions.length) {
            if (positions[i2].b() > -1 && positions[i2].b() < positionMin) {
                iPositionMin = i2;
                positionMin = positions[i2].b();
            }
            ++i2;
        }
        return iPositionMin;
    }
}

