/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.compiler;

import java.net.URI;
import org.eclipse.jet.compiler.TemplatePathUtil;
import org.eclipse.jet.core.parser.ProblemSeverity;
import org.eclipse.jet.internal.parser.ParseProblemSeverity;

public final class Problem {
    public static final int MissingXmlStartTag = 1;
    public static final int MissingXmlEndTag = 2;
    public static final int MissingRequiredAttribute = 3;
    public static final int DuplicateXMLNamespacePrefix = 4;
    public static final int UnknownTagLibrary = 5;
    public static final int UnknownAttributeInTag = 6;
    public static final int UnterminatedXMLTag = 7;
    public static final int DuplicateAttribute = 8;
    public static final int JETException = 9;
    public static final int MultipleTemplatesWithSameJavaClass = 10;
    public static final int DeprecatedAttribute = 11;
    public static final int TagCannotHaveContent = 12;
    public static final int TagCannotBeEmpty = 13;
    public static final int DeprecatedTag = 14;
    public static final int UnsupportedDirective = 15;
    public static final int UnknownXMLTag = 16;
    public static final int TagInterpretedAsEmptyTag = 17;
    private final org.eclipse.jet.core.parser.ast.Problem delegate;

    public Problem(String originatingFileName, ParseProblemSeverity severity, int id, String message, Object[] messageArgs, int start, int end, int lineNumber, int colOffset) {
        this(TemplatePathUtil.baseLocationURI(originatingFileName), TemplatePathUtil.templatePath(originatingFileName), severity == ParseProblemSeverity.ERROR ? ProblemSeverity.ERROR : ProblemSeverity.WARNING, id, message, messageArgs, start, end, lineNumber, colOffset);
    }

    public Problem(URI baseLocation, String templatePath, ProblemSeverity severity, int id, String message, Object[] messageArgs, int start, int end, int lineNumber, int colOffset) {
        this(new org.eclipse.jet.core.parser.ast.Problem(baseLocation, templatePath, severity, id, message, messageArgs, start, end, lineNumber, colOffset));
    }

    Problem(org.eclipse.jet.core.parser.ast.Problem problem) {
        this.delegate = problem;
    }

    public int getEnd() {
        return this.delegate.getEnd();
    }

    public int getId() {
        return this.delegate.getId();
    }

    public int getLineNumber() {
        return this.delegate.getLineNumber();
    }

    public String getMessage() {
        return this.delegate.getMessage();
    }

    public Object[] getMessageArgs() {
        return this.delegate.getMessageArgs();
    }

    public String getOriginatingFileName() {
        return this.delegate.getOriginatingFileName();
    }

    public ParseProblemSeverity getSeverity() {
        ProblemSeverity problemSeverity = this.delegate.getProblemSeverity();
        if (problemSeverity == ProblemSeverity.ERROR) {
            return ParseProblemSeverity.ERROR;
        }
        if (problemSeverity == ProblemSeverity.WARNING) {
            return ParseProblemSeverity.WARNING;
        }
        throw new IllegalStateException();
    }

    public int getStart() {
        return this.delegate.getStart();
    }

    public final int getColOffset() {
        return this.delegate.getColOffset();
    }

    public ProblemSeverity getProblemSeverity() {
        return this.delegate.getProblemSeverity();
    }
}

